/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.SyntheticAttribute;
import ai.h2o.javassist.compiler.CompileError;
import java.util.HashMap;
import java.util.Map;

public class AccessorMaker {
    private CtClass clazz;
    private int uniqueNumber;
    private Map<String, Object> accessors;
    static final String lastParamType = "ai.h2o.javassist.runtime.Inner";

    public AccessorMaker(CtClass c2) {
        this.clazz = c2;
        this.uniqueNumber = 1;
        this.accessors = new HashMap<String, Object>();
    }

    public String getConstructor(CtClass c2, String desc, MethodInfo orig) throws CompileError {
        String string = "<init>:" + desc;
        String string2 = (String)this.accessors.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = Descriptor.appendParameter(lastParamType, desc);
        ClassFile classFile = this.clazz.getClassFile();
        try {
            ConstPool constPool = classFile.getConstPool();
            ClassPool classPool = this.clazz.getClassPool();
            MethodInfo methodInfo = new MethodInfo(constPool, "<init>", string2);
            methodInfo.setAccessFlags(0);
            methodInfo.addAttribute(new SyntheticAttribute(constPool));
            ExceptionsAttribute exceptionsAttribute = orig.getExceptionsAttribute();
            if (exceptionsAttribute != null) {
                methodInfo.addAttribute(exceptionsAttribute.copy(constPool, null));
            }
            CtClass[] ctClassArray = Descriptor.getParameterTypes(desc, classPool);
            Bytecode bytecode = new Bytecode(constPool);
            bytecode.addAload(0);
            int n2 = 1;
            for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                n2 += bytecode.addLoad(n2, ctClassArray[i2]);
            }
            bytecode.setMaxLocals(n2 + 1);
            bytecode.addInvokespecial(this.clazz, "<init>", desc);
            bytecode.addReturn(null);
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException);
        }
        this.accessors.put(string, string2);
        return string2;
    }

    public String getMethodAccessor(String name, String desc, String accDesc, MethodInfo orig) throws CompileError {
        String string = name + ":" + desc;
        String string2 = (String)this.accessors.get(string);
        if (string2 != null) {
            return string2;
        }
        ClassFile classFile = this.clazz.getClassFile();
        string2 = this.findAccessorName(classFile);
        try {
            ConstPool constPool = classFile.getConstPool();
            ClassPool classPool = this.clazz.getClassPool();
            MethodInfo methodInfo = new MethodInfo(constPool, string2, accDesc);
            methodInfo.setAccessFlags(8);
            methodInfo.addAttribute(new SyntheticAttribute(constPool));
            ExceptionsAttribute exceptionsAttribute = orig.getExceptionsAttribute();
            if (exceptionsAttribute != null) {
                methodInfo.addAttribute(exceptionsAttribute.copy(constPool, null));
            }
            CtClass[] ctClassArray = Descriptor.getParameterTypes(accDesc, classPool);
            int n2 = 0;
            Bytecode bytecode = new Bytecode(constPool);
            for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                n2 += bytecode.addLoad(n2, ctClassArray[i2]);
            }
            bytecode.setMaxLocals(n2);
            if (desc == accDesc) {
                bytecode.addInvokestatic(this.clazz, name, desc);
            } else {
                bytecode.addInvokevirtual(this.clazz, name, desc);
            }
            bytecode.addReturn(Descriptor.getReturnType(desc, classPool));
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException);
        }
        this.accessors.put(string, string2);
        return string2;
    }

    public MethodInfo getFieldGetter(FieldInfo finfo, boolean is_static) throws CompileError {
        String string = finfo.getName();
        String string2 = string + ":getter";
        Object object = this.accessors.get(string2);
        if (object != null) {
            return (MethodInfo)object;
        }
        ClassFile classFile = this.clazz.getClassFile();
        String string3 = this.findAccessorName(classFile);
        try {
            ConstPool constPool = classFile.getConstPool();
            ClassPool classPool = this.clazz.getClassPool();
            String string4 = finfo.getDescriptor();
            String string5 = is_static ? "()" + string4 : "(" + Descriptor.of(this.clazz) + ")" + string4;
            MethodInfo methodInfo = new MethodInfo(constPool, string3, string5);
            methodInfo.setAccessFlags(8);
            methodInfo.addAttribute(new SyntheticAttribute(constPool));
            Bytecode bytecode = new Bytecode(constPool);
            if (is_static) {
                bytecode.addGetstatic(Bytecode.THIS, string, string4);
            } else {
                bytecode.addAload(0);
                bytecode.addGetfield(Bytecode.THIS, string, string4);
                bytecode.setMaxLocals(1);
            }
            bytecode.addReturn(Descriptor.toCtClass(string4, classPool));
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
            this.accessors.put(string2, methodInfo);
            return methodInfo;
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException);
        }
    }

    public MethodInfo getFieldSetter(FieldInfo finfo, boolean is_static) throws CompileError {
        String string = finfo.getName();
        String string2 = string + ":setter";
        Object object = this.accessors.get(string2);
        if (object != null) {
            return (MethodInfo)object;
        }
        ClassFile classFile = this.clazz.getClassFile();
        String string3 = this.findAccessorName(classFile);
        try {
            int n2;
            ConstPool constPool = classFile.getConstPool();
            ClassPool classPool = this.clazz.getClassPool();
            String string4 = finfo.getDescriptor();
            String string5 = is_static ? "(" + string4 + ")V" : "(" + Descriptor.of(this.clazz) + string4 + ")V";
            MethodInfo methodInfo = new MethodInfo(constPool, string3, string5);
            methodInfo.setAccessFlags(8);
            methodInfo.addAttribute(new SyntheticAttribute(constPool));
            Bytecode bytecode = new Bytecode(constPool);
            if (is_static) {
                n2 = bytecode.addLoad(0, Descriptor.toCtClass(string4, classPool));
                bytecode.addPutstatic(Bytecode.THIS, string, string4);
            } else {
                bytecode.addAload(0);
                n2 = bytecode.addLoad(1, Descriptor.toCtClass(string4, classPool)) + 1;
                bytecode.addPutfield(Bytecode.THIS, string, string4);
            }
            bytecode.addReturn(null);
            bytecode.setMaxLocals(n2);
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
            this.accessors.put(string2, methodInfo);
            return methodInfo;
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException);
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException);
        }
    }

    private String findAccessorName(ClassFile cf) {
        String string;
        while (cf.getMethod(string = "access$" + this.uniqueNumber++) != null) {
        }
        return string;
    }
}

