/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.expr;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.expr.Expr;

public class Handler
extends Expr {
    private static String EXCEPTION_NAME = "$1";
    private ExceptionTable etable;
    private int index;

    protected Handler(ExceptionTable et, int nth, CodeIterator it, CtClass declaring, MethodInfo m2) {
        super(et.handlerPc(nth), it, declaring, m2);
        this.etable = et;
        this.index = nth;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getType() throws NotFoundException {
        int n2 = this.etable.catchType(this.index);
        if (n2 == 0) {
            return null;
        }
        ConstPool constPool = this.getConstPool();
        String string = constPool.getClassInfo(n2);
        return this.thisClass.getClassPool().getCtClass(string);
    }

    public boolean isFinally() {
        return this.etable.catchType(this.index) == 0;
    }

    @Override
    public void replace(String statement) throws CannotCompileException {
        throw new RuntimeException("not implemented yet");
    }

    public void insertBefore(String src) throws CannotCompileException {
        this.edited = true;
        this.getConstPool();
        CodeAttribute codeAttribute = this.iterator.get();
        Javac javac = new Javac(this.thisClass);
        Bytecode bytecode = javac.getBytecode();
        bytecode.setStackDepth(1);
        bytecode.setMaxLocals(codeAttribute.getMaxLocals());
        try {
            CtClass ctClass = this.getType();
            int n2 = javac.recordVariable(ctClass, EXCEPTION_NAME);
            javac.recordReturnType(ctClass, false);
            bytecode.addAstore(n2);
            javac.compileStmnt(src);
            bytecode.addAload(n2);
            int n3 = this.etable.handlerPc(this.index);
            bytecode.addOpcode(167);
            bytecode.addIndex(n3 - this.iterator.getCodeLength() - bytecode.currentPc() + 1);
            this.maxStack = bytecode.getMaxStack();
            this.maxLocals = bytecode.getMaxLocals();
            int n4 = this.iterator.append(bytecode.get());
            this.iterator.append(bytecode.getExceptionTable(), n4);
            this.etable.setHandlerPc(this.index, n4);
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
    }
}

