/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.PipelineWiring;
import ai.h2o.mojos.runtime.a.b;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryImpl;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.StringConverter;
import ai.h2o.mojos.runtime.frame.StringToDateConverter;
import ai.h2o.mojos.runtime.transforms.L;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.m;
import ai.h2o.mojos.runtime.utils.DateParser;
import ai.h2o.mojos.runtime.utils.MojoDateTimeParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MojoPipelineProtoImpl
extends MojoPipeline {
    private final MojoFrameMeta globalMeta;
    private final List<MojoColumnMeta> globalColumns;
    private MojoFrameMeta inputFrameMetaLazy;
    private MojoFrameMeta outputFrameMetaLazy;
    private final m root;
    private final PipelineWiring wiring;
    private final Map<String, StringConverter> dateTimeConverters = new HashMap<String, StringConverter>(0);
    private boolean shapEnabled = false;
    private final Set<MojoColumnMeta> shapContribColumns = new LinkedHashSet<MojoColumnMeta>();

    public MojoPipelineProtoImpl(List<MojoColumnMeta> globalColumns, m root) {
        super(root.b.uuid, root.b.creationTime, root.b.license);
        this.root = root;
        this.globalColumns = globalColumns;
        this.globalMeta = new MojoFrameMeta(globalColumns);
        root.b.consistencyChecks(this.globalMeta);
        this.wiring = new PipelineWiring(this.globalMeta, root);
        if (root.b.datetimeStringFormats != null) {
            for (Map.Entry<String, String> entry : root.b.datetimeStringFormats.entrySet()) {
                DateParser dateParser = new DateParser(MojoDateTimeParserFactory.forPattern(entry.getValue()));
                this.dateTimeConverters.put(entry.getKey(), new StringToDateConverter(dateParser));
            }
        }
    }

    @Override
    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Arrays.asList(this.root.b.missingValues), this.dateTimeConverters);
    }

    @Override
    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                if (this.inputFrameMetaLazy == null) {
                    this.inputFrameMetaLazy = this.globalMeta.subFrame(this.root.iindices);
                }
                return this.inputFrameMetaLazy;
            }
            case Output: {
                if (this.outputFrameMetaLazy == null) {
                    this.outputFrameMetaLazy = this.initOutputFrameMeta();
                }
                if (this.outputFrameMetaLazy.size() == 0) {
                    throw new IllegalStateException("No columns in output frame");
                }
                return this.outputFrameMetaLazy;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    private MojoFrameMeta initOutputFrameMeta() {
        if (!this.shapEnabled) {
            return this.globalMeta.subFrame(this.root.oindices);
        }
        for (MojoTransformMeta mojoTransformMeta : this.wiring.transformsFlattened) {
            MojoTransform mojoTransform = mojoTransformMeta.getTransform();
            if (!(mojoTransform instanceof L)) continue;
            L l2 = (L)((Object)mojoTransform);
            if (!l2.a()) {
                throw new UnsupportedOperationException(String.format("Missing SHAP data in %s model", mojoTransformMeta.getName()));
            }
            this.shapContribColumns.addAll(l2.a(this.wiring));
        }
        b b2 = new b(this.globalMeta, this.wiring);
        b2.a(this.root.oindices);
        return new MojoFrameMeta(new ArrayList<MojoColumnMeta>(this.shapContribColumns));
    }

    MojoFrame constructGlobalFrame(MojoFrame inputFrame, MojoFrame outputFrame) {
        ArrayList<MojoColumn> arrayList = new ArrayList<MojoColumn>();
        MojoFrameMeta mojoFrameMeta = inputFrame.getMeta();
        MojoFrameMeta mojoFrameMeta2 = outputFrame.getMeta();
        ArrayList<MojoColumnMeta> arrayList2 = new ArrayList<MojoColumnMeta>(this.globalColumns);
        if (this.shapEnabled) {
            arrayList2.addAll(this.shapContribColumns);
        }
        int n2 = inputFrame.getNrows();
        MojoColumnFactoryImpl mojoColumnFactoryImpl = new MojoColumnFactoryImpl();
        for (MojoColumnMeta mojoColumnMeta : arrayList2) {
            Integer n3 = mojoFrameMeta.indexOf(mojoColumnMeta);
            if (n3 != null) {
                arrayList.add(inputFrame.getColumn(n3));
                continue;
            }
            Integer n4 = mojoFrameMeta2.indexOf(mojoColumnMeta);
            if (n4 != null) {
                arrayList.add(outputFrame.getColumn(n4));
                continue;
            }
            MojoColumn mojoColumn = mojoColumnFactoryImpl.create(mojoColumnMeta.getColumnType(), n2);
            arrayList.add(mojoColumn);
        }
        return MojoFrameBuilder.fromColumns(new MojoFrameMeta(arrayList2), arrayList.toArray(new MojoColumn[0]));
    }

    @Override
    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        assert (outputFrame.getNcols() > 0);
        MojoFrame mojoFrame = this.constructGlobalFrame(inputFrame, outputFrame);
        for (MojoTransformMeta mojoTransformMeta : this.wiring.transformsFlattened) {
            MojoTransform mojoTransform = mojoTransformMeta.getTransform();
            mojoTransform.transform(mojoFrame);
            if (!this.shapEnabled || !(mojoTransform instanceof L)) continue;
            L l2 = (L)((Object)mojoTransformMeta.getTransform());
            l2.a(mojoFrame, outputFrame, this.wiring);
        }
        return outputFrame;
    }

    @Override
    public void setShapPredictContrib(boolean enable) {
        if (enable == this.shapEnabled) {
            return;
        }
        if (this.outputFrameMetaLazy != null) {
            throw new IllegalStateException("Cannot change SHAP flag after internal output columns have been created");
        }
        this.shapEnabled = enable;
    }
}

