/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.MojoTransformationGroup;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.L;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.m;
import ai.h2o.mojos.runtime.utils.ArrayReaderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PipelineWiring {
    private final MojoFrameMeta globalMeta;
    public final List<MojoTransformMeta> transformsFlattened = new ArrayList<MojoTransformMeta>();
    private final MojoTransformMeta[] producers;
    private final Set<String> transformedFeatures;

    public PipelineWiring(MojoFrameMeta globalMeta, m root) {
        this.globalMeta = globalMeta;
        this.transformedFeatures = root.b.transformedFeatures == null ? Collections.emptySet() : new LinkedHashSet<String>(root.b.transformedFeatures);
        this.addChildrenFlattened(root.a);
        this.producers = new MojoTransformMeta[globalMeta.size()];
        for (MojoTransformMeta mojoTransformMeta : this.transformsFlattened) {
            for (int n2 : mojoTransformMeta.getOutputIndices()) {
                this.producers[n2] = mojoTransformMeta;
            }
        }
    }

    private void addChildrenFlattened(List<MojoTransformMeta> nestedTransforms) {
        for (MojoTransformMeta mojoTransformMeta : nestedTransforms) {
            MojoTransform mojoTransform = mojoTransformMeta.getTransform();
            if (mojoTransform instanceof m) {
                m m2 = (m)mojoTransform;
                this.addChildrenFlattened(m2.a);
                continue;
            }
            this.transformsFlattened.add(mojoTransformMeta);
        }
    }

    public MojoTransformMeta getProducer(int columnIndex) {
        return this.producers[columnIndex];
    }

    public List<MojoColumnMeta> getColumns() {
        return this.globalMeta.getColumns();
    }

    public <R> List<R> search(Collection<Integer> entryPoints, Visitor<R> visitor) {
        Integer n2;
        LinkedHashSet<MojoTransformMeta> linkedHashSet = new LinkedHashSet<MojoTransformMeta>();
        ArrayList<R> arrayList = new ArrayList<R>();
        LinkedList<Integer> linkedList = new LinkedList<Integer>(entryPoints);
        while ((n2 = linkedList.pollFirst()) != null) {
            MojoTransformMeta mojoTransformMeta = this.getProducer(n2);
            if (mojoTransformMeta == null || linkedHashSet.contains(mojoTransformMeta)) continue;
            linkedHashSet.add(mojoTransformMeta);
            try {
                R r2 = visitor.visit(this, mojoTransformMeta);
                if (r2 != null) {
                    arrayList.add(r2);
                    continue;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            linkedList.addAll(ArrayReaderUtils.fromArrayToList(mojoTransformMeta.getInputIndices()));
        }
        return arrayList;
    }

    public MojoTransformMeta shapCapableOrigin(MojoTransformMeta producer) {
        int[] nArray;
        int n2;
        do {
            if ((nArray = producer.getInputIndices()).length == 1) continue;
            throw new IllegalArgumentException("only 1:1 transform expected while traversing from blending operations up to the ShapCapable model, but found " + producer.getName());
        } while (!((producer = this.getProducer(n2 = nArray[0])).getTransform() instanceof L));
        return producer;
    }

    private MojoColumnMeta getGroupInputColumn(MojoTransformationGroup tg, int inputIndex) {
        int n2 = this.getGroupInputColumnIndex(tg, inputIndex);
        return this.getColumns().get(n2);
    }

    public int getGroupInputColumnIndex(MojoTransformationGroup tg, int inputIndex) {
        int n2 = inputIndex;
        if (tg != null) {
            MojoTransformationGroup mojoTransformationGroup;
            MojoTransformMeta mojoTransformMeta;
            while ((mojoTransformMeta = this.getProducer(n2)) != null && (mojoTransformationGroup = mojoTransformMeta.getTransformationGroup()) != null && mojoTransformationGroup.getId().equals(tg.getId())) {
                int[] nArray = mojoTransformMeta.getInputIndices();
                if (nArray.length != 1) {
                    throw new IllegalStateException(String.format("producer of column #%d has %d columns; exactly 1 is required: %s", n2, nArray.length, mojoTransformMeta));
                }
                if (mojoTransformMeta.getOutputIndices().length != 1) {
                    throw new IllegalStateException(String.format("producer of column #%d has %d columns; exactly 1 is required: %s", n2, mojoTransformMeta.getOutputIndices().length, mojoTransformMeta));
                }
                String string = this.globalMeta.getColumnName(n2);
                if (this.transformedFeatures.contains(string)) break;
                n2 = nArray[0];
            }
        }
        return n2;
    }

    public int[] getGroupInputIndices(int[] featureIndices, MojoTransformationGroup transformationGroup) {
        int[] nArray = new int[featureIndices.length];
        for (int i2 = 0; i2 < featureIndices.length; ++i2) {
            int n2 = featureIndices[i2];
            nArray[i2] = this.getGroupInputColumnIndex(transformationGroup, n2);
        }
        return nArray;
    }

    public Set<String> getGroupInputColumns(MojoTransformationGroup tg, int[] inputIndices) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int[] nArray = inputIndices;
        int n2 = inputIndices.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            MojoColumnMeta mojoColumnMeta = this.getGroupInputColumn(tg, n3);
            linkedHashSet.add(mojoColumnMeta.getColumnName());
        }
        return linkedHashSet;
    }

    public static interface Visitor<R> {
        public R visit(PipelineWiring var1, MojoTransformMeta var2) throws IllegalArgumentException;
    }
}

