/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.ArrayList;
import java.util.List;

public class MojoColumnMeta {
    private final String columnName;
    private final String shapInputColName;
    private final Integer shapOutputGroup;
    private final MojoColumn.Type columnType;
    private final MojoColumn.Kind kind;

    public MojoColumnMeta(String columnName, MojoColumn.Type columnType, MojoColumn.Kind kind) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.kind = kind;
        this.shapInputColName = null;
        this.shapOutputGroup = null;
    }

    public String getShapInputColName() {
        return this.shapInputColName;
    }

    public Integer getShapOutputGroup() {
        return this.shapOutputGroup;
    }

    private MojoColumnMeta(String columnName, String shapInputColName, Integer shapOutputGroup) {
        this.columnName = columnName;
        this.shapInputColName = shapInputColName;
        this.shapOutputGroup = shapOutputGroup;
        this.columnType = MojoColumn.Type.Float64;
        this.kind = MojoColumn.Kind.Output;
    }

    public static MojoColumnMeta newInput(String columnName, MojoColumn.Type columnType) {
        return new MojoColumnMeta(columnName, columnType, MojoColumn.Kind.Feature);
    }

    public static MojoColumnMeta newOutput(String name, MojoColumn.Type columnType) {
        return new MojoColumnMeta(name, columnType, MojoColumn.Kind.Output);
    }

    public static MojoColumnMeta newOutputShap(String name, String shapInputColName, Integer shapOutputGroup) {
        return new MojoColumnMeta(name, shapInputColName, shapOutputGroup);
    }

    public static MojoColumnMeta newInterim(String name, MojoColumn.Type colType) {
        return new MojoColumnMeta(name, colType, MojoColumn.Kind.Interim);
    }

    public static List<MojoColumnMeta> toColumns(String[] columnNames, MojoColumn.Type[] columnTypes, MojoColumn.Kind kind) {
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("columnNames and columnTypes arguments must have the same length");
        }
        ArrayList<MojoColumnMeta> arrayList = new ArrayList<MojoColumnMeta>();
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            MojoColumnMeta mojoColumnMeta = new MojoColumnMeta(columnNames[i2], columnTypes[i2], kind);
            arrayList.add(mojoColumnMeta);
        }
        return arrayList;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public MojoColumn.Type getColumnType() {
        return this.columnType;
    }

    public boolean isInputFeature() {
        return this.kind == MojoColumn.Kind.Feature;
    }

    public boolean isOutputColumn() {
        return this.kind == MojoColumn.Kind.Output;
    }

    public boolean isOutputShapColumn() {
        return this.kind == MojoColumn.Kind.Output && this.shapOutputGroup != null;
    }

    public String toString() {
        if (this.isOutputShapColumn()) {
            return String.format("OutputShap{name:'%s',outputGroup=%s}", this.columnName, this.shapOutputGroup);
        }
        return String.format("%s{name:'%s',type=%s}", new Object[]{this.kind.toString(), this.columnName, this.columnType});
    }

    public boolean equals(Object o2) {
        return super.equals(o2);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

