/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.DateParser;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatterBuilder;

public class MojoDateTime {
    public static final DateTimeZone TIMEZONE = DateTimeZone.UTC;
    private static DateTime NOW = DateTime.now(TIMEZONE);
    private int _YEAR;
    private int _MONTH;
    private int _WEEK_OF_YEAR;
    private int _DAY;
    private int _DAY_OF_YEAR;
    private int _DAY_OF_WEEK;
    private int _HOUR;
    private int _MINUTE;
    private int _SECOND;
    private long _MILLIS_FROM_UNIX;

    public MojoDateTime(long millisFromUnix) {
        this(new DateTime(millisFromUnix, TIMEZONE));
    }

    private MojoDateTime(DateTime dt) {
        if (dt.isSupported(DateTimeFieldType.year())) {
            this._YEAR = dt.get(DateTimeFieldType.year());
            if (dt.isSupported(DateTimeFieldType.monthOfYear())) {
                this._MONTH = dt.get(DateTimeFieldType.monthOfYear());
                this._DAY = dt.isSupported(DateTimeFieldType.dayOfMonth()) ? dt.get(DateTimeFieldType.dayOfMonth()) : 1;
            } else {
                this._MONTH = 1;
                this._DAY = 1;
            }
        } else {
            this._YEAR = NOW.getYear();
            this._MONTH = NOW.getMonthOfYear();
            this._DAY = NOW.getDayOfMonth();
        }
        LocalDate localDate = new LocalDate(this._YEAR, this._MONTH, this._DAY);
        if (dt.isSupported(DateTimeFieldType.dayOfYear()) && dt.isSupported(DateTimeFieldType.dayOfWeek())) {
            this._DAY_OF_YEAR = dt.get(DateTimeFieldType.dayOfYear());
            this._DAY_OF_WEEK = dt.get(DateTimeFieldType.dayOfWeek());
        } else {
            this._DAY_OF_YEAR = localDate.getDayOfYear();
            this._DAY_OF_WEEK = localDate.getDayOfWeek();
        }
        if (dt.isSupported(DateTimeFieldType.weekOfWeekyear())) {
            this._WEEK_OF_YEAR = dt.get(DateTimeFieldType.weekOfWeekyear());
        }
        if (dt.isSupported(DateTimeFieldType.hourOfDay())) {
            this._HOUR = dt.get(DateTimeFieldType.hourOfDay());
            if (dt.isSupported(DateTimeFieldType.minuteOfHour())) {
                this._MINUTE = dt.get(DateTimeFieldType.minuteOfHour());
                this._SECOND = dt.isSupported(DateTimeFieldType.secondOfMinute()) ? dt.get(DateTimeFieldType.secondOfMinute()) : 0;
            } else {
                this._MINUTE = 0;
                this._SECOND = 0;
            }
        } else {
            this._HOUR = 0;
            this._MINUTE = 0;
            this._SECOND = 0;
        }
        this._MILLIS_FROM_UNIX = dt.getMillis();
    }

    public static MojoDateTime parse(String s2) {
        DateTime dateTime = DateParser.DTF.withZone(TIMEZONE).parseDateTime(s2);
        return new MojoDateTime(dateTime);
    }

    public static MojoDateTime parse(String s2, DateParser parser) {
        return parser.parse(s2);
    }

    public static MojoDateTime create(DateTime s2) {
        return new MojoDateTime(s2);
    }

    public int getYear() {
        return this._YEAR;
    }

    public int getQuarter() {
        return (this._MONTH - 1) / 3 + 1;
    }

    public int getMonth() {
        return this._MONTH;
    }

    public int getDay() {
        return this._DAY;
    }

    public int getDayOfYear() {
        return this._DAY_OF_YEAR;
    }

    public int getWeekOfYear() {
        return this._WEEK_OF_YEAR;
    }

    public int getDayOfWeek() {
        return this._DAY_OF_WEEK - 1;
    }

    public int getHour() {
        return this._HOUR;
    }

    public int getMinute() {
        return this._MINUTE;
    }

    public int getSecond() {
        return this._SECOND;
    }

    public long getMillis() {
        return this._MILLIS_FROM_UNIX;
    }

    public static final DateTimeFormatterBuilder genFormatterBuilder(DateTimeFormatterBuilder dtfb, String[] formats) {
        String[] stringArray = formats;
        int n2 = formats.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            dtfb.appendOptional(DateTimeFormat.forPattern(string).getParser());
        }
        return dtfb;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MojoDateTime mojoDateTime = (MojoDateTime)o2;
        return this._YEAR == mojoDateTime._YEAR && this._MONTH == mojoDateTime._MONTH && this._WEEK_OF_YEAR == mojoDateTime._WEEK_OF_YEAR && this._DAY == mojoDateTime._DAY && this._DAY_OF_YEAR == mojoDateTime._DAY_OF_YEAR && this._DAY_OF_WEEK == mojoDateTime._DAY_OF_WEEK && this._HOUR == mojoDateTime._HOUR && this._MINUTE == mojoDateTime._MINUTE && this._SECOND == mojoDateTime._SECOND;
    }

    public int hashCode() {
        return Objects.hash(this._YEAR, this._MONTH, this._WEEK_OF_YEAR, this._DAY, this._DAY_OF_YEAR, this._DAY_OF_WEEK, this._HOUR, this._MINUTE, this._SECOND);
    }

    public String toString() {
        return "MojoDateTime{_YEAR=" + this._YEAR + ", _MONTH=" + this._MONTH + ", _WEEK_OF_YEAR=" + this._WEEK_OF_YEAR + ", _DAY=" + this._DAY + ", _DAY_OF_YEAR=" + this._DAY_OF_YEAR + ", _DAY_OF_WEEK=" + this._DAY_OF_WEEK + ", _HOUR=" + this._HOUR + ", _MINUTE=" + this._MINUTE + ", _SECOND=" + this._SECOND + '}';
    }

    public static enum DatePart {
        YEAR("year"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getYear())";
            }
        }
        ,
        QUARTER("quarter"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getQuarter())";
            }
        }
        ,
        MONTH("month"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getMonth())";
            }
        }
        ,
        WEEK("week"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getWeekOfYear())";
            }
        }
        ,
        WEEKDAY("weekday"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getDayOfWeek())";
            }
        }
        ,
        DAY("day"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getDay())";
            }
        }
        ,
        DAYOFYEAR("dayofyear"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getDayOfYear())";
            }
        }
        ,
        HOUR("hour"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getHour())";
            }
        }
        ,
        MINUTE("minute"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getMinute())";
            }
        }
        ,
        SECOND("second"){

            @Override
            public final String write(String var) {
                return "(" + var + ".getSecond())";
            }
        };

        private final String _name;

        private DatePart(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public abstract String write(String var1);
    }
}

