/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.opencsvUtils;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.Reader;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ObjectUtils;

public class CsvToBeanBuilder<T> {
    private MappingStrategy<T> mappingStrategy = null;
    private final Reader reader;
    private CsvToBeanFilter filter = null;
    private boolean throwExceptions = true;
    private CSVReaderNullFieldIndicator nullFieldIndicator = null;
    private boolean keepCR;
    private Integer skipLines = null;
    private Boolean verifyReader = null;
    private Character separator = null;
    private Character quoteChar = null;
    private Character escapeChar = null;
    private Boolean strictQuotes = null;
    private Boolean ignoreLeadingWhiteSpace = null;
    private Boolean ignoreQuotations = null;
    private Class<? extends T> type = null;
    private Integer multilineLimit = null;
    private boolean orderedResults = true;
    private Locale errorLocale = Locale.getDefault();

    private CsvToBeanBuilder() {
        this.reader = null;
        throw new IllegalStateException(String.format(ResourceBundle.getBundle("opencsv").getString("nullary.constructor.not.allowed"), this.getClass().getName()));
    }

    public CsvToBeanBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle("opencsv").getString("reader.null"));
        }
        this.reader = reader;
    }

    public CsvToBean<T> build() throws IllegalStateException {
        if (this.mappingStrategy == null && this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("strategy.type.missing"));
        }
        CsvToBean<T> csvToBean = new CsvToBean<T>();
        CSVParser cSVParser = this.buildParser();
        csvToBean.setCsvReader(this.buildReader(cSVParser));
        csvToBean.setThrowExceptions(this.throwExceptions);
        csvToBean.setOrderedResults(this.orderedResults);
        csvToBean.setErrorLocale(this.errorLocale);
        if (this.filter != null) {
            csvToBean.setFilter(this.filter);
        }
        if (this.mappingStrategy == null) {
            this.mappingStrategy = opencsvUtils.determineMappingStrategy(this.type, this.errorLocale);
        }
        csvToBean.setMappingStrategy(this.mappingStrategy);
        return csvToBean;
    }

    private CSVParser buildParser() {
        CSVParserBuilder cSVParserBuilder = new CSVParserBuilder();
        if (this.nullFieldIndicator != null) {
            cSVParserBuilder.withFieldAsNull(this.nullFieldIndicator);
        }
        if (this.separator != null) {
            cSVParserBuilder.withSeparator(this.separator.charValue());
        }
        if (this.quoteChar != null) {
            cSVParserBuilder.withQuoteChar(this.quoteChar.charValue());
        }
        if (this.escapeChar != null) {
            cSVParserBuilder.withEscapeChar(this.escapeChar.charValue());
        }
        if (this.strictQuotes != null) {
            cSVParserBuilder.withStrictQuotes(this.strictQuotes);
        }
        if (this.ignoreLeadingWhiteSpace != null) {
            cSVParserBuilder.withIgnoreLeadingWhiteSpace(this.ignoreLeadingWhiteSpace);
        }
        if (this.ignoreQuotations != null) {
            cSVParserBuilder.withIgnoreQuotations(this.ignoreQuotations);
        }
        cSVParserBuilder.withErrorLocale(this.errorLocale);
        return cSVParserBuilder.build();
    }

    private CSVReader buildReader(CSVParser parser) {
        CSVReaderBuilder cSVReaderBuilder = new CSVReaderBuilder(this.reader);
        cSVReaderBuilder.withCSVParser(parser);
        cSVReaderBuilder.withKeepCarriageReturn(this.keepCR);
        if (this.verifyReader != null) {
            cSVReaderBuilder.withVerifyReader(this.verifyReader);
        }
        if (this.skipLines != null) {
            cSVReaderBuilder.withSkipLines(this.skipLines);
        }
        if (this.multilineLimit != null) {
            cSVReaderBuilder.withMultilineLimit(this.multilineLimit);
        }
        cSVReaderBuilder.withErrorLocale(this.errorLocale);
        return cSVReaderBuilder.build();
    }

    public CsvToBeanBuilder<T> withMappingStrategy(MappingStrategy<T> mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        return this;
    }

    public CsvToBeanBuilder<T> withFilter(CsvToBeanFilter filter) {
        this.filter = filter;
        return this;
    }

    public CsvToBeanBuilder<T> withThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
        return this;
    }

    public CsvToBeanBuilder<T> withFieldAsNull(CSVReaderNullFieldIndicator indicator) {
        this.nullFieldIndicator = indicator;
        return this;
    }

    public CsvToBeanBuilder<T> withKeepCarriageReturn(boolean keepCR) {
        this.keepCR = keepCR;
        return this;
    }

    public CsvToBeanBuilder<T> withVerifyReader(boolean verifyReader) {
        this.verifyReader = verifyReader;
        return this;
    }

    public CsvToBeanBuilder<T> withSkipLines(int skipLines) {
        this.skipLines = skipLines;
        return this;
    }

    public CsvToBeanBuilder<T> withSeparator(char separator) {
        this.separator = Character.valueOf(separator);
        return this;
    }

    public CsvToBeanBuilder<T> withQuoteChar(char quoteChar) {
        this.quoteChar = Character.valueOf(quoteChar);
        return this;
    }

    public CsvToBeanBuilder<T> withEscapeChar(char escapeChar) {
        this.escapeChar = Character.valueOf(escapeChar);
        return this;
    }

    public CsvToBeanBuilder<T> withStrictQuotes(boolean strictQuotes) {
        this.strictQuotes = strictQuotes;
        return this;
    }

    public CsvToBeanBuilder<T> withIgnoreLeadingWhiteSpace(boolean ignoreLeadingWhiteSpace) {
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        return this;
    }

    public CsvToBeanBuilder<T> withIgnoreQuotations(boolean ignoreQuotations) {
        this.ignoreQuotations = ignoreQuotations;
        return this;
    }

    public CsvToBeanBuilder<T> withType(Class<? extends T> type) {
        this.type = type;
        return this;
    }

    public CsvToBeanBuilder<T> withMultilineLimit(int multilineLimit) {
        this.multilineLimit = multilineLimit;
        return this;
    }

    public CsvToBeanBuilder<T> withOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
        return this;
    }

    public CsvToBeanBuilder<T> withErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        return this;
    }
}

