/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.GenModel;
import hex.genmodel.easy.BinaryColumnMapper;
import hex.genmodel.easy.BinaryDomainMapConstructor;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EigenEncoderColumnMapper;
import hex.genmodel.easy.EigenEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumEncoderColumnMapper;
import hex.genmodel.easy.EnumEncoderDomainMapConstructor;
import hex.genmodel.easy.EnumLimitedEncoderColumnMapper;
import hex.genmodel.easy.EnumLimitedEncoderDomainMapConstructor;
import hex.genmodel.easy.LabelEncoderDomainMapConstructor;
import hex.genmodel.easy.OneHotEncoderColumnMapper;
import hex.genmodel.easy.OneHotEncoderDomainMapConstructor;
import java.util.Map;

public enum CategoricalEncoding {
    AUTO{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new EnumEncoderColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new EnumEncoderDomainMapConstructor(m2, columnMapping).create();
        }
    }
    ,
    OneHotExplicit{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new OneHotEncoderColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new OneHotEncoderDomainMapConstructor(m2, columnMapping).create();
        }
    }
    ,
    Binary{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new BinaryColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new BinaryDomainMapConstructor(m2, columnMapping).create();
        }
    }
    ,
    EnumLimited{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new EnumLimitedEncoderColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new EnumLimitedEncoderDomainMapConstructor(m2, columnMapping).create();
        }
    }
    ,
    Eigen{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new EigenEncoderColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new EigenEncoderDomainMapConstructor(m2, columnMapping).create();
        }
    }
    ,
    LabelEncoder{

        @Override
        public final Map<String, Integer> createColumnMapping(GenModel m2) {
            return new EnumEncoderColumnMapper(m2).create();
        }

        @Override
        public final Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel m2, Map<String, Integer> columnMapping) {
            return new LabelEncoderDomainMapConstructor(m2, columnMapping).create();
        }
    };


    public abstract Map<String, Integer> createColumnMapping(GenModel var1);

    public abstract Map<Integer, CategoricalEncoder> createCategoricalEncoders(GenModel var1, Map<String, Integer> var2);
}

