/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MultiModelMojoReader<M extends MojoModel>
extends ModelMojoReader<M> {
    private Map<String, MojoModel> _subModels;

    @Override
    protected final void readModelData() throws IOException {
        int n2 = this.readkv("submodel_count", 0);
        HashMap<String, MojoModel> hashMap = new HashMap<String, MojoModel>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)this.readkv("submodel_key_" + i2);
            String string2 = (String)this.readkv("submodel_dir_" + i2);
            MojoModel mojoModel = ModelMojoReader.readFrom(new NestedMojoReaderBackend(string2));
            hashMap.put(string, mojoModel);
        }
        this._subModels = Collections.unmodifiableMap(hashMap);
        this.readParentModelData();
    }

    protected MojoModel getModel(String key) {
        return this._subModels.get(key);
    }

    protected Map<String, MojoModel> getSubModels() {
        return this._subModels;
    }

    protected abstract void readParentModelData() throws IOException;

    private class NestedMojoReaderBackend
    implements MojoReaderBackend {
        private String _zipDirectory;

        private NestedMojoReaderBackend(String zipDirectory) {
            this._zipDirectory = zipDirectory;
        }

        @Override
        public BufferedReader getTextFile(String filename) throws IOException {
            return MultiModelMojoReader.this._reader.getTextFile(this._zipDirectory + filename);
        }

        @Override
        public byte[] getBinaryFile(String filename) throws IOException {
            return MultiModelMojoReader.this._reader.getBinaryFile(this._zipDirectory + filename);
        }

        @Override
        public boolean exists(String filename) {
            return MultiModelMojoReader.this._reader.exists(this._zipDirectory + filename);
        }
    }
}

