/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipfileMojoReaderBackend
implements MojoReaderBackend,
Closeable {
    private ZipFile zf;

    public ZipfileMojoReaderBackend(String archivename) throws IOException {
        this.zf = new ZipFile(archivename);
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        InputStream inputStream = this.zf.getInputStream(this.zf.getEntry(filename));
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    @Override
    public byte[] getBinaryFile(String filename) throws IOException {
        ZipEntry zipEntry = this.zf.getEntry(filename);
        if (zipEntry == null) {
            throw new IOException("Binary file " + filename + " not found");
        }
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        DataInputStream dataInputStream = new DataInputStream(this.zf.getInputStream(zipEntry));
        dataInputStream.readFully(byArray);
        return byArray;
    }

    @Override
    public boolean exists(String filename) {
        return this.zf.getEntry(filename) != null;
    }

    @Override
    public void close() throws IOException {
        if (this.zf != null) {
            ZipFile zipFile = this.zf;
            this.zf = null;
            zipFile.close();
        }
    }
}

