/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.coxph;

import hex.genmodel.MojoModel;
import java.util.Map;

public class CoxPHMojoModel
extends MojoModel {
    double[] _coef;
    Map<Strata, Integer> _strata;
    int _strata_len;
    double[][] _x_mean_cat;
    double[][] _x_mean_num;
    int[] _cat_offsets;
    int _cats;
    double[] _lpBase;
    boolean _useAllFactorLevels;

    CoxPHMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] predictions) {
        predictions[0] = this.forCategories(row) + this.forOtherColumns(row) - this.forStrata(row);
        return predictions;
    }

    private double forOtherColumns(double[] row) {
        double d2 = 0.0;
        int n2 = this._cat_offsets[this._cats] - this._cats;
        int n3 = this._cats;
        while (n3 + n2 < this._coef.length) {
            d2 += this._coef[n2 + n3] * row[n3 + this._strata_len];
            ++n3;
        }
        return d2;
    }

    private double forStrata(double[] row) {
        int n2 = this.strataForRow(row);
        return this._lpBase[n2];
    }

    private double forCategories(double[] row) {
        double d2 = 0.0;
        if (!this._useAllFactorLevels) {
            for (int i2 = 0; i2 < this._cat_offsets.length - 1; ++i2) {
                if (row[i2] == 0.0) continue;
                d2 += this.forOneCategory(row, i2, 1);
            }
        } else {
            for (int i3 = 0; i3 < this._cat_offsets.length - 1; ++i3) {
                d2 += this.forOneCategory(row, i3, 0);
            }
        }
        return d2;
    }

    private double forOneCategory(double[] row, int category, int lowestFactorValue) {
        int n2 = (int)row[category] - lowestFactorValue;
        if ((double)n2 != row[category] - (double)lowestFactorValue) {
            throw new IllegalArgumentException("categorical value out of range");
        }
        int n3 = n2 + this._cat_offsets[category];
        if (n3 < this._cat_offsets[category + 1]) {
            return this._coef[n3];
        }
        return 0.0;
    }

    double[] computeLpBase() {
        int n2 = this._x_mean_cat.length > 0 ? this._x_mean_cat[0].length : 0;
        int n3 = 0 < this._strata.size() ? this._strata.size() : 1;
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            for (n4 = 0; n4 < this._x_mean_cat[i2].length; ++n4) {
                int n5 = i2;
                dArray[n5] = dArray[n5] + this._x_mean_cat[i2][n4] * this._coef[n4];
            }
            for (n4 = 0; n4 < this._x_mean_num[i2].length; ++n4) {
                int n6 = i2;
                dArray[n6] = dArray[n6] + this._x_mean_num[i2][n4] * this._coef[n4 + n2];
            }
        }
        return dArray;
    }

    private int strataForRow(double[] row) {
        if (0 == this._strata.size()) {
            return 0;
        }
        Strata strata = new Strata(row, this._strata_len);
        return this._strata.get(strata);
    }

    static class Strata {
        final double[] strata;
        final int strataLen;
        final int hashCode;

        public Strata(double[] strata, int strataLen) {
            this.strata = strata;
            int n2 = 11;
            for (int i2 = 0; i2 < strataLen; ++i2) {
                n2 *= 13;
                n2 += 17 * (int)strata[i2];
            }
            this.hashCode = n2;
            this.strataLen = strataLen;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Strata strata = (Strata)o2;
            if (this.hashCode != strata.hashCode) {
                return false;
            }
            if (this.strataLen != strata.strataLen) {
                return false;
            }
            for (int i2 = 0; i2 < this.strataLen; ++i2) {
                if ((int)this.strata[i2] == (int)strata.strata[i2]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

