/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deeplearning;

import java.io.Serializable;

public class ActivationUtils {
    public static double maxArray(double[] input) {
        assert (input != null && input.length > 0) : "Your array is empty.";
        double d2 = input[0];
        for (int i2 = 0; i2 < input.length; ++i2) {
            d2 = d2 < input[i2] ? input[i2] : d2;
        }
        return d2;
    }

    public static double[] applyDropout(double[] input, double drop_out_ratio, int nodeSize) {
        if (drop_out_ratio > 0.0) {
            double d2 = 1.0 - drop_out_ratio;
            int n2 = 0;
            while (n2 < nodeSize) {
                int n3 = n2++;
                input[n3] = input[n3] * d2;
            }
        }
        return input;
    }

    public static class TanhOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int n2 = input.length;
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = 1.0 - 2.0 / (1.0 + Math.exp(2.0 * input[i2]));
            }
            return dArray;
        }
    }

    public static class TanhDropoutOut
    extends TanhOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] dArray = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(dArray, drop_out_ratio, input.length);
            return dArray;
        }
    }

    public static class MaxoutOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int n2 = input.length / maxOutk;
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2 * maxOutk;
                double d2 = input[n3];
                for (int i3 = 0; i3 < maxOutk; ++i3) {
                    d2 = d2 > input[n3 += i3] ? d2 : input[n3];
                }
                dArray[i2] = d2;
            }
            return dArray;
        }
    }

    public static class MaxoutDropoutOut
    extends MaxoutOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] dArray = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(dArray, drop_out_ratio, dArray.length);
            return dArray;
        }
    }

    public static class RectifierDropoutOut
    extends RectifierOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] dArray = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(dArray, drop_out_ratio, input.length);
            return dArray;
        }
    }

    public static class RectifierOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int n2 = input.length;
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = 0.5 * (input[i2] + Math.abs(input[i2]));
            }
            return dArray;
        }
    }

    public static class ExpRectifierOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int n2 = input.length;
            double[] dArray = new double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = input[i2] >= 0.0 ? input[i2] : Math.exp(input[i2]) - 1.0;
            }
            return dArray;
        }
    }

    public static class ExpRectifierDropoutOut
    extends ExpRectifierOut {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            double[] dArray = super.eval(input, drop_out_ratio, maxOutk);
            ActivationUtils.applyDropout(dArray, drop_out_ratio, input.length);
            return dArray;
        }
    }

    public static class SoftmaxOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            int n2;
            int n3 = input.length;
            double[] dArray = new double[n3];
            double d2 = 0.0;
            double d3 = ActivationUtils.maxArray(input);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = Math.exp(input[n2] - d3);
                d2 += dArray[n2];
            }
            n2 = 0;
            while (n2 < n3) {
                int n4 = n2++;
                dArray[n4] = dArray[n4] / d2;
            }
            return dArray;
        }
    }

    public static class LinearOut
    implements ActivationFunctions {
        @Override
        public double[] eval(double[] input, double drop_out_ratio, int maxOutk) {
            return input;
        }
    }

    public static interface ActivationFunctions
    extends Serializable {
        public double[] eval(double[] var1, double var2, int var4);
    }
}

