/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gam.GamRowToRawDataConverter;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import java.util.Map;

public abstract class GamMojoModelBase
extends MojoModel
implements ConverterFactoryProvidingModel {
    public LinkFunctionType _link_function;
    boolean _useAllFactorLevels;
    int _cats;
    int[] _catNAFills;
    int[] _catOffsets;
    int _nums;
    int _numsCenter;
    double[] _numNAFills;
    double[] _numNAFillsCenter;
    boolean _meanImputation;
    double[] _beta;
    double[] _beta_no_center;
    double[] _beta_center;
    double[][] _beta_multinomial;
    double[][] _beta_multinomial_no_center;
    double[][] _beta_multinomial_center;
    DistributionFamily _family;
    String[] _gam_columns;
    int _num_gam_columns;
    int[] _bs;
    int[] _num_knots;
    double[][] _knots;
    double[][][] _binvD;
    double[][][] _zTranspose;
    String[][] _gamColNames;
    String[][] _gamColNamesCenter;
    String[] _names_no_centering;
    int _totFeatureSize;
    int _betaSizePerClass;
    int _betaCenterSizePerClass;
    double _tweedieLinkPower;
    double[][] _basisVals;
    double[][] _hj;
    int _numExpandedGamCols;
    int _lastClass;

    GamMojoModelBase(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        if (this._meanImputation) {
            this.imputeMissingWithMeans(row);
        }
        return this.gamScore0(row, preds);
    }

    void init() {
        this._basisVals = new double[this._gam_columns.length][];
        this._hj = new double[this._gam_columns.length][];
        for (int i2 = 0; i2 < this._num_gam_columns; ++i2) {
            this._basisVals[i2] = new double[this._num_knots[i2]];
            this._hj[i2] = ArrayUtils.eleDiff(this._knots[i2]);
        }
        this._lastClass = this._nclasses - 1;
    }

    abstract double[] gamScore0(double[] var1, double[] var2);

    private void imputeMissingWithMeans(double[] data) {
        int n2;
        for (n2 = 0; n2 < this._cats; ++n2) {
            if (!Double.isNaN(data[n2])) continue;
            data[n2] = this._catNAFills[n2];
        }
        if (data.length == this.nfeatures()) {
            for (n2 = 0; n2 < this._numsCenter; ++n2) {
                if (!Double.isNaN(data[n2 + this._cats])) continue;
                data[n2 + this._cats] = this._numNAFillsCenter[n2];
            }
            return;
        }
        for (n2 = 0; n2 < this._nums; ++n2) {
            int n3 = n2 + this._cats;
            if (!Double.isNaN(data[n3])) continue;
            data[n3] = this._numNAFills[n2];
        }
    }

    double evalLink(double val) {
        switch (this._link_function) {
            case identity: {
                return GenModel.GLM_identityInv(val);
            }
            case logit: {
                return GenModel.GLM_logitInv(val);
            }
            case log: {
                return GenModel.GLM_logInv(val);
            }
            case inverse: {
                return GenModel.GLM_inverseInv(val);
            }
            case tweedie: {
                return GenModel.GLM_tweedieInv(val, this._tweedieLinkPower);
            }
        }
        throw new UnsupportedOperationException("Unexpected link function " + (Object)((Object)this._link_function));
    }

    int readCatVal(double data, int dataIndex) {
        int n2 = this._useAllFactorLevels ? (int)data : (int)data - 1;
        if (n2 < 0) {
            return -1;
        }
        return n2 += this._catOffsets[dataIndex];
    }

    double generateEta(double[] beta, double[] data) {
        int n2;
        int n3;
        double d2 = 0.0;
        int n4 = this._catOffsets.length - 1;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.readCatVal(data[n3], n3);
            if (n2 >= this._catOffsets[n3 + 1] || n2 < 0) continue;
            d2 += beta[n2];
        }
        n3 = this._catOffsets[this._cats] - this._cats;
        n2 = beta.length - 1 - n3;
        for (int i2 = this._cats; i2 < n2; ++i2) {
            d2 += beta[n3 + i2] * data[i2];
        }
        return d2 += beta[beta.length - 1];
    }

    private boolean gamificationNeeded(double[] rawData, int gamColStart) {
        for (int i2 = gamColStart; i2 < rawData.length; ++i2) {
            if (Double.isNaN(rawData[i2])) continue;
            return false;
        }
        return true;
    }

    double[] addExpandGamCols(double[] rawData, RowData rowData) {
        int n2 = this._totFeatureSize - this._numExpandedGamCols;
        if (!this.gamificationNeeded(rawData, n2)) {
            return rawData;
        }
        double[] dArray = ArrayUtils.nanArray(this._totFeatureSize);
        System.arraycopy(rawData, 0, dArray, 0, n2);
        for (int i2 = 0; i2 < this._num_gam_columns; ++i2) {
            Object v2;
            if (this._bs[i2] == 0) {
                v2 = rowData.get(this._gam_columns[i2]);
                if (v2 == null) {
                    n2 += this._num_knots[i2];
                    continue;
                }
            } else {
                throw new IllegalArgumentException("spline type not implemented!");
            }
            double d2 = v2 instanceof String ? Double.parseDouble((String)v2) : (Double)v2;
            GamUtilsCubicRegression.expandOneGamCol(d2, this._binvD[i2], this._basisVals[i2], this._hj[i2], this._knots[i2]);
            System.arraycopy(this._basisVals[i2], 0, dArray, n2, this._num_knots[i2]);
            n2 += this._num_knots[i2];
        }
        return dArray;
    }

    @Override
    public RowToRawDataConverter makeConverterFactory(Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        return new GamRowToRawDataConverter(this, modelColumnNameToIndexMap, domainMap, errorConsumer, config);
    }
}

