/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.gam.GamMojoModel;
import hex.genmodel.algos.gam.GamMojoModelBase;
import hex.genmodel.algos.gam.GamMojoMultinomialModel;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GamMojoReader
extends ModelMojoReader<GamMojoModelBase> {
    @Override
    public String getModelName() {
        return "Generalized Additive Model";
    }

    @Override
    protected void readModelData() throws IOException {
        ((GamMojoModelBase)this._model)._useAllFactorLevels = this.readkv("use_all_factor_levels", Boolean.FALSE);
        ((GamMojoModelBase)this._model)._numExpandedGamCols = this.readkv("num_expanded_gam_columns", 0);
        ((GamMojoModelBase)this._model)._family = DistributionFamily.valueOf((String)this.readkv("family"));
        ((GamMojoModelBase)this._model)._cats = this.readkv("cats", -1);
        ((GamMojoModelBase)this._model)._nums = (Integer)this.readkv("num");
        ((GamMojoModelBase)this._model)._numsCenter = (Integer)this.readkv("numsCenter");
        ((GamMojoModelBase)this._model)._catNAFills = this.readkv("catNAFills", new int[0]);
        ((GamMojoModelBase)this._model)._numNAFills = this.readkv("numNAFills", new double[0]);
        ((GamMojoModelBase)this._model)._numNAFillsCenter = this.readkv("numNAFillsCenter", new double[0]);
        ((GamMojoModelBase)this._model)._meanImputation = this.readkv("mean_imputation", Boolean.FALSE);
        ((GamMojoModelBase)this._model)._betaSizePerClass = this.readkv("beta length per class", 0);
        ((GamMojoModelBase)this._model)._catOffsets = this.readkv("cat_offsets", new int[0]);
        if (!((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial)) {
            ((GamMojoModelBase)this._model)._link_function = GamMojoReader.readLinkFunction((String)this.readkv("link"), ((GamMojoModelBase)this._model)._family);
        }
        ((GamMojoModelBase)this._model)._tweedieLinkPower = this.readkv("tweedie_link_power", 0.0);
        ((GamMojoModelBase)this._model)._betaCenterSizePerClass = this.readkv("beta center length per class", 0);
        if (((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.multinomial) || ((GamMojoModelBase)this._model)._family.equals((Object)DistributionFamily.ordinal)) {
            ((GamMojoModelBase)this._model)._beta_multinomial_no_center = this.readRectangularDoubleArray("beta_multinomial", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaSizePerClass);
            ((GamMojoModelBase)this._model)._beta_multinomial_center = this.readRectangularDoubleArray("beta_multinomial_centering", ((GamMojoModelBase)this._model)._nclasses, ((GamMojoModelBase)this._model)._betaCenterSizePerClass);
        } else {
            ((GamMojoModelBase)this._model)._beta_no_center = (double[])this.readkv("beta");
            ((GamMojoModelBase)this._model)._beta_center = (double[])this.readkv("beta_center");
        }
        ((GamMojoModelBase)this._model)._num_knots = (int[])this.readkv("num_knots");
        int n2 = ((GamMojoModelBase)this._model)._num_knots.length;
        ((GamMojoModelBase)this._model)._gam_columns = this.readStringArrays(n2, "gam_columns");
        ((GamMojoModelBase)this._model)._num_gam_columns = ((GamMojoModelBase)this._model)._gam_columns.length;
        ((GamMojoModelBase)this._model)._totFeatureSize = (Integer)this.readkv("total feature size");
        GamMojoReader gamMojoReader = this;
        ((GamMojoModelBase)this._model)._names_no_centering = gamMojoReader.readStringArrays(((GamMojoModelBase)gamMojoReader._model)._totFeatureSize, "_names_no_centering");
        ((GamMojoModelBase)this._model)._bs = (int[])this.readkv("bs");
        ((GamMojoModelBase)this._model)._knots = new double[n2][];
        ((GamMojoModelBase)this._model)._binvD = new double[n2][][];
        ((GamMojoModelBase)this._model)._zTranspose = new double[n2][][];
        ((GamMojoModelBase)this._model)._knots = this.read2DArrayDiffLength("knots", ((GamMojoModelBase)this._model)._knots, ((GamMojoModelBase)this._model)._num_knots);
        ((GamMojoModelBase)this._model)._gamColNames = new String[n2][];
        ((GamMojoModelBase)this._model)._gamColNamesCenter = new String[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = ((GamMojoModelBase)this._model)._num_knots[i2];
            ((GamMojoModelBase)this._model)._binvD[i2] = new double[n3 - 2][n3];
            ((GamMojoModelBase)this._model)._binvD[i2] = this.readRectangularDoubleArray(((GamMojoModelBase)this._model)._gam_columns[i2] + "_binvD", ((GamMojoModelBase)this._model)._binvD[i2].length, ((GamMojoModelBase)this._model)._binvD[i2][0].length);
            ((GamMojoModelBase)this._model)._zTranspose[i2] = new double[n3 - 1][n3];
            ((GamMojoModelBase)this._model)._zTranspose[i2] = this.readRectangularDoubleArray(((GamMojoModelBase)this._model)._gam_columns[i2] + "_zTranspose", ((GamMojoModelBase)this._model)._zTranspose[i2].length, ((GamMojoModelBase)this._model)._zTranspose[i2][0].length);
            ((GamMojoModelBase)this._model)._gamColNames[i2] = this.readStringArrays(n3, "gamColNames_" + ((GamMojoModelBase)this._model)._gam_columns[i2]);
            ((GamMojoModelBase)this._model)._gamColNamesCenter[i2] = this.readStringArrays(n3 - 1, "gamColNamesCenter_" + ((GamMojoModelBase)this._model)._gam_columns[i2]);
        }
        ((GamMojoModelBase)this._model).init();
    }

    String[] readStringArrays(int aSize, String title) throws IOException {
        String[] stringArray = new String[aSize];
        int n2 = 0;
        for (String string : this.readtext(title)) {
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    double[][] read2DArrayDiffLength(String title, double[][] row, int[] num_knots) throws IOException {
        int n2 = num_knots.length;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.readblob(title));
        for (int i2 = 0; i2 < n2; ++i2) {
            row[i2] = new double[num_knots[i2]];
            for (int i3 = 0; i3 < row[i2].length; ++i3) {
                row[i2][i3] = byteBuffer.getDouble();
            }
        }
        return row;
    }

    @Override
    protected GamMojoModelBase makeModel(String[] columns, String[][] domains, String responseColumn) {
        String string = (String)this.readkv("family");
        if ("multinomial".equals(string) || "ordinal".equals(string)) {
            return new GamMojoMultinomialModel(columns, domains, responseColumn);
        }
        return new GamMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

