/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.GenModel;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import java.io.Serializable;

public class GlmMojoModel
extends GlmMojoModelBase {
    String _link;
    double _tweedieLinkPower;
    private Function1 _linkFn;
    private boolean _binomial;

    GlmMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    void init() {
        this._linkFn = this.createLinkFunction();
        this._binomial = this._family.equals("binomial");
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        int n2;
        int n3;
        double d2 = 0.0;
        if (!this._useAllFactorLevels) {
            for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                if (data[n3] == 0.0) continue;
                n2 = (int)data[n3] - 1;
                if ((double)n2 != data[n3] - 1.0) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                d2 += this._beta[n2];
            }
        } else {
            for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
                n2 = (int)data[n3];
                if ((double)n2 != data[n3]) {
                    throw new IllegalArgumentException("categorical value out of range");
                }
                if ((n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
                d2 += this._beta[n2];
            }
        }
        n3 = this._catOffsets[this._cats] - this._cats;
        for (n2 = this._cats; n2 < this._beta.length - 1 - n3; ++n2) {
            d2 += this._beta[n3 + n2] * data[n2];
        }
        double d3 = this._linkFn.eval(d2 += this._beta[this._beta.length - 1]);
        if (this._binomial || this._family.equals("fractionalbinomial")) {
            preds[0] = d3 >= this._defaultThreshold ? 1.0 : 0.0;
            preds[1] = 1.0 - d3;
            preds[2] = d3;
        } else {
            preds[0] = d3;
        }
        return preds;
    }

    public double[] applyCoefficients(double[] data, double[] output, int destPos) {
        int n2;
        int n3;
        int n4 = this._useAllFactorLevels ? 0 : -1;
        for (n3 = 0; n3 < this._catOffsets.length - 1; ++n3) {
            n2 = (int)data[n3] - n4;
            if (n2 < 0 || (n2 += this._catOffsets[n3]) >= this._catOffsets[n3 + 1]) continue;
            output[n3 + destPos] = this._beta[n2];
        }
        n3 = destPos + this._catOffsets.length - 1;
        n2 = this._catOffsets[this._cats] - this._cats;
        for (int i2 = this._cats; i2 < this._beta.length - 1 - n2; ++i2) {
            output[n3++] = this._beta[n2 + i2] * data[i2];
        }
        return output;
    }

    public double getIntercept() {
        return this._beta[this._beta.length - 1];
    }

    private Function1 createLinkFunction() {
        if ("identity".equals(this._link)) {
            return new GLM_identityInv();
        }
        if ("logit".equals(this._link)) {
            return new GLM_logitInv();
        }
        if ("log".equals(this._link)) {
            return new GLM_logInv();
        }
        if ("inverse".equals(this._link)) {
            return new GLM_inverseInv();
        }
        if ("tweedie".equals(this._link)) {
            return new GLM_tweedieInv(this._tweedieLinkPower);
        }
        throw new UnsupportedOperationException("Unexpected link function " + this._link);
    }

    private static class GLM_tweedieInv
    implements Function1 {
        private final double _tweedie_link_power;

        GLM_tweedieInv(double tweedie_link_power) {
            this._tweedie_link_power = tweedie_link_power;
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_tweedieInv(x2, this._tweedie_link_power);
        }
    }

    private static class GLM_ologitInv
    implements Function1 {
        private GLM_ologitInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_ologitInv(x2);
        }
    }

    private static class GLM_inverseInv
    implements Function1 {
        private GLM_inverseInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_inverseInv(x2);
        }
    }

    private static class GLM_logInv
    implements Function1 {
        private GLM_logInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_logInv(x2);
        }
    }

    private static class GLM_logitInv
    implements Function1 {
        private GLM_logitInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_logitInv(x2);
        }
    }

    private static class GLM_identityInv
    implements Function1 {
        private GLM_identityInv() {
        }

        @Override
        public double eval(double x2) {
            return GenModel.GLM_identityInv(x2);
        }
    }

    private static interface Function1
    extends Serializable {
        public double eval(double var1);
    }
}

