/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.pca;

import hex.genmodel.MojoModel;

public class PCAMojoModel
extends MojoModel {
    double[][] _eigenvectors_raw;
    public int[] _catOffsets;
    public int[] _permutation;
    public int _ncats;
    public int _nnums;
    public double[] _normSub;
    public double[] _normMul;
    public boolean _use_all_factor_levels;
    public String _pca_method;
    public String _pca_impl;
    public int _k;
    public int _eigenVectorSize;

    public PCAMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        assert (row != null) : "input data row is null";
        double[] dArray = preds == null ? new double[this._k] : preds;
        int n2 = this._catOffsets[this._ncats];
        assert (row.length == this._nnums + this._ncats) : "assert dataset input size does not eqaul to expected size";
        for (int i2 = 0; i2 < this._k; ++i2) {
            int n3;
            dArray[i2] = 0.0;
            for (n3 = 0; n3 < this._ncats; ++n3) {
                double d2 = row[this._permutation[n3]];
                if (Double.isNaN(d2)) continue;
                int n4 = this._catOffsets[n3 + 1] - this._catOffsets[n3] - 1;
                int n5 = (int)d2 - (this._use_all_factor_levels ? 0 : 1);
                if (n5 < 0 || n5 > n4) continue;
                int n6 = i2;
                dArray[n6] = dArray[n6] + this._eigenvectors_raw[this._catOffsets[n3] + n5][i2];
            }
            n3 = this._ncats;
            int n7 = n2;
            for (int i3 = 0; i3 < this._nnums; ++i3) {
                int n8 = i2;
                dArray[n8] = dArray[n8] + (row[this._permutation[n3]] - this._normSub[i3]) * this._normMul[i3] * this._eigenvectors_raw[n7][i2];
                ++n3;
                ++n7;
            }
        }
        return dArray;
    }

    @Override
    public int getPredsSize() {
        return this._k;
    }

    @Override
    public int nclasses() {
        return this._k;
    }

    @Override
    public String[] getOutputNames() {
        String[] stringArray = new String[this._k];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = "PC" + (i2 + 1);
        }
        return stringArray;
    }
}

