/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.svm;

import hex.genmodel.MojoModel;
import java.util.Arrays;

public class SvmMojoModel
extends MojoModel {
    boolean meanImputation;
    double[] weights;
    double[] means;
    double interceptor;
    double defaultThreshold;
    double threshold;

    SvmMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        Arrays.fill(preds, 0.0);
        double d2 = this.interceptor;
        for (int i2 = 0; i2 < row.length; ++i2) {
            if (Double.isNaN(row[i2]) && this.meanImputation) {
                d2 += this.means[i2] * this.weights[i2];
                continue;
            }
            d2 += row[i2] * this.weights[i2];
        }
        if (this._nclasses == 1) {
            preds[0] = d2;
        } else if (d2 > this.threshold) {
            preds[2] = d2 < this.defaultThreshold ? this.defaultThreshold : d2;
            preds[1] = preds[2] - 1.0;
            preds[0] = 1.0;
        } else {
            preds[2] = d2 >= this.defaultThreshold ? this.defaultThreshold - 1.0 : d2;
            preds[1] = preds[2] + 1.0;
            preds[0] = 0.0;
        }
        return preds;
    }
}

