/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.targetencoder;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TargetEncoderMojoReader
extends ModelMojoReader<TargetEncoderMojoModel> {
    public static final String ENCODING_MAP_PATH = "feature_engineering/target_encoding/encoding_map.ini";
    public static final String MISSING_VALUES_PRESENCE_MAP_PATH = "feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini";

    @Override
    public String getModelName() {
        return "TargetEncoder";
    }

    @Override
    protected void readModelData() throws IOException {
        ((TargetEncoderMojoModel)this._model)._keepOriginalCategoricalColumns = this.readkv("keep_original_categorical_columns", Boolean.FALSE);
        ((TargetEncoderMojoModel)this._model)._withBlending = (Boolean)this.readkv("with_blending");
        if (((TargetEncoderMojoModel)this._model)._withBlending) {
            ((TargetEncoderMojoModel)this._model)._inflectionPoint = (Double)this.readkv("inflection_point");
            ((TargetEncoderMojoModel)this._model)._smoothing = (Double)this.readkv("smoothing");
        }
        ((TargetEncoderMojoModel)this._model)._nonPredictors = Arrays.asList(this.readkv("non_predictors", "").split(";"));
        ((TargetEncoderMojoModel)this._model).setEncodings(this.parseEncodingMap());
        ((TargetEncoderMojoModel)this._model)._teColumn2HasNAs = this.parseTEColumnsToHasNAs();
    }

    @Override
    protected TargetEncoderMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new TargetEncoderMojoModel(columns, domains, responseColumn);
    }

    private Map<String, Boolean> parseTEColumnsToHasNAs() throws IOException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (this.exists(MISSING_VALUES_PRESENCE_MAP_PATH)) {
            Iterable<String> iterable = this.readtext(MISSING_VALUES_PRESENCE_MAP_PATH);
            for (String string : iterable) {
                String[] stringArray = string.split("\\s*=\\s*", 2);
                hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]) == 1);
            }
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EncodingMaps parseEncodingMap() throws IOException {
        if (!this.exists(ENCODING_MAP_PATH)) {
            return null;
        }
        HashMap<String, EncodingMap> hashMap = new HashMap<String, EncodingMap>();
        BufferedReader bufferedReader = this.getMojoReaderBackend().getTextFile(ENCODING_MAP_PATH);
        Throwable throwable = null;
        try {
            EncodingMap encodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
            String string = null;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) break;
                string2 = string2.trim();
                String string3 = this.matchNewSection(string2);
                if (string == null || string3 != null) {
                    if (string != null) {
                        hashMap.put(string, encodingMap);
                    }
                    string = string3;
                    encodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
                    continue;
                }
                String[] stringArray = string2.split("\\s*=\\s*", 2);
                double[] dArray = this.processEncodingsComponents(stringArray[1].split(" "));
                encodingMap.add(Integer.parseInt(stringArray[0]), dArray);
            }
            hashMap.put(string, encodingMap);
            if (bufferedReader == null) return new EncodingMaps(hashMap);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (bufferedReader == null) throw throwable4;
                if (throwable != null) {
                    try {
                        bufferedReader.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    bufferedReader.close();
                }
                throw throwable4;
            }
        }
        bufferedReader.close();
        return new EncodingMaps(hashMap);
    }

    private String matchNewSection(String line) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private double[] processEncodingsComponents(String[] componentsStr) {
        double[] dArray = new double[componentsStr.length];
        int n2 = 0;
        String[] stringArray = componentsStr;
        int n3 = componentsStr.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray[i2];
            dArray[n2] = Double.parseDouble(string);
            ++n2;
        }
        return dArray;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

