/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.word2vec;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.word2vec.Word2VecMojoModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;

public class Word2VecMojoReader
extends ModelMojoReader<Word2VecMojoModel> {
    @Override
    public String getModelName() {
        return "Word2Vec";
    }

    @Override
    protected void readModelData() throws IOException {
        int n2;
        int n3 = this.readkv("vocab_size", -1);
        ((Word2VecMojoModel)this._model)._vecSize = n2 = this.readkv("vec_size", -1).intValue();
        ((Word2VecMojoModel)this._model)._embeddings = new HashMap(n3);
        byte[] byArray = this.readblob("vectors");
        if (byArray.length != n3 * n2 << 2) {
            throw new IOException("Corrupted vector representation, unexpected size: " + byArray.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Iterator<String> iterator = this.readtext("vocabulary", true).iterator();
        while (iterator.hasNext()) {
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = byteBuffer.getFloat();
            }
            ((Word2VecMojoModel)this._model)._embeddings.put(iterator.next(), fArray);
        }
        if (((Word2VecMojoModel)this._model)._embeddings.size() != n3) {
            throw new IOException("Corrupted model, unexpected number of words: " + ((Word2VecMojoModel)this._model)._embeddings.size());
        }
    }

    @Override
    protected Word2VecMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new Word2VecMojoModel(columns, domains, responseColumn);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

