/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.ModelCategory;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.IClusteringModel;
import hex.genmodel.MojoModel;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.deeplearning.DeeplearningMojoModel;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.TreeBackedMojoModel;
import hex.genmodel.algos.word2vec.WordEmbeddingModel;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.parameters.KeyValue;
import hex.genmodel.attributes.parameters.VariableImportancesHolder;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.easy.error.VoidErrorConsumer;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.AnomalyDetectionPrediction;
import hex.genmodel.easy.prediction.AutoEncoderModelPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.CoxPHModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.KLimeModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.OrdinalModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import hex.genmodel.easy.prediction.SortedClassProbability;
import hex.genmodel.easy.prediction.TargetEncoderPrediction;
import hex.genmodel.easy.prediction.Word2VecPrediction;
import hex.genmodel.utils.ArrayUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EasyPredictModelWrapper
implements Serializable {
    public final GenModel m;
    private final RowToRawDataConverter rowDataConverter;
    private final boolean useExtendedOutput;
    private final boolean enableLeafAssignment;
    private final boolean enableGLRMReconstruct;
    private final boolean enableStagedProbabilities;
    private final boolean enableContributions;
    private final int glrmIterNumber;
    private final PredictContributions predictContributions;

    public EasyPredictModelWrapper(Config config) {
        this.m = config.getModel();
        ErrorConsumer errorConsumer = config.getErrorConsumer() == null ? new VoidErrorConsumer() : config.getErrorConsumer();
        this.useExtendedOutput = config.getUseExtendedOutput();
        this.enableLeafAssignment = config.getEnableLeafAssignment();
        this.enableGLRMReconstruct = config.getEnableGLRMReconstrut();
        this.enableStagedProbabilities = config.getEnableStagedProbabilities();
        this.enableContributions = config.getEnableContributions();
        this.glrmIterNumber = config.getGLRMIterNumber();
        if (this.m instanceof GlrmMojoModel) {
            ((GlrmMojoModel)this.m)._iterNumber = this.glrmIterNumber;
        }
        if (this.enableContributions) {
            if (!(this.m instanceof PredictContributionsFactory)) {
                throw new IllegalStateException("Model " + this.m.getClass().getName() + " cannot be used to predict contributions.");
            }
            this.predictContributions = ((PredictContributionsFactory)((Object)this.m)).makeContributionsPredictor();
        } else {
            this.predictContributions = null;
        }
        CategoricalEncoding categoricalEncoding = config.getUseExternalEncoding() ? CategoricalEncoding.AUTO : this.m.getCategoricalEncoding();
        Map<String, Integer> map = categoricalEncoding.createColumnMapping(this.m);
        Map<Integer, CategoricalEncoder> map2 = categoricalEncoding.createCategoricalEncoders(this.m, map);
        if (this.m instanceof ConverterFactoryProvidingModel) {
            this.rowDataConverter = ((ConverterFactoryProvidingModel)((Object)this.m)).makeConverterFactory(map, map2, errorConsumer, config);
            return;
        }
        this.rowDataConverter = new RowToRawDataConverter(this.m, map, map2, errorConsumer, config);
    }

    public EasyPredictModelWrapper(GenModel model) {
        this(new Config().setModel(model));
    }

    public AbstractPrediction predict(RowData data, ModelCategory mc) throws PredictException {
        switch (mc) {
            case AutoEncoder: {
                return this.predictAutoEncoder(data);
            }
            case Binomial: {
                return this.predictBinomial(data);
            }
            case Multinomial: {
                return this.predictMultinomial(data);
            }
            case Ordinal: {
                return this.predictOrdinal(data);
            }
            case Clustering: {
                return this.predictClustering(data);
            }
            case Regression: {
                return this.predictRegression(data);
            }
            case DimReduction: {
                return this.predictDimReduction(data);
            }
            case WordEmbedding: {
                return this.predictWord2Vec(data);
            }
            case TargetEncoder: {
                return this.predictTargetEncoding(data);
            }
            case AnomalyDetection: {
                return this.predictAnomalyDetection(data);
            }
            case KLime: {
                return this.predictKLime(data);
            }
            case CoxPH: {
                return this.predictCoxPH(data);
            }
            case Unknown: {
                throw new PredictException("Unknown model category");
            }
        }
        throw new PredictException("Unhandled model category (" + (Object)((Object)this.m.getModelCategory()) + ") in switch statement");
    }

    public AbstractPrediction predict(RowData data) throws PredictException {
        return this.predict(data, this.m.getModelCategory());
    }

    ErrorConsumer getErrorConsumer() {
        return this.rowDataConverter.getErrorConsumer();
    }

    public String[] getContributionNames() {
        if (this.predictContributions == null) {
            throw new IllegalStateException("Contributions were not enabled using in EasyPredictModelWrapper (use setEnableContributions).");
        }
        return this.predictContributions.getContributionNames();
    }

    public AutoEncoderModelPrediction predictAutoEncoder(RowData data) throws PredictException {
        this.validateModelCategory(ModelCategory.AutoEncoder);
        int n2 = this.m.getPredsSize(ModelCategory.AutoEncoder);
        double[] dArray = new double[n2];
        double[] dArray2 = ArrayUtils.nanArray(this.m.nfeatures());
        dArray2 = this.fillRawData(data, dArray2);
        dArray = this.m.score0(dArray2, dArray);
        AutoEncoderModelPrediction autoEncoderModelPrediction = new AutoEncoderModelPrediction();
        new AutoEncoderModelPrediction().original = this.expandRawData(dArray2, dArray.length);
        autoEncoderModelPrediction.reconstructed = dArray;
        autoEncoderModelPrediction.reconstructedRowData = this.reconstructedToRowData(dArray);
        if (this.m instanceof DeeplearningMojoModel) {
            DeeplearningMojoModel deeplearningMojoModel = (DeeplearningMojoModel)this.m;
            autoEncoderModelPrediction.mse = deeplearningMojoModel.calculateReconstructionErrorPerRowData(autoEncoderModelPrediction.original, autoEncoderModelPrediction.reconstructed);
        }
        return autoEncoderModelPrediction;
    }

    private double[] expandRawData(double[] data, int size) {
        double[] dArray = new double[size];
        int n2 = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (this.m._domains[i2] == null) {
                dArray[n2] = data[i2];
                ++n2;
                continue;
            }
            int n3 = Double.isNaN(data[i2]) ? this.m._domains[i2].length : (int)data[i2];
            dArray[n2 + n3] = 1.0;
            n2 += this.m._domains[i2].length + 1;
        }
        return dArray;
    }

    private RowData reconstructedToRowData(double[] reconstructed) {
        RowData rowData = new RowData();
        int n2 = 0;
        for (int i2 = 0; i2 < this.m.nfeatures(); ++i2) {
            Object object;
            if (this.m._domains[i2] == null) {
                object = reconstructed[n2++];
            } else {
                object = EasyPredictModelWrapper.catValuesAsMap(this.m._domains[i2], reconstructed, n2);
                n2 += this.m._domains[i2].length + 1;
            }
            rowData.put(this.m._names[i2], object);
        }
        return rowData;
    }

    private static Map<String, Double> catValuesAsMap(String[] cats, double[] reconstructed, int offset) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>(cats.length + 1);
        for (int i2 = 0; i2 < cats.length; ++i2) {
            hashMap.put(cats[i2], reconstructed[i2 + offset]);
        }
        hashMap.put(null, reconstructed[offset + cats.length]);
        return hashMap;
    }

    public DimReductionModelPrediction predictDimReduction(RowData data) throws PredictException {
        double[] dArray = this.preamble(ModelCategory.DimReduction, data);
        DimReductionModelPrediction dimReductionModelPrediction = new DimReductionModelPrediction();
        new DimReductionModelPrediction().dimensions = dArray;
        if (this.m instanceof GlrmMojoModel && ((GlrmMojoModel)this.m)._archetypes_raw != null && this.enableGLRMReconstruct) {
            dimReductionModelPrediction.reconstructed = GlrmMojoModel.impute_data(dArray, new double[this.m.nfeatures()], ((GlrmMojoModel)this.m)._nnums, ((GlrmMojoModel)this.m)._ncats, ((GlrmMojoModel)this.m)._permutation, ((GlrmMojoModel)this.m)._reverse_transform, ((GlrmMojoModel)this.m)._normMul, ((GlrmMojoModel)this.m)._normSub, ((GlrmMojoModel)this.m)._losses, ((GlrmMojoModel)this.m)._transposed, ((GlrmMojoModel)this.m)._archetypes_raw, ((GlrmMojoModel)this.m)._catOffsets, ((GlrmMojoModel)this.m)._numLevels);
        }
        return dimReductionModelPrediction;
    }

    public float[] predictWord2Vec(String[] sentence) throws PredictException {
        WordEmbeddingModel wordEmbeddingModel = this.asWordEmbeddingModel();
        int n2 = wordEmbeddingModel.getVecSize();
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        int n3 = 0;
        String[] stringArray = sentence;
        int n4 = sentence.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = stringArray[i2];
            float[] fArray3 = wordEmbeddingModel.transform0(string, fArray2);
            if (fArray3 == null) continue;
            ++n3;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = i3;
                fArray[n5] = fArray[n5] + fArray3[i3];
            }
        }
        if (n3 > 0) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = n6++;
                fArray[n7] = fArray[n7] / (float)n3;
            }
        } else {
            Arrays.fill(fArray, Float.NaN);
        }
        return fArray;
    }

    public Word2VecPrediction predictWord2Vec(RowData data) throws PredictException {
        WordEmbeddingModel wordEmbeddingModel = this.asWordEmbeddingModel();
        int n2 = wordEmbeddingModel.getVecSize();
        HashMap<String, float[]> hashMap = new HashMap<String, float[]>(data.size());
        for (String string : data.keySet()) {
            Object v2 = data.get(string);
            if (!(v2 instanceof String)) continue;
            String string2 = (String)v2;
            hashMap.put(string, wordEmbeddingModel.transform0(string2, new float[n2]));
        }
        Word2VecPrediction word2VecPrediction = new Word2VecPrediction();
        new Word2VecPrediction().wordEmbeddings = hashMap;
        return word2VecPrediction;
    }

    private WordEmbeddingModel asWordEmbeddingModel() throws PredictException {
        this.validateModelCategory(ModelCategory.WordEmbedding);
        if (!(this.m instanceof WordEmbeddingModel)) {
            throw new PredictException("Model is not of the expected type, class = " + this.m.getClass().getSimpleName());
        }
        return (WordEmbeddingModel)((Object)this.m);
    }

    public AnomalyDetectionPrediction predictAnomalyDetection(RowData data) throws PredictException {
        Object object;
        double[] dArray = this.preamble(ModelCategory.AnomalyDetection, data, 0.0);
        AnomalyDetectionPrediction anomalyDetectionPrediction = new AnomalyDetectionPrediction(dArray);
        if (this.enableLeafAssignment) {
            object = this.leafNodeAssignmentExtended(data);
            anomalyDetectionPrediction.leafNodeAssignments = ((SharedTreeMojoModel.LeafNodeAssignments)object)._paths;
            anomalyDetectionPrediction.leafNodeAssignmentIds = ((SharedTreeMojoModel.LeafNodeAssignments)object)._nodeIds;
        }
        if (this.enableStagedProbabilities) {
            object = ArrayUtils.nanArray(this.m.nfeatures());
            object = this.fillRawData(data, (double[])object);
            anomalyDetectionPrediction.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions((double[])object, dArray.length);
        }
        return anomalyDetectionPrediction;
    }

    public BinomialModelPrediction predictBinomial(RowData data) throws PredictException {
        return this.predictBinomial(data, 0.0);
    }

    public BinomialModelPrediction predictBinomial(RowData data, double offset) throws PredictException {
        double[] dArray;
        double[] dArray2 = this.preamble(ModelCategory.Binomial, data, offset);
        BinomialModelPrediction binomialModelPrediction = new BinomialModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments leafNodeAssignments = this.leafNodeAssignmentExtended(data);
            binomialModelPrediction.leafNodeAssignments = leafNodeAssignments._paths;
            binomialModelPrediction.leafNodeAssignmentIds = leafNodeAssignments._nodeIds;
        }
        double d2 = dArray2[0];
        binomialModelPrediction.labelIndex = (int)d2;
        String[] stringArray = this.m.getDomainValues(this.m.getResponseIdx());
        if (stringArray == null && this.m.getNumResponseClasses() == 2) {
            stringArray = new String[]{"0", "1"};
        }
        binomialModelPrediction.label = stringArray[binomialModelPrediction.labelIndex];
        binomialModelPrediction.classProbabilities = new double[this.m.getNumResponseClasses()];
        System.arraycopy(dArray2, 1, binomialModelPrediction.classProbabilities, 0, binomialModelPrediction.classProbabilities.length);
        if (this.m.calibrateClassProbabilities(dArray2)) {
            binomialModelPrediction.calibratedClassProbabilities = new double[this.m.getNumResponseClasses()];
            System.arraycopy(dArray2, 1, binomialModelPrediction.calibratedClassProbabilities, 0, binomialModelPrediction.calibratedClassProbabilities.length);
        }
        if (this.enableStagedProbabilities) {
            dArray = ArrayUtils.nanArray(this.m.nfeatures());
            dArray = this.fillRawData(data, dArray);
            binomialModelPrediction.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(dArray, dArray2.length);
        }
        if (this.enableContributions) {
            dArray = ArrayUtils.nanArray(this.m.nfeatures());
            dArray = this.fillRawData(data, dArray);
            binomialModelPrediction.contributions = this.predictContributions.calculateContributions(dArray);
        }
        return binomialModelPrediction;
    }

    @Deprecated
    public TargetEncoderPrediction transformWithTargetEncoding(RowData data) throws PredictException {
        return this.predictTargetEncoding(data);
    }

    public TargetEncoderPrediction predictTargetEncoding(RowData data) throws PredictException {
        if (!(this.m instanceof TargetEncoderMojoModel)) {
            throw new PredictException("Model is not of the expected type, class = " + this.m.getClass().getSimpleName());
        }
        TargetEncoderMojoModel targetEncoderMojoModel = (TargetEncoderMojoModel)this.m;
        double[] dArray = new double[targetEncoderMojoModel.getPredsSize()];
        TargetEncoderPrediction targetEncoderPrediction = new TargetEncoderPrediction();
        new TargetEncoderPrediction().transformations = this.predict(data, 0.0, dArray);
        return targetEncoderPrediction;
    }

    public String[] leafNodeAssignment(RowData data) throws PredictException {
        double[] dArray = ArrayUtils.nanArray(this.m.nfeatures());
        dArray = this.fillRawData(data, dArray);
        return ((TreeBackedMojoModel)((Object)this.m)).getDecisionPath(dArray);
    }

    public SharedTreeMojoModel.LeafNodeAssignments leafNodeAssignmentExtended(RowData data) throws PredictException {
        double[] dArray = ArrayUtils.nanArray(this.m.nfeatures());
        dArray = this.fillRawData(data, dArray);
        return ((TreeBackedMojoModel)((Object)this.m)).getLeafNodeAssignments(dArray);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data) throws PredictException {
        return this.predictMultinomial(data, 0.0);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data, double offset) throws PredictException {
        String[] stringArray;
        double[] dArray = this.preamble(ModelCategory.Multinomial, data, offset);
        MultinomialModelPrediction multinomialModelPrediction = new MultinomialModelPrediction();
        if (this.enableLeafAssignment) {
            stringArray = this.leafNodeAssignmentExtended(data);
            multinomialModelPrediction.leafNodeAssignments = stringArray._paths;
            multinomialModelPrediction.leafNodeAssignmentIds = stringArray._nodeIds;
        }
        multinomialModelPrediction.classProbabilities = new double[this.m.getNumResponseClasses()];
        multinomialModelPrediction.labelIndex = (int)dArray[0];
        stringArray = this.m.getDomainValues(this.m.getResponseIdx());
        multinomialModelPrediction.label = stringArray[multinomialModelPrediction.labelIndex];
        System.arraycopy(dArray, 1, multinomialModelPrediction.classProbabilities, 0, multinomialModelPrediction.classProbabilities.length);
        if (this.enableStagedProbabilities) {
            double[] dArray2 = ArrayUtils.nanArray(this.m.nfeatures());
            dArray2 = this.fillRawData(data, dArray2);
            multinomialModelPrediction.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions(dArray2, dArray.length);
        }
        return multinomialModelPrediction;
    }

    public OrdinalModelPrediction predictOrdinal(RowData data) throws PredictException {
        return this.predictOrdinal(data, 0.0);
    }

    public OrdinalModelPrediction predictOrdinal(RowData data, double offset) throws PredictException {
        double[] dArray = this.preamble(ModelCategory.Ordinal, data, offset);
        OrdinalModelPrediction ordinalModelPrediction = new OrdinalModelPrediction();
        new OrdinalModelPrediction().classProbabilities = new double[this.m.getNumResponseClasses()];
        ordinalModelPrediction.labelIndex = (int)dArray[0];
        String[] stringArray = this.m.getDomainValues(this.m.getResponseIdx());
        ordinalModelPrediction.label = stringArray[ordinalModelPrediction.labelIndex];
        System.arraycopy(dArray, 1, ordinalModelPrediction.classProbabilities, 0, ordinalModelPrediction.classProbabilities.length);
        return ordinalModelPrediction;
    }

    private SortedClassProbability[] sortByDescendingClassProbability(String[] domainValues, double[] classProbabilities) {
        assert (classProbabilities.length == domainValues.length);
        SortedClassProbability[] sortedClassProbabilityArray = new SortedClassProbability[domainValues.length];
        for (int i2 = 0; i2 < domainValues.length; ++i2) {
            sortedClassProbabilityArray[i2] = new SortedClassProbability();
            sortedClassProbabilityArray[i2].name = domainValues[i2];
            sortedClassProbabilityArray[i2].probability = classProbabilities[i2];
        }
        Arrays.sort(sortedClassProbabilityArray, Collections.reverseOrder());
        return sortedClassProbabilityArray;
    }

    public SortedClassProbability[] sortByDescendingClassProbability(BinomialModelPrediction p2) {
        String[] stringArray = this.m.getDomainValues(this.m.getResponseIdx());
        double[] dArray = p2.classProbabilities;
        return this.sortByDescendingClassProbability(stringArray, dArray);
    }

    public ClusteringModelPrediction predictClustering(RowData data) throws PredictException {
        ClusteringModelPrediction clusteringModelPrediction = new ClusteringModelPrediction();
        if (this.useExtendedOutput && this.m instanceof IClusteringModel) {
            IClusteringModel iClusteringModel = (IClusteringModel)((Object)this.m);
            double[] dArray = ArrayUtils.nanArray(this.m.nfeatures());
            dArray = this.fillRawData(data, dArray);
            int n2 = iClusteringModel.getNumClusters();
            clusteringModelPrediction.distances = new double[n2];
            clusteringModelPrediction.cluster = iClusteringModel.distances(dArray, clusteringModelPrediction.distances);
        } else {
            double[] dArray = this.preamble(ModelCategory.Clustering, data);
            clusteringModelPrediction.cluster = (int)dArray[0];
        }
        return clusteringModelPrediction;
    }

    public RegressionModelPrediction predictRegression(RowData data) throws PredictException {
        return this.predictRegression(data, 0.0);
    }

    public RegressionModelPrediction predictRegression(RowData data, double offset) throws PredictException {
        Object object;
        double[] dArray = this.preamble(ModelCategory.Regression, data, offset);
        RegressionModelPrediction regressionModelPrediction = new RegressionModelPrediction();
        if (this.enableLeafAssignment) {
            object = this.leafNodeAssignmentExtended(data);
            regressionModelPrediction.leafNodeAssignments = ((SharedTreeMojoModel.LeafNodeAssignments)object)._paths;
            regressionModelPrediction.leafNodeAssignmentIds = ((SharedTreeMojoModel.LeafNodeAssignments)object)._nodeIds;
        }
        regressionModelPrediction.value = dArray[0];
        if (this.enableStagedProbabilities) {
            object = ArrayUtils.nanArray(this.m.nfeatures());
            object = this.fillRawData(data, (double[])object);
            regressionModelPrediction.stageProbabilities = ((SharedTreeMojoModel)this.m).scoreStagedPredictions((double[])object, dArray.length);
        }
        if (this.enableContributions) {
            object = ArrayUtils.nanArray(this.m.nfeatures());
            object = this.fillRawData(data, (double[])object);
            regressionModelPrediction.contributions = this.predictContributions.calculateContributions((double[])object);
        }
        return regressionModelPrediction;
    }

    public KLimeModelPrediction predictKLime(RowData data) throws PredictException {
        double[] dArray = this.preamble(ModelCategory.KLime, data);
        KLimeModelPrediction kLimeModelPrediction = new KLimeModelPrediction();
        new KLimeModelPrediction().value = dArray[0];
        kLimeModelPrediction.cluster = (int)dArray[1];
        kLimeModelPrediction.reasonCodes = new double[dArray.length - 2];
        System.arraycopy(dArray, 2, kLimeModelPrediction.reasonCodes, 0, kLimeModelPrediction.reasonCodes.length);
        return kLimeModelPrediction;
    }

    public CoxPHModelPrediction predictCoxPH(RowData data) throws PredictException {
        double[] dArray = this.preamble(ModelCategory.CoxPH, data);
        CoxPHModelPrediction coxPHModelPrediction = new CoxPHModelPrediction();
        new CoxPHModelPrediction().value = dArray[0];
        return coxPHModelPrediction;
    }

    public KeyValue[] varimp() {
        return this.varimp(-1);
    }

    public KeyValue[] varimp(int n2) {
        if (this.m instanceof MojoModel) {
            ModelAttributes modelAttributes = ((MojoModel)this.m)._modelAttributes;
            if (modelAttributes == null) {
                throw new IllegalStateException("Model attributes are not available. Did you load metadata from model? MojoModel.load(\"model\", true)");
            }
            if (modelAttributes instanceof VariableImportancesHolder) {
                return ((VariableImportancesHolder)((Object)modelAttributes)).getVariableImportances().topN(n2);
            }
        }
        throw new IllegalStateException("Model does not support variable importance");
    }

    public ModelCategory getModelCategory() {
        return this.m.getModelCategory();
    }

    public String[] getResponseDomainValues() {
        return this.m.getDomainValues(this.m.getResponseIdx());
    }

    public String getHeader() {
        return this.m.getHeader();
    }

    private void validateModelCategory(ModelCategory c2) throws PredictException {
        if (!this.m.getModelCategories().contains((Object)c2)) {
            throw new PredictException((Object)((Object)c2) + " prediction type is not supported for this model.");
        }
    }

    protected double[] preamble(ModelCategory c2, RowData data) throws PredictException {
        return this.preamble(c2, data, 0.0);
    }

    protected double[] preamble(ModelCategory c2, RowData data, double offset) throws PredictException {
        this.validateModelCategory(c2);
        int n2 = this.m.getPredsSize(c2);
        return this.predict(data, offset, new double[n2]);
    }

    protected double[] fillRawData(RowData data, double[] rawData) throws PredictException {
        return this.rowDataConverter.convert(data, rawData);
    }

    protected double[] predict(RowData data, double offset, double[] preds) throws PredictException {
        double[] dArray = ArrayUtils.nanArray(this.m.nfeatures());
        dArray = this.fillRawData(data, dArray);
        preds = this.m.requiresOffset() || offset != 0.0 ? this.m.score0(dArray, offset, preds) : this.m.score0(dArray, preds);
        return preds;
    }

    public static class Config {
        private GenModel model;
        private boolean convertUnknownCategoricalLevelsToNa = false;
        private boolean convertInvalidNumbersToNa = false;
        private boolean useExtendedOutput = false;
        private ErrorConsumer errorConsumer;
        private boolean enableLeafAssignment = false;
        private boolean enableGLRMReconstrut = false;
        private boolean enableStagedProbabilities = false;
        private boolean enableContributions = false;
        private boolean useExternalEncoding = false;
        private int glrmIterNumber = 100;

        public Config setModel(GenModel value) {
            this.model = value;
            return this;
        }

        public GenModel getModel() {
            return this.model;
        }

        public Config setConvertUnknownCategoricalLevelsToNa(boolean value) {
            this.convertUnknownCategoricalLevelsToNa = value;
            return this;
        }

        public Config setEnableLeafAssignment(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("enableLeafAssignment cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof TreeBackedMojoModel)) {
                throw new IOException("enableLeafAssignment can be set to true only with TreeBackedMojoModel, i.e. with GBM, DRF, Isolation forest or XGBoost.");
            }
            this.enableLeafAssignment = val;
            return this;
        }

        public Config setEnableGLRMReconstrut(boolean value) throws IOException {
            if (value && this.model == null) {
                throw new IOException("Cannot set enableGLRMReconstruct for a null model.  Call config.setModel() first.");
            }
            if (value && !(this.model instanceof GlrmMojoModel)) {
                throw new IOException("enableGLRMReconstruct shall only be used with GlrmMojoModels.");
            }
            this.enableGLRMReconstrut = value;
            return this;
        }

        public Config setGLRMIterNumber(int value) throws IOException {
            if (this.model == null) {
                throw new IOException("Cannot set glrmIterNumber for a null model.  Call config.setModel() first.");
            }
            if (!(this.model instanceof GlrmMojoModel)) {
                throw new IOException("glrmIterNumber  shall only be used with GlrmMojoModels.");
            }
            if (value <= 0) {
                throw new IllegalArgumentException("GLRMIterNumber must be positive.");
            }
            this.glrmIterNumber = value;
            return this;
        }

        public Config setEnableStagedProbabilities(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("enableStagedProbabilities cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof SharedTreeMojoModel)) {
                throw new IOException("enableStagedProbabilities can be set to true only with SharedTreeMojoModel, i.e. with GBM or DRF.");
            }
            this.enableStagedProbabilities = val;
            return this;
        }

        public boolean getEnableGLRMReconstrut() {
            return this.enableGLRMReconstrut;
        }

        public Config setEnableContributions(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("setEnableContributions cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof PredictContributionsFactory)) {
                throw new IOException("setEnableContributions can be set to true only with DRF, GBM, or XGBoost models.");
            }
            if (val && ModelCategory.Multinomial.equals((Object)this.model.getModelCategory())) {
                throw new IOException("setEnableContributions is not yet supported for multinomial classification models.");
            }
            this.enableContributions = val;
            return this;
        }

        public boolean getEnableContributions() {
            return this.enableContributions;
        }

        public Config setUseExternalEncoding(boolean val) {
            this.useExternalEncoding = val;
            return this;
        }

        public boolean getUseExternalEncoding() {
            return this.useExternalEncoding;
        }

        public boolean getConvertUnknownCategoricalLevelsToNa() {
            return this.convertUnknownCategoricalLevelsToNa;
        }

        public int getGLRMIterNumber() {
            return this.glrmIterNumber;
        }

        public Config setConvertInvalidNumbersToNa(boolean value) {
            this.convertInvalidNumbersToNa = value;
            return this;
        }

        public boolean getConvertInvalidNumbersToNa() {
            return this.convertInvalidNumbersToNa;
        }

        public Config setUseExtendedOutput(boolean value) {
            this.useExtendedOutput = value;
            return this;
        }

        public boolean getUseExtendedOutput() {
            return this.useExtendedOutput;
        }

        public boolean getEnableLeafAssignment() {
            return this.enableLeafAssignment;
        }

        public boolean getEnableStagedProbabilities() {
            return this.enableStagedProbabilities;
        }

        public ErrorConsumer getErrorConsumer() {
            return this.errorConsumer;
        }

        public Config setErrorConsumer(ErrorConsumer errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }
    }

    public static abstract class ErrorConsumer
    implements Serializable {
        public abstract void dataTransformError(String var1, Object var2, String var3);

        public abstract void unseenCategorical(String var1, Object var2, String var3);
    }
}

