/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Closure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueChangeClosure
implements Closure {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Object propertyValue;
    private boolean ignoreNull;

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueChangeClosure(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName != null && propertyName.length() > 0) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.ignoreNull = ignoreNull;
            return;
        }
        throw new IllegalArgumentException("propertyName cannot be null or empty");
    }

    @Override
    public void execute(Object object) {
        try {
            PropertyUtils.setProperty(object, this.propertyName, this.propertyValue);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.ignoreNull) {
                this.log.warn("WARNING: Unable to execute Closure. Null value encountered in property path..." + illegalArgumentException);
            }
            IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("Unable to execute Closure. Null value encountered in property path...");
            if (!BeanUtils.initCause(illegalArgumentException2, illegalArgumentException)) {
                this.log.error("Unable to execute Closure. Null value encountered in property path...", illegalArgumentException);
            }
            throw illegalArgumentException2;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to access the property provided.");
            if (!BeanUtils.initCause(illegalArgumentException, illegalAccessException)) {
                this.log.error("Unable to access the property provided.", illegalAccessException);
            }
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Exception occurred in property's getter");
            if (!BeanUtils.initCause(illegalArgumentException, invocationTargetException)) {
                this.log.error("Exception occurred in property's getter", invocationTargetException);
            }
            throw illegalArgumentException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Property not found");
            if (!BeanUtils.initCause(illegalArgumentException, noSuchMethodException)) {
                this.log.error("Property not found", noSuchMethodException);
            }
            throw illegalArgumentException;
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

