/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtilsBean {
    private static final ContextClassLoaderLocal<BeanUtilsBean> BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal<BeanUtilsBean>(){

        @Override
        protected final BeanUtilsBean initialValue() {
            return new BeanUtilsBean();
        }
    };
    private final Log log = LogFactory.getLog(BeanUtils.class);
    private final ConvertUtilsBean convertUtilsBean;
    private final PropertyUtilsBean propertyUtilsBean;
    private static final Method INIT_CAUSE_METHOD = BeanUtilsBean.getInitCauseMethod();

    public static BeanUtilsBean getInstance() {
        return BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(BeanUtilsBean newInstance) {
        BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public BeanUtilsBean() {
        this(new ConvertUtilsBean(), new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean) {
        this(convertUtilsBean, new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        this.convertUtilsBean = convertUtilsBean;
        this.propertyUtilsBean = propertyUtilsBean;
    }

    public Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cloning bean: " + bean.getClass().getName());
        }
        Object object = bean instanceof DynaBean ? ((DynaBean)bean).getDynaClass().newInstance() : bean.getClass().newInstance();
        this.getPropertyUtils().copyProperties(object, bean);
        return object;
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor[] propertyDescriptorArray;
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.copyProperties(" + dest + ", " + orig + ")");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray;
            DynaProperty[] dynaPropertyArray2 = dynaPropertyArray = ((DynaBean)orig).getDynaClass().getDynaProperties();
            int n2 = dynaPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DynaProperty dynaProperty = dynaPropertyArray2[i2];
                String string = dynaProperty.getName();
                if (!this.getPropertyUtils().isReadable(orig, string) || !this.getPropertyUtils().isWriteable(dest, string)) continue;
                Object object = ((DynaBean)orig).get(string);
                this.copyProperty(dest, string, object);
            }
            return;
        }
        if (orig instanceof Map) {
            Map map = (Map)orig;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                if (!this.getPropertyUtils().isWriteable(dest, string)) continue;
                this.copyProperty(dest, string, entry.getValue());
            }
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(orig);
        int n3 = propertyDescriptorArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i3];
            String string = propertyDescriptor.getName();
            if ("class".equals(string) || !this.getPropertyUtils().isReadable(orig, string) || !this.getPropertyUtils().isWriteable(dest, string)) continue;
            try {
                Object object = this.getPropertyUtils().getSimpleProperty(orig, string);
                this.copyProperty(dest, string, object);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public void copyProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz;
        Object object;
        String[] stringArray;
        Object object2;
        if (this.log.isTraceEnabled()) {
            object2 = new StringBuilder("  copyProperty(");
            ((StringBuilder)object2).append(bean);
            ((StringBuilder)object2).append(", ");
            ((StringBuilder)object2).append(name);
            ((StringBuilder)object2).append(", ");
            if (value == null) {
                ((StringBuilder)object2).append("<NULL>");
            } else if (value instanceof String) {
                ((StringBuilder)object2).append((String)value);
            } else if (value instanceof String[]) {
                stringArray = (String[])value;
                ((StringBuilder)object2).append('[');
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 > 0) {
                        ((StringBuilder)object2).append(',');
                    }
                    ((StringBuilder)object2).append(stringArray[i2]);
                }
                ((StringBuilder)object2).append(']');
            } else {
                ((StringBuilder)object2).append(value.toString());
            }
            ((StringBuilder)object2).append(')');
            this.log.trace(((StringBuilder)object2).toString());
        }
        object2 = bean;
        stringArray = this.getPropertyUtils().getResolver();
        while (stringArray.hasNested(name)) {
            try {
                object2 = this.getPropertyUtils().getProperty(object2, stringArray.next(name));
                name = stringArray.remove(name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + object2);
            this.log.trace("    Target name = " + name);
        }
        String string = stringArray.getProperty(name);
        int n2 = stringArray.getIndex(name);
        String string2 = stringArray.getKey(name);
        if (object2 instanceof DynaBean) {
            object = ((DynaBean)object2).getDynaClass();
            DynaProperty dynaProperty = object.getDynaProperty(string);
            if (dynaProperty == null) {
                return;
            }
            clazz = BeanUtilsBean.dynaPropertyType(dynaProperty, value);
        } else {
            try {
                object = this.getPropertyUtils().getPropertyDescriptor(object2, name);
                if (object == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            clazz = ((PropertyDescriptor)object).getPropertyType();
            if (clazz == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("    target type for property '" + string + "' is null, so skipping ths setter");
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    target propName=" + string + ", type=" + clazz + ", index=" + n2 + ", key=" + string2);
        }
        if (n2 >= 0) {
            value = this.convertForCopy(value, clazz.getComponentType());
            try {
                this.getPropertyUtils().setIndexedProperty(object2, string, n2, value);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string);
            }
        }
        if (string2 != null) {
            try {
                this.getPropertyUtils().setMappedProperty(object2, string, string2, value);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string);
            }
        }
        value = this.convertForCopy(value, clazz);
        try {
            this.getPropertyUtils().setSimpleProperty(object2, string, value);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string);
        }
    }

    public Map<String, String> describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            return new HashMap<String, String>();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Describing bean: " + bean.getClass().getName());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (bean instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray;
            DynaProperty[] dynaPropertyArray2 = dynaPropertyArray = ((DynaBean)bean).getDynaClass().getDynaProperties();
            int n2 = dynaPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DynaProperty dynaProperty = dynaPropertyArray2[i2];
                String string = dynaProperty.getName();
                hashMap.put(string, this.getProperty(bean, string));
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(bean);
            Class<?> clazz = bean.getClass();
            PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray;
            int n3 = propertyDescriptorArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i3];
                String string = propertyDescriptor.getName();
                if (this.getPropertyUtils().getReadMethod(clazz, propertyDescriptor) == null) continue;
                hashMap.put(string, this.getProperty(bean, string));
            }
        }
        return hashMap;
    }

    public String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getProperty(bean, name);
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e2 : (Collection)object) {
                if (e2 == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(this.getConvertUtils().convert(e2));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2.toArray(new String[arrayList2.size()]);
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = Array.get(object, i2);
                stringArray[i2] = object2 == null ? null : this.getConvertUtils().convert(object2);
            }
            return stringArray;
        }
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = this.getConvertUtils().convert(object);
        return stringArray2;
    }

    public String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getIndexedProperty(bean, name);
        return this.getConvertUtils().convert(object);
    }

    public String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getIndexedProperty(bean, name, index);
        return this.getConvertUtils().convert(object);
    }

    public String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getMappedProperty(bean, name);
        return this.getConvertUtils().convert(object);
    }

    public String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getMappedProperty(bean, name, key);
        return this.getConvertUtils().convert(object);
    }

    public String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getNestedProperty(bean, name);
        return this.getConvertUtils().convert(object);
    }

    public String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getSimpleProperty(bean, name);
        return this.getConvertUtils().convert(object);
    }

    public void populate(Object bean, Map<String, ? extends Object> properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.populate(" + bean + ", " + properties + ")");
        }
        for (Map.Entry<String, ? extends Object> entry : properties.entrySet()) {
            String string = entry.getKey();
            if (string == null) continue;
            this.setProperty(bean, string, entry.getValue());
        }
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        Class clazz;
        String[] stringArray;
        Object object;
        String[] stringArray2;
        Object object2;
        if (this.log.isTraceEnabled()) {
            object2 = new StringBuilder("  setProperty(");
            ((StringBuilder)object2).append(bean);
            ((StringBuilder)object2).append(", ");
            ((StringBuilder)object2).append(name);
            ((StringBuilder)object2).append(", ");
            if (value == null) {
                ((StringBuilder)object2).append("<NULL>");
            } else if (value instanceof String) {
                ((StringBuilder)object2).append((String)value);
            } else if (value instanceof String[]) {
                stringArray2 = (String[])value;
                ((StringBuilder)object2).append('[');
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    if (i2 > 0) {
                        ((StringBuilder)object2).append(',');
                    }
                    ((StringBuilder)object2).append(stringArray2[i2]);
                }
                ((StringBuilder)object2).append(']');
            } else {
                ((StringBuilder)object2).append(value.toString());
            }
            ((StringBuilder)object2).append(')');
            this.log.trace(((StringBuilder)object2).toString());
        }
        object2 = bean;
        stringArray2 = this.getPropertyUtils().getResolver();
        while (stringArray2.hasNested(name)) {
            try {
                object2 = this.getPropertyUtils().getProperty(object2, stringArray2.next(name));
                if (object2 == null) {
                    return;
                }
                name = stringArray2.remove(name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + object2);
            this.log.trace("    Target name = " + name);
        }
        String string = stringArray2.getProperty(name);
        int n2 = stringArray2.getIndex(name);
        String string2 = stringArray2.getKey(name);
        if (object2 instanceof DynaBean) {
            object = ((DynaBean)object2).getDynaClass();
            stringArray = object.getDynaProperty(string);
            if (stringArray == null) {
                return;
            }
            clazz = BeanUtilsBean.dynaPropertyType((DynaProperty)stringArray, value);
            if (n2 >= 0 && List.class.isAssignableFrom(clazz)) {
                clazz = Object.class;
            }
        } else if (object2 instanceof Map) {
            clazz = Object.class;
        } else if (object2 != null && object2.getClass().isArray() && n2 >= 0) {
            clazz = Array.get(object2, n2).getClass();
        } else {
            try {
                object = this.getPropertyUtils().getPropertyDescriptor(object2, name);
                if (object == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            if (object instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)object).getMappedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((MappedPropertyDescriptor)object).getMappedPropertyType();
            } else if (n2 >= 0 && object instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)object).getIndexedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((IndexedPropertyDescriptor)object).getIndexedPropertyType();
            } else if (n2 >= 0 && List.class.isAssignableFrom(((PropertyDescriptor)object).getPropertyType())) {
                clazz = Object.class;
            } else if (string2 != null) {
                if (((PropertyDescriptor)object).getReadMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = value == null ? Object.class : value.getClass();
            } else {
                if (((PropertyDescriptor)object).getWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((PropertyDescriptor)object).getPropertyType();
            }
        }
        if (clazz.isArray() && n2 < 0) {
            if (value == null) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = null;
                object = this.getConvertUtils().convert(stringArray, clazz);
            } else {
                object = value instanceof String ? this.getConvertUtils().convert(value, clazz) : (value instanceof String[] ? this.getConvertUtils().convert((String[])value, clazz) : this.convert(value, clazz));
            }
        } else {
            object = clazz.isArray() ? (value instanceof String || value == null ? this.getConvertUtils().convert((String)value, clazz.getComponentType()) : (value instanceof String[] ? this.getConvertUtils().convert(((String[])value)[0], clazz.getComponentType()) : this.convert(value, clazz.getComponentType()))) : (value instanceof String ? this.getConvertUtils().convert((String)value, clazz) : (value instanceof String[] ? this.getConvertUtils().convert(((String[])value)[0], clazz) : this.convert(value, clazz)));
        }
        try {
            this.getPropertyUtils().setProperty(object2, name, object);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string);
        }
    }

    public ConvertUtilsBean getConvertUtils() {
        return this.convertUtilsBean;
    }

    public PropertyUtilsBean getPropertyUtils() {
        return this.propertyUtilsBean;
    }

    public boolean initCause(Throwable throwable, Throwable cause) {
        if (INIT_CAUSE_METHOD != null && cause != null) {
            try {
                INIT_CAUSE_METHOD.invoke((Object)throwable, cause);
                return true;
            }
            catch (Throwable throwable2) {
                return false;
            }
        }
        return false;
    }

    protected Object convert(Object value, Class<?> type) {
        Converter converter = this.getConvertUtils().lookup(type);
        if (converter != null) {
            this.log.trace("        USING CONVERTER " + converter);
            return converter.convert(type, value);
        }
        return value;
    }

    private Object convertForCopy(Object value, Class<?> type) {
        if (value != null) {
            return this.convert(value, type);
        }
        return value;
    }

    private static Method getInitCauseMethod() {
        try {
            Class[] classArray = new Class[]{Throwable.class};
            return Throwable.class.getMethod("initCause", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log log = LogFactory.getLog(BeanUtils.class);
            if (log.isWarnEnabled()) {
                log.warn("Throwable does not have initCause() method in JDK 1.3");
            }
            return null;
        }
        catch (Throwable throwable) {
            Log log = LogFactory.getLog(BeanUtils.class);
            if (log.isWarnEnabled()) {
                log.warn("Error getting the Throwable initCause() method", throwable);
            }
            return null;
        }
    }

    private static Class<?> dynaPropertyType(DynaProperty dynaProperty, Object value) {
        if (!dynaProperty.isMapped()) {
            return dynaProperty.getType();
        }
        if (value == null) {
            return String.class;
        }
        return value.getClass();
    }
}

