/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Reference<Class<?>> mappedPropertyTypeRef;
    private MappedMethodReference mappedReadMethodRef;
    private MappedMethodReference mappedWriteMethodRef;
    private static final Class<?>[] STRING_CLASS_PARAMETER = new Class[]{String.class};

    public MappedPropertyDescriptor(String propertyName, Class<?> beanClass) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName + " on class: " + beanClass.getClass().getName());
        }
        this.setName(propertyName);
        String string = MappedPropertyDescriptor.capitalizePropertyName(propertyName);
        Method method = null;
        Method method2 = null;
        try {
            try {
                method = MappedPropertyDescriptor.getMethod(beanClass, "get" + string, STRING_CLASS_PARAMETER);
            }
            catch (IntrospectionException introspectionException) {
                method = MappedPropertyDescriptor.getMethod(beanClass, "is" + string, STRING_CLASS_PARAMETER);
            }
            Class[] classArray = new Class[]{String.class, method.getReturnType()};
            method2 = MappedPropertyDescriptor.getMethod(beanClass, "set" + string, classArray);
        }
        catch (IntrospectionException introspectionException) {}
        if (method == null) {
            method2 = MappedPropertyDescriptor.getMethod(beanClass, "set" + string, 2);
        }
        if (method == null && method2 == null) {
            throw new IntrospectionException("Property '" + propertyName + "' not found on " + beanClass.getName());
        }
        this.mappedReadMethodRef = new MappedMethodReference(method);
        this.mappedWriteMethodRef = new MappedMethodReference(method2);
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Class<?> beanClass, String mappedGetterName, String mappedSetterName) throws IntrospectionException {
        super(propertyName, null, null);
        Method method;
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        Method method2 = MappedPropertyDescriptor.getMethod(beanClass, mappedGetterName, STRING_CLASS_PARAMETER);
        if (method2 != null) {
            Class[] classArray = new Class[]{String.class, method2.getReturnType()};
            method = MappedPropertyDescriptor.getMethod(beanClass, mappedSetterName, classArray);
        } else {
            method = MappedPropertyDescriptor.getMethod(beanClass, mappedSetterName, 2);
        }
        this.mappedReadMethodRef = new MappedMethodReference(method2);
        this.mappedWriteMethodRef = new MappedMethodReference(method);
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Method mappedGetter, Method mappedSetter) throws IntrospectionException {
        super(propertyName, mappedGetter, mappedSetter);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethodRef = new MappedMethodReference(mappedGetter);
        this.mappedWriteMethodRef = new MappedMethodReference(mappedSetter);
        this.findMappedPropertyType();
    }

    public Class<?> getMappedPropertyType() {
        return this.mappedPropertyTypeRef.get();
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethodRef.get();
    }

    public void setMappedReadMethod(Method mappedGetter) throws IntrospectionException {
        this.mappedReadMethodRef = new MappedMethodReference(mappedGetter);
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethodRef.get();
    }

    public void setMappedWriteMethod(Method mappedSetter) throws IntrospectionException {
        this.mappedWriteMethodRef = new MappedMethodReference(mappedSetter);
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        try {
            Method method = this.getMappedReadMethod();
            Method method2 = this.getMappedWriteMethod();
            Class<?> clazz = null;
            if (method != null) {
                if (method.getParameterTypes().length != 1) {
                    throw new IntrospectionException("bad mapped read method arg count");
                }
                clazz = method.getReturnType();
                if (clazz == Void.TYPE) {
                    throw new IntrospectionException("mapped read method " + method.getName() + " returns void");
                }
            }
            if (method2 != null) {
                Class<?>[] classArray = method2.getParameterTypes();
                if (classArray.length != 2) {
                    throw new IntrospectionException("bad mapped write method arg count");
                }
                if (clazz != null && clazz != classArray[1]) {
                    throw new IntrospectionException("type mismatch between mapped read and write methods");
                }
                clazz = classArray[1];
            }
            this.mappedPropertyTypeRef = new SoftReference<Object>(clazz);
            return;
        }
        catch (IntrospectionException introspectionException) {
            IntrospectionException introspectionException2 = introspectionException;
            throw introspectionException;
        }
    }

    private static String capitalizePropertyName(String s2) {
        if (s2.length() == 0) {
            return s2;
        }
        char[] cArray = s2.toCharArray();
        char[] cArray2 = cArray;
        cArray[0] = Character.toUpperCase(cArray2[0]);
        return new String(cArray2);
    }

    private static Method internalGetMethod(Class<?> initial, String methodName, int parameterCount) {
        Method method;
        int n2;
        GenericDeclaration[] genericDeclarationArray;
        Object object;
        for (object = initial; object != null; object = object.getSuperclass()) {
            genericDeclarationArray = object.getDeclaredMethods();
            Method[] methodArray = genericDeclarationArray;
            n2 = genericDeclarationArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                method = methodArray[i2];
                if (method == null || !Modifier.isPublic(n3 = method.getModifiers()) || Modifier.isStatic(n3) || !method.getName().equals(methodName) || method.getParameterTypes().length != parameterCount) continue;
                return method;
            }
        }
        object = initial.getInterfaces();
        genericDeclarationArray = object;
        int n4 = ((Class<?>[])object).length;
        for (n2 = 0; n2 < n4; ++n2) {
            GenericDeclaration genericDeclaration = genericDeclarationArray[n2];
            method = MappedPropertyDescriptor.internalGetMethod(genericDeclaration, methodName, parameterCount);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Class<?> clazz, String methodName, int parameterCount) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalGetMethod(clazz, methodName, parameterCount);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + methodName + "\" with " + parameterCount + " parameter(s)");
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        int n2 = parameterTypes == null ? 0 : parameterTypes.length;
        throw new IntrospectionException("No method \"" + methodName + "\" with " + n2 + " parameter(s) of matching types.");
    }

    private static class MappedMethodReference {
        private String className;
        private String methodName;
        private Reference<Method> methodRef;
        private Reference<Class<?>> classRef;
        private Reference<Class<?>> writeParamTypeRef0;
        private Reference<Class<?>> writeParamTypeRef1;
        private String[] writeParamClassNames;

        MappedMethodReference(Method m2) {
            if (m2 != null) {
                this.className = m2.getDeclaringClass().getName();
                this.methodName = m2.getName();
                this.methodRef = new SoftReference<Method>(m2);
                this.classRef = new WeakReference(m2.getDeclaringClass());
                Class<?>[] classArray = m2.getParameterTypes();
                if (classArray.length == 2) {
                    this.writeParamTypeRef0 = new WeakReference(classArray[0]);
                    this.writeParamTypeRef1 = new WeakReference(classArray[1]);
                    this.writeParamClassNames = new String[2];
                    this.writeParamClassNames[0] = classArray[0].getName();
                    this.writeParamClassNames[1] = classArray[1].getName();
                }
            }
        }

        private Method get() {
            if (this.methodRef == null) {
                return null;
            }
            Method method = this.methodRef.get();
            if (method == null) {
                Class[] classArray;
                Class<?> clazz = this.classRef.get();
                if (clazz == null && (clazz = this.reLoadClass()) != null) {
                    this.classRef = new WeakReference(clazz);
                }
                if (clazz == null) {
                    throw new RuntimeException("Method " + this.methodName + " for " + this.className + " could not be reconstructed - class reference has gone");
                }
                if (this.writeParamClassNames != null) {
                    Class[] classArray2 = new Class[2];
                    classArray = classArray2;
                    classArray2[0] = this.writeParamTypeRef0.get();
                    if (classArray[0] == null) {
                        MappedMethodReference mappedMethodReference = this;
                        classArray[0] = mappedMethodReference.reLoadClass(mappedMethodReference.writeParamClassNames[0]);
                        if (classArray[0] != null) {
                            this.writeParamTypeRef0 = new WeakReference<Class>(classArray[0]);
                        }
                    }
                    classArray[1] = this.writeParamTypeRef1.get();
                    if (classArray[1] == null) {
                        MappedMethodReference mappedMethodReference = this;
                        classArray[1] = mappedMethodReference.reLoadClass(mappedMethodReference.writeParamClassNames[1]);
                        if (classArray[1] != null) {
                            this.writeParamTypeRef1 = new WeakReference<Class>(classArray[1]);
                        }
                    }
                } else {
                    classArray = STRING_CLASS_PARAMETER;
                }
                try {
                    method = clazz.getMethod(this.methodName, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("Method " + this.methodName + " for " + this.className + " could not be reconstructed - method not found");
                }
                this.methodRef = new SoftReference<Method>(method);
            }
            return method;
        }

        private Class<?> reLoadClass() {
            MappedMethodReference mappedMethodReference = this;
            return mappedMethodReference.reLoadClass(mappedMethodReference.className);
        }

        private Class<?> reLoadClass(String name) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            classLoader = MappedPropertyDescriptor.class.getClassLoader();
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

