/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.KeyValue;

public final class DoubleOrderedMap
extends AbstractMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    public final Object getKeyForValue(Object value) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)value, 1);
    }

    public final Object removeValue(Object value) {
        return this.doRemove((Comparable)value, 1);
    }

    public final Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object k2 = entry.getKey();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getValue(), 1);
                    return node != null && Node.access$200(node, 0).equals(k2);
                }

                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object k2 = entry.getKey();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getValue(), 1);
                    if (node != null && Node.access$200(node, 0).equals(k2)) {
                        DoubleOrderedMap.access$300(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$000(1 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.setOfEntries[1];
    }

    public final Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object o2) {
                    return this.this$0.containsKey(o2);
                }

                public boolean remove(Object o2) {
                    int n2 = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.remove(o2);
                    return DoubleOrderedMap.access$500(this.this$0) != n2;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$400(2 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.setOfKeys[1];
    }

    public final Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 1){
                        private final 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object o2) {
                    return this.this$0.containsValue(o2);
                }

                public boolean remove(Object o2) {
                    int n2 = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.removeValue(o2);
                    return DoubleOrderedMap.access$500(this.this$0) != n2;
                }

                public boolean removeAll(Collection c2) {
                    boolean bl = false;
                    Iterator iterator = c2.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$600(3 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private Object doRemove(Comparable o2, int index) {
        Node node = this.lookup(o2, index);
        Comparable comparable = null;
        if (node != null) {
            comparable = Node.access$200(node, this.oppositeIndex(index));
            this.doRedBlackDelete(node);
        }
        return comparable;
    }

    private Object doGet(Comparable o2, int index) {
        DoubleOrderedMap.checkNonNullComparable(o2, index);
        Node node = this.lookup(o2, index);
        if (node == null) {
            return null;
        }
        return Node.access$200(node, this.oppositeIndex(index));
    }

    private int oppositeIndex(int index) {
        return 1 - index;
    }

    private Node lookup(Comparable data, int index) {
        Node node = null;
        Node node2 = this.rootNode[index];
        while (node2 != null) {
            int n2 = DoubleOrderedMap.compare(data, Node.access$200(node2, index));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? Node.access$700(node2, index) : Node.access$800(node2, index);
        }
        return node;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node, int index) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$700(node2, index) != null) {
                node2 = Node.access$700(node2, index);
            }
        }
        return node2;
    }

    private Node nextGreater(Node node, int index) {
        Node rval;
        if (node == null) {
            rval = null;
        } else if (Node.access$800(node, index) != null) {
            rval = DoubleOrderedMap.leastNode(Node.access$800(node, index), index);
        } else {
            Node node2 = Node.access$900(node, index);
            Node node3 = node;
            while (node2 != null && node3 == Node.access$800(node2, index)) {
                node3 = node2;
                node2 = Node.access$900(node2, index);
            }
            rval = node2;
        }
        return rval;
    }

    private static void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                Node.access$1000(to, index);
                return;
            }
            Node.access$1100(to, from, index);
        }
    }

    private static boolean isRed(Node node, int index) {
        if (node == null) {
            return false;
        }
        return Node.access$1200(node, index);
    }

    private static boolean isBlack(Node node, int index) {
        if (node == null) {
            return true;
        }
        return Node.access$1300(node, index);
    }

    private static void makeRed(Node node, int index) {
        if (node != null) {
            Node.access$1400(node, index);
        }
    }

    private static void makeBlack(Node node, int index) {
        if (node != null) {
            Node.access$1000(node, index);
        }
    }

    private static Node getGrandParent(Node node, int index) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, index), index);
    }

    private static Node getParent(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$900(node, index);
    }

    private static Node getRightChild(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$800(node, index);
    }

    private static Node getLeftChild(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$700(node, index);
    }

    private static boolean isLeftChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (Node.access$900(node, index) != null) {
            Node node2 = node;
            if (node2 == Node.access$700(Node.access$900(node2, index), index)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRightChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (Node.access$900(node, index) != null) {
            Node node2 = node;
            if (node2 == Node.access$800(Node.access$900(node2, index), index)) {
                return true;
            }
        }
        return false;
    }

    private void rotateLeft(Node node, int index) {
        Node node2 = Node.access$800(node, index);
        Node.access$1500(node, Node.access$700(node2, index), index);
        if (Node.access$700(node2, index) != null) {
            Node.access$1600(Node.access$700(node2, index), node, index);
        }
        Node.access$1600(node2, Node.access$900(node, index), index);
        if (Node.access$900(node, index) == null) {
            this.rootNode[index] = node2;
        } else if (Node.access$700(Node.access$900(node, index), index) == node) {
            Node.access$1700(Node.access$900(node, index), node2, index);
        } else {
            Node.access$1500(Node.access$900(node, index), node2, index);
        }
        Node.access$1700(node2, node, index);
        Node.access$1600(node, node2, index);
    }

    private void rotateRight(Node node, int index) {
        Node node2 = Node.access$700(node, index);
        Node.access$1700(node, Node.access$800(node2, index), index);
        if (Node.access$800(node2, index) != null) {
            Node.access$1600(Node.access$800(node2, index), node, index);
        }
        Node.access$1600(node2, Node.access$900(node, index), index);
        if (Node.access$900(node, index) == null) {
            this.rootNode[index] = node2;
        } else if (Node.access$800(Node.access$900(node, index), index) == node) {
            Node.access$1500(Node.access$900(node, index), node2, index);
        } else {
            Node.access$1700(Node.access$900(node, index), node2, index);
        }
        Node.access$1500(node2, node, index);
        Node.access$1600(node, node2, index);
    }

    private void doRedBlackInsert(Node insertedNode, int index) {
        Node node = insertedNode;
        DoubleOrderedMap.makeRed(node, index);
        while (node != null && node != this.rootNode[index] && DoubleOrderedMap.isRed(Node.access$900(node, index), index)) {
            Node node2;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(node, index), index)) {
                node2 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(node, index), index);
                if (DoubleOrderedMap.isRed(node2, index)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
                    DoubleOrderedMap.makeBlack(node2, index);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node, index), index);
                    node = DoubleOrderedMap.getGrandParent(node, index);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(node, index)) {
                    node = DoubleOrderedMap.getParent(node, index);
                    this.rotateLeft(node, index);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node, index), index);
                if (DoubleOrderedMap.getGrandParent(node, index) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(node, index), index);
                continue;
            }
            node2 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(node, index), index);
            if (DoubleOrderedMap.isRed(node2, index)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
                DoubleOrderedMap.makeBlack(node2, index);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node, index), index);
                node = DoubleOrderedMap.getGrandParent(node, index);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(node, index)) {
                node = DoubleOrderedMap.getParent(node, index);
                this.rotateRight(node, index);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node, index), index);
            if (DoubleOrderedMap.getGrandParent(node, index) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(node, index), index);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[index], index);
    }

    private void doRedBlackDelete(Node deletedNode) {
        for (int i2 = 0; i2 < 2; ++i2) {
            Node node;
            if (Node.access$700(deletedNode, i2) != null && Node.access$800(deletedNode, i2) != null) {
                DoubleOrderedMap doubleOrderedMap = this;
                doubleOrderedMap.swapPosition(doubleOrderedMap.nextGreater(deletedNode, i2), deletedNode, i2);
            }
            if ((node = Node.access$700(deletedNode, i2) != null ? Node.access$700(deletedNode, i2) : Node.access$800(deletedNode, i2)) != null) {
                Node.access$1600(node, Node.access$900(deletedNode, i2), i2);
                if (Node.access$900(deletedNode, i2) == null) {
                    this.rootNode[i2] = node;
                } else {
                    Node node2 = deletedNode;
                    if (node2 == Node.access$700(Node.access$900(node2, i2), i2)) {
                        Node.access$1700(Node.access$900(deletedNode, i2), node, i2);
                    } else {
                        Node.access$1500(Node.access$900(deletedNode, i2), node, i2);
                    }
                }
                Node.access$1700(deletedNode, null, i2);
                Node.access$1500(deletedNode, null, i2);
                Node.access$1600(deletedNode, null, i2);
                if (!DoubleOrderedMap.isBlack(deletedNode, i2)) continue;
                this.doRedBlackDeleteFixup(node, i2);
                continue;
            }
            if (Node.access$900(deletedNode, i2) == null) {
                this.rootNode[i2] = null;
                continue;
            }
            if (DoubleOrderedMap.isBlack(deletedNode, i2)) {
                this.doRedBlackDeleteFixup(deletedNode, i2);
            }
            if (Node.access$900(deletedNode, i2) == null) continue;
            Node node3 = deletedNode;
            if (node3 == Node.access$700(Node.access$900(node3, i2), i2)) {
                Node.access$1700(Node.access$900(deletedNode, i2), null, i2);
            } else {
                Node.access$1500(Node.access$900(deletedNode, i2), null, i2);
            }
            Node.access$1600(deletedNode, null, i2);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacementNode, int index) {
        Node node = replacementNode;
        while (node != this.rootNode[index] && DoubleOrderedMap.isBlack(node, index)) {
            Node node2;
            if (DoubleOrderedMap.isLeftChild(node, index)) {
                node2 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node, index), index);
                if (DoubleOrderedMap.isRed(node2, index)) {
                    DoubleOrderedMap.makeBlack(node2, index);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node, index), index);
                    this.rotateLeft(DoubleOrderedMap.getParent(node, index), index);
                    node2 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node, index), index);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node2, index), index) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node2, index), index)) {
                    DoubleOrderedMap.makeRed(node2, index);
                    node = DoubleOrderedMap.getParent(node, index);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node2, index), index)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node2, index), index);
                    DoubleOrderedMap.makeRed(node2, index);
                    this.rotateRight(node2, index);
                    node2 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node, index), index);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node, index), node2, index);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node2, index), index);
                this.rotateLeft(DoubleOrderedMap.getParent(node, index), index);
                node = this.rootNode[index];
                continue;
            }
            node2 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node, index), index);
            if (DoubleOrderedMap.isRed(node2, index)) {
                DoubleOrderedMap.makeBlack(node2, index);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node, index), index);
                this.rotateRight(DoubleOrderedMap.getParent(node, index), index);
                node2 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node, index), index);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node2, index), index) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node2, index), index)) {
                DoubleOrderedMap.makeRed(node2, index);
                node = DoubleOrderedMap.getParent(node, index);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node2, index), index)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node2, index), index);
                DoubleOrderedMap.makeRed(node2, index);
                this.rotateLeft(node2, index);
                node2 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node, index), index);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node, index), node2, index);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node, index), index);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node2, index), index);
            this.rotateRight(DoubleOrderedMap.getParent(node, index), index);
            node = this.rootNode[index];
        }
        DoubleOrderedMap.makeBlack(node, index);
    }

    /*
     * Unable to fully structure code
     */
    private void swapPosition(Node x, Node y, int index) {
        var4_4 = Node.access$900(x, index);
        var5_5 = Node.access$700(x, index);
        var6_6 = Node.access$800(x, index);
        var7_7 = Node.access$900(y, index);
        var8_8 = Node.access$700(y, index);
        var9_9 = Node.access$800(y, index);
        if (Node.access$900(x, index) == null) ** GOTO lbl-1000
        v0 = x;
        if (v0 == Node.access$700(Node.access$900(v0, index), index)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var10_10 = false;
        }
        if (Node.access$900(y, index) == null) ** GOTO lbl-1000
        v2 = y;
        if (v2 == Node.access$700(Node.access$900(v2, index), index)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = var11_11 = false;
        }
        if (x == var7_7) {
            Node.access$1600(x, y, index);
            if (var11_11) {
                Node.access$1700(y, x, index);
                Node.access$1500(y, var6_6, index);
            } else {
                Node.access$1500(y, x, index);
                Node.access$1700(y, var5_5, index);
            }
        } else {
            Node.access$1600(x, var7_7, index);
            if (var7_7 != null) {
                if (var11_11) {
                    Node.access$1700(var7_7, x, index);
                } else {
                    Node.access$1500(var7_7, x, index);
                }
            }
            Node.access$1700(y, var5_5, index);
            Node.access$1500(y, var6_6, index);
        }
        if (y == var4_4) {
            Node.access$1600(y, x, index);
            if (var10_10) {
                Node.access$1700(x, y, index);
                Node.access$1500(x, var9_9, index);
            } else {
                Node.access$1500(x, y, index);
                Node.access$1700(x, var8_8, index);
            }
        } else {
            Node.access$1600(y, var4_4, index);
            if (var4_4 != null) {
                if (var10_10) {
                    Node.access$1700(var4_4, y, index);
                } else {
                    Node.access$1500(var4_4, y, index);
                }
            }
            Node.access$1700(x, var8_8, index);
            Node.access$1500(x, var9_9, index);
        }
        if (Node.access$700(x, index) != null) {
            Node.access$1600(Node.access$700(x, index), x, index);
        }
        if (Node.access$800(x, index) != null) {
            Node.access$1600(Node.access$800(x, index), x, index);
        }
        if (Node.access$700(y, index) != null) {
            Node.access$1600(Node.access$700(y, index), y, index);
        }
        if (Node.access$800(y, index) != null) {
            Node.access$1600(Node.access$800(y, index), y, index);
        }
        Node.access$1800(x, y, index);
        if (this.rootNode[index] == x) {
            this.rootNode[index] = y;
            return;
        }
        if (this.rootNode[index] == y) {
            this.rootNode[index] = x;
        }
    }

    private static void checkNonNullComparable(Object o2, int index) {
        if (o2 == null) {
            throw new NullPointerException(dataName[index] + " cannot be null");
        }
        if (!(o2 instanceof Comparable)) {
            throw new ClassCastException(dataName[index] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        DoubleOrderedMap.checkNonNullComparable(key, 0);
    }

    private static void checkValue(Object value) {
        DoubleOrderedMap.checkNonNullComparable(value, 1);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        DoubleOrderedMap.checkKey(key);
        DoubleOrderedMap.checkValue(value);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        Node node = this.rootNode[1];
        while (true) {
            int n2;
            if ((n2 = DoubleOrderedMap.compare(Node.access$200(newNode, 1), Node.access$200(node, 1))) == 0) {
                throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.access$200(newNode, 1) + "\") in this Map");
            }
            if (n2 < 0) {
                if (Node.access$700(node, 1) != null) {
                    node = Node.access$700(node, 1);
                    continue;
                }
                Node.access$1700(node, newNode, 1);
                Node.access$1600(newNode, node, 1);
                this.doRedBlackInsert(newNode, 1);
                return;
            }
            if (Node.access$800(node, 1) == null) break;
            node = Node.access$800(node, 1);
        }
        Node.access$1500(node, newNode, 1);
        Node.access$1600(newNode, node, 1);
        this.doRedBlackInsert(newNode, 1);
    }

    public final int size() {
        return this.nodeCount;
    }

    public final boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        DoubleOrderedMap.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    public final boolean containsValue(Object value) {
        DoubleOrderedMap.checkValue(value);
        return this.lookup((Comparable)value, 1) != null;
    }

    public final Object get(Object key) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)key, 0);
    }

    public final Object put(Object key, Object value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(key, value);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node((Comparable)key, (Comparable)value);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n2;
                    if ((n2 = DoubleOrderedMap.compare((Comparable)key, Node.access$200(node, 0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (n2 < 0) {
                        if (Node.access$700(node, 0) != null) {
                            node = Node.access$700(node, 0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)key, (Comparable)value);
                        this.insertValue(node3);
                        Node.access$1700(node, node3, 0);
                        Node.access$1600(node3, node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (Node.access$800(node, 0) == null) break;
                    node = Node.access$800(node, 0);
                }
                Node node4 = new Node((Comparable)key, (Comparable)value);
                this.insertValue(node4);
                Node.access$1500(node, node4, 0);
                Node.access$1600(node4, node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public final Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public final void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public final Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 0);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object o2) {
                    return this.this$0.containsKey(o2);
                }

                public boolean remove(Object o2) {
                    int n2 = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.remove(o2);
                    return DoubleOrderedMap.access$500(this.this$0) != n2;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$1900(4 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.setOfKeys[0];
    }

    public final Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return Node.access$200(this.lastReturnedNode, 1);
                        }
                    };
                }

                public int size() {
                    return this.this$0.size();
                }

                public boolean contains(Object o2) {
                    return this.this$0.containsValue(o2);
                }

                public boolean remove(Object o2) {
                    int n2 = DoubleOrderedMap.access$500(this.this$0);
                    this.this$0.removeValue(o2);
                    return DoubleOrderedMap.access$500(this.this$0) != n2;
                }

                public boolean removeAll(Collection c2) {
                    boolean bl = false;
                    Iterator iterator = c2.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl = true;
                    }
                    return bl;
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$2000(5 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public final Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this, 0){
                        private final 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object v2 = entry.getValue();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getKey(), 0);
                    return node != null && Node.access$200(node, 1).equals(v2);
                }

                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object v2 = entry.getValue();
                    Node node = DoubleOrderedMap.access$100(this.this$0, (Comparable)entry.getKey(), 0);
                    if (node != null && Node.access$200(node, 1).equals(v2)) {
                        DoubleOrderedMap.access$300(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }

                public void clear() {
                    this.this$0.clear();
                }

                static DoubleOrderedMap access$2100(6 x0) {
                    return x0.this$0;
                }
            };
        }
        return this.setOfEntries[0];
    }

    static Node access$100(DoubleOrderedMap x0, Comparable x1, int x2) {
        return x0.lookup(x1, x2);
    }

    static void access$300(DoubleOrderedMap x0, Node x1) {
        x0.doRedBlackDelete(x1);
    }

    static int access$500(DoubleOrderedMap x0) {
        return x0.nodeCount;
    }

    static int access$2200(DoubleOrderedMap x0) {
        return x0.modifications;
    }

    static Node[] access$2300(DoubleOrderedMap x0) {
        return x0.rootNode;
    }

    static Node access$2400(Node x0, int x1) {
        return DoubleOrderedMap.leastNode(x0, x1);
    }

    static Node access$2500(DoubleOrderedMap x0, Node x1, int x2) {
        return x0.nextGreater(x1, x2);
    }

    private static final class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable key, Comparable value) {
            this.data = new Comparable[]{key, value};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index) {
            return this.data[index];
        }

        private void setLeft(Node node, int index) {
            this.leftNode[index] = node;
        }

        private Node getLeft(int index) {
            return this.leftNode[index];
        }

        private void setRight(Node node, int index) {
            this.rightNode[index] = node;
        }

        private Node getRight(int index) {
            return this.rightNode[index];
        }

        private void setParent(Node node, int index) {
            this.parentNode[index] = node;
        }

        private Node getParent(int index) {
            return this.parentNode[index];
        }

        private void swapColors(Node node, int index) {
            int n2 = index;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[index];
            int n3 = index;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[index];
            int n4 = index;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[index];
        }

        private boolean isBlack(int index) {
            return this.blackColor[index];
        }

        private boolean isRed(int index) {
            return !this.blackColor[index];
        }

        private void setBlack(int index) {
            this.blackColor[index] = true;
        }

        private void setRed(int index) {
            this.blackColor[index] = false;
        }

        private void copyColor(Node node, int index) {
            this.blackColor[index] = node.blackColor[index];
        }

        public final Object getKey() {
            return this.data[0];
        }

        public final Object getValue() {
            return this.data[1];
        }

        public final Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public final boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public final int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        static Comparable access$200(Node x0, int x1) {
            return x0.getData(x1);
        }

        static Node access$700(Node x0, int x1) {
            return x0.getLeft(x1);
        }

        static Node access$800(Node x0, int x1) {
            return x0.getRight(x1);
        }

        static Node access$900(Node x0, int x1) {
            return x0.getParent(x1);
        }

        static void access$1000(Node x0, int x1) {
            x0.setBlack(x1);
        }

        static void access$1100(Node x0, Node x1, int x2) {
            x0.copyColor(x1, x2);
        }

        static boolean access$1200(Node x0, int x1) {
            return x0.isRed(x1);
        }

        static boolean access$1300(Node x0, int x1) {
            return x0.isBlack(x1);
        }

        static void access$1400(Node x0, int x1) {
            x0.setRed(x1);
        }

        static void access$1500(Node x0, Node x1, int x2) {
            x0.setRight(x1, x2);
        }

        static void access$1600(Node x0, Node x1, int x2) {
            x0.setParent(x1, x2);
        }

        static void access$1700(Node x0, Node x1, int x2) {
            x0.setLeft(x1, x2);
        }

        static void access$1800(Node x0, Node x1, int x2) {
            x0.swapColors(x1, x2);
        }
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private int expectedModifications;
        protected Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;
        private final DoubleOrderedMap this$0;

        DoubleOrderedMapIterator(DoubleOrderedMap doubleOrderedMap, int type) {
            this.this$0 = doubleOrderedMap;
            this.iteratorType = type;
            this.expectedModifications = DoubleOrderedMap.access$2200(doubleOrderedMap);
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.access$2400(DoubleOrderedMap.access$2300(doubleOrderedMap)[this.iteratorType], this.iteratorType);
        }

        protected abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.access$2200(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.access$2500(this.this$0, this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.access$2200(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.access$300(this.this$0, this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }
    }
}

