/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
extends HashMap {
    protected HashMap map = null;
    protected boolean fast = false;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public FastHashMap(int capacity, float factor) {
        this.map = new HashMap(capacity, factor);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object object = hashMap.put(key, value);
                this.map = hashMap;
                return object;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map in) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.putAll(in);
                this.map = hashMap;
            }
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.putAll(in);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object v2 = hashMap.remove(key);
                this.map = hashMap;
                return v2;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                this.map = new HashMap();
            }
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.clear();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map map = (Map)o2;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
            return true;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k3 = entry.getKey();
                Object v3 = entry.getValue();
                if (v3 == null) {
                    if (map.get(k3) == null && map.containsKey(k3)) continue;
                    return false;
                }
                if (v3.equals(map.get(k3))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n2 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n2 += ((Object)iterator.next()).hashCode();
            }
            return n2;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n3 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n3 += ((Object)iterator.next()).hashCode();
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastHashMap fastHashMap;
        if (this.fast) {
            fastHashMap = new FastHashMap((Map)this.map);
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                fastHashMap = new FastHashMap((Map)this.map);
            }
        }
        fastHashMap.setFast(this.getFast());
        return fastHashMap;
    }

    public Set entrySet() {
        return new EntrySet(this, null);
    }

    public Set keySet() {
        return new KeySet(this, null);
    }

    public Collection values() {
        return new Values(this, null);
    }

    static class 1 {
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private final FastHashMap this$0;

        private EntrySet(FastHashMap fastHashMap) {
            super(fastHashMap);
            this.this$0 = fastHashMap;
        }

        protected Collection get(Map map) {
            return map.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }

        EntrySet(FastHashMap x0, 1 x1) {
            this(x0);
        }
    }

    private class Values
    extends CollectionView {
        private final FastHashMap this$0;

        private Values(FastHashMap fastHashMap) {
            super(fastHashMap);
            this.this$0 = fastHashMap;
        }

        protected Collection get(Map map) {
            return map.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }

        Values(FastHashMap x0, 1 x1) {
            this(x0);
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private final FastHashMap this$0;

        private KeySet(FastHashMap fastHashMap) {
            super(fastHashMap);
            this.this$0 = fastHashMap;
        }

        protected Collection get(Map map) {
            return map.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }

        KeySet(FastHashMap x0, 1 x1) {
            this(x0);
        }
    }

    private abstract class CollectionView
    implements Collection {
        private final FastHashMap this$0;

        public CollectionView(FastHashMap fastHashMap) {
            this.this$0 = fastHashMap;
        }

        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.this$0.fast) {
                FastHashMap fastHashMap = this.this$0;
                synchronized (fastHashMap) {
                    this.this$0.map = new HashMap();
                }
            } else {
                HashMap hashMap = this.this$0.map;
                synchronized (hashMap) {
                    CollectionView collectionView = this;
                    collectionView.get(collectionView.this$0.map).clear();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o2) {
            if (this.this$0.fast) {
                FastHashMap fastHashMap = this.this$0;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)this.this$0.map.clone();
                    boolean bl = this.get(hashMap).remove(o2);
                    this.this$0.map = hashMap;
                    return bl;
                }
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).remove(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection o2) {
            if (this.this$0.fast) {
                FastHashMap fastHashMap = this.this$0;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)this.this$0.map.clone();
                    boolean bl = this.get(hashMap).removeAll(o2);
                    this.this$0.map = hashMap;
                    return bl;
                }
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).removeAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection o2) {
            if (this.this$0.fast) {
                FastHashMap fastHashMap = this.this$0;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)this.this$0.map.clone();
                    boolean bl = this.get(hashMap).retainAll(o2);
                    this.this$0.map = hashMap;
                    return bl;
                }
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).retainAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).size();
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).isEmpty();
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).contains(o2);
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).contains(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).containsAll(o2);
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).containsAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray(o2);
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray();
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).equals(o2);
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).hashCode();
            }
            HashMap hashMap = this.this$0.map;
            synchronized (hashMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).hashCode();
            }
        }

        public boolean add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new CollectionViewIterator(this);
        }

        static FastHashMap access$300(CollectionView x0) {
            return x0.this$0;
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned;
            private Iterator iterator;
            private final CollectionView this$1;

            public CollectionViewIterator(CollectionView collectionView) {
                this.this$1 = collectionView;
                this.lastReturned = null;
                this.expected = CollectionView.access$300((CollectionView)collectionView).map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return this.this$1.iteratorNext(this.lastReturned);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (CollectionView.access$300((CollectionView)this.this$1).fast) {
                    FastHashMap fastHashMap = CollectionView.access$300(this.this$1);
                    synchronized (fastHashMap) {
                        if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                            throw new ConcurrentModificationException();
                        }
                        CollectionView.access$300(this.this$1).remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = CollectionView.access$300((CollectionView)this.this$1).map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

