/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    protected TreeMap map = null;
    protected boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap map) {
        this.map = new TreeMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.firstKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.lastKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object object = treeMap.put(key, value);
                this.map = treeMap;
                return object;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map in) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.putAll(in);
                this.map = treeMap;
            }
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                this.map.putAll(in);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object v2 = treeMap.remove(key);
                this.map = treeMap;
                return v2;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                this.map = new TreeMap();
            }
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                this.map.clear();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Map)) {
            return false;
        }
        Map map = (Map)o2;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k3 = entry.getKey();
                Object v3 = entry.getValue();
                if (v3 == null) {
                    if (map.get(k3) == null && map.containsKey(k3)) continue;
                    return false;
                }
                if (v3.equals(map.get(k3))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n2 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n2 += ((Object)iterator.next()).hashCode();
            }
            return n2;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n3 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n3 += ((Object)iterator.next()).hashCode();
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastTreeMap fastTreeMap;
        if (this.fast) {
            fastTreeMap = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                fastTreeMap = new FastTreeMap((SortedMap)this.map);
            }
        }
        fastTreeMap.setFast(this.getFast());
        return fastTreeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap headMap(Object key) {
        if (this.fast) {
            return this.map.headMap(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.headMap(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.fast) {
            return this.map.subMap(fromKey, toKey);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.subMap(fromKey, toKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap tailMap(Object key) {
        if (this.fast) {
            return this.map.tailMap(key);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            return this.map.tailMap(key);
        }
    }

    public Set entrySet() {
        return new EntrySet(this, null);
    }

    public Set keySet() {
        return new KeySet(this, null);
    }

    public Collection values() {
        return new Values(this, null);
    }

    static class 1 {
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private final FastTreeMap this$0;

        private EntrySet(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        protected Collection get(Map map) {
            return map.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }

        EntrySet(FastTreeMap x0, 1 x1) {
            this(x0);
        }
    }

    private class Values
    extends CollectionView {
        private final FastTreeMap this$0;

        private Values(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        protected Collection get(Map map) {
            return map.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }

        Values(FastTreeMap x0, 1 x1) {
            this(x0);
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private final FastTreeMap this$0;

        private KeySet(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        protected Collection get(Map map) {
            return map.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }

        KeySet(FastTreeMap x0, 1 x1) {
            this(x0);
        }
    }

    private abstract class CollectionView
    implements Collection {
        private final FastTreeMap this$0;

        public CollectionView(FastTreeMap fastTreeMap) {
            this.this$0 = fastTreeMap;
        }

        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    this.this$0.map = new TreeMap();
                }
            } else {
                TreeMap treeMap = this.this$0.map;
                synchronized (treeMap) {
                    CollectionView collectionView = this;
                    collectionView.get(collectionView.this$0.map).clear();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o2) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl = this.get(treeMap).remove(o2);
                    this.this$0.map = treeMap;
                    return bl;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).remove(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection o2) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl = this.get(treeMap).removeAll(o2);
                    this.this$0.map = treeMap;
                    return bl;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).removeAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection o2) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl = this.get(treeMap).retainAll(o2);
                    this.this$0.map = treeMap;
                    return bl;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).retainAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).size();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).isEmpty();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).contains(o2);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).contains(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).containsAll(o2);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).containsAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] o2) {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray(o2);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).equals(o2);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.this$0.fast) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).hashCode();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                CollectionView collectionView = this;
                return collectionView.get(collectionView.this$0.map).hashCode();
            }
        }

        public boolean add(Object o2) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new CollectionViewIterator(this);
        }

        static FastTreeMap access$300(CollectionView x0) {
            return x0.this$0;
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned;
            private Iterator iterator;
            private final CollectionView this$1;

            public CollectionViewIterator(CollectionView collectionView) {
                this.this$1 = collectionView;
                this.lastReturned = null;
                this.expected = CollectionView.access$300((CollectionView)collectionView).map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return this.this$1.iteratorNext(this.lastReturned);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (CollectionView.access$300((CollectionView)this.this$1).fast) {
                    FastTreeMap fastTreeMap = CollectionView.access$300(this.this$1);
                    synchronized (fastTreeMap) {
                        if (this.expected != CollectionView.access$300((CollectionView)this.this$1).map) {
                            throw new ConcurrentModificationException();
                        }
                        CollectionView.access$300(this.this$1).remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = CollectionView.access$300((CollectionView)this.this$1).map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

