/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bidimap;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.collections.OrderedIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.EmptyOrderedMapIterator;
import org.apache.commons.collections.keyvalue.UnmodifiableMapEntry;

public class TreeBidiMap
implements OrderedBidiMap {
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int MAPENTRY = 2;
    private static final int INVERSEMAPENTRY = 3;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};
    private Node[] rootNode = new Node[2];
    private int nodeCount = 0;
    private int modifications = 0;
    private Set keySet;
    private Set valuesSet;
    private Set entrySet;
    private Inverse inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map map) {
        this.putAll(map);
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean containsKey(Object key) {
        TreeBidiMap.checkKey(key);
        return this.lookup((Comparable)key, 0) != null;
    }

    public boolean containsValue(Object value) {
        TreeBidiMap.checkValue(value);
        return this.lookup((Comparable)value, 1) != null;
    }

    public Object get(Object key) {
        return this.doGet((Comparable)key, 0);
    }

    public Object put(Object key, Object value) {
        return this.doPut((Comparable)key, (Comparable)value, 0);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.doRemove((Comparable)key, 0);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    public Object getKey(Object value) {
        return this.doGet((Comparable)value, 1);
    }

    public Object removeValue(Object value) {
        return this.doRemove((Comparable)value, 1);
    }

    public Object firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.leastNode(this.rootNode[0], 0).getKey();
    }

    public Object lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return TreeBidiMap.greatestNode(this.rootNode[0], 0).getKey();
    }

    public Object nextKey(Object key) {
        TreeBidiMap.checkKey(key);
        TreeBidiMap treeBidiMap = this;
        Node node = treeBidiMap.nextGreater(treeBidiMap.lookup((Comparable)key, 0), 0);
        if (node == null) {
            return null;
        }
        return node.getKey();
    }

    public Object previousKey(Object key) {
        TreeBidiMap.checkKey(key);
        TreeBidiMap treeBidiMap = this;
        Node node = treeBidiMap.nextSmaller(treeBidiMap.lookup((Comparable)key, 0), 0);
        if (node == null) {
            return null;
        }
        return node.getKey();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new View(this, 0, 0);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.valuesSet == null) {
            this.valuesSet = new View(this, 0, 1);
        }
        return this.valuesSet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntryView(this, 0, 2);
        }
        return this.entrySet;
    }

    public MapIterator mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public OrderedMapIterator orderedMapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.INSTANCE;
        }
        return new ViewMapIterator(this, 0);
    }

    public BidiMap inverseBidiMap() {
        return this.inverseOrderedBidiMap();
    }

    public OrderedBidiMap inverseOrderedBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj, 0);
    }

    public int hashCode() {
        return this.doHashCode(0);
    }

    public String toString() {
        return this.doToString(0);
    }

    private Object doGet(Comparable obj, int index) {
        TreeBidiMap.checkNonNullComparable(obj, index);
        Node node = this.lookup(obj, index);
        if (node == null) {
            return null;
        }
        return Node.access$000(node, TreeBidiMap.oppositeIndex(index));
    }

    private Object doPut(Comparable key, Comparable value, int index) {
        Object object;
        block6: {
            TreeBidiMap.checkKeyAndValue(key, value);
            object = index == 0 ? this.doGet(key, 0) : this.doGet(value, 1);
            this.doRemove(key, 0);
            this.doRemove(value, 1);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node(key, value);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n2;
                    if ((n2 = TreeBidiMap.compare(key, Node.access$000(node, 0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (n2 < 0) {
                        if (Node.access$100(node, 0) != null) {
                            node = Node.access$100(node, 0);
                            continue;
                        }
                        Node node3 = new Node(key, value);
                        this.insertValue(node3);
                        Node.access$200(node, node3, 0);
                        Node.access$300(node3, node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (Node.access$400(node, 0) == null) break;
                    node = Node.access$400(node, 0);
                }
                Node node4 = new Node(key, value);
                this.insertValue(node4);
                Node.access$500(node, node4, 0);
                Node.access$300(node4, node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return object;
    }

    private Object doRemove(Comparable o2, int index) {
        Node node = this.lookup(o2, index);
        Comparable comparable = null;
        if (node != null) {
            comparable = Node.access$000(node, TreeBidiMap.oppositeIndex(index));
            this.doRedBlackDelete(node);
        }
        return comparable;
    }

    private Node lookup(Comparable data, int index) {
        Node node = null;
        Node node2 = this.rootNode[index];
        while (node2 != null) {
            int n2 = TreeBidiMap.compare(data, Node.access$000(node2, index));
            if (n2 == 0) {
                node = node2;
                break;
            }
            node2 = n2 < 0 ? Node.access$100(node2, index) : Node.access$400(node2, index);
        }
        return node;
    }

    private Node nextGreater(Node node, int index) {
        Node rval;
        if (node == null) {
            rval = null;
        } else if (Node.access$400(node, index) != null) {
            rval = TreeBidiMap.leastNode(Node.access$400(node, index), index);
        } else {
            Node node2 = Node.access$600(node, index);
            Node node3 = node;
            while (node2 != null && node3 == Node.access$400(node2, index)) {
                node3 = node2;
                node2 = Node.access$600(node2, index);
            }
            rval = node2;
        }
        return rval;
    }

    private Node nextSmaller(Node node, int index) {
        Node rval;
        if (node == null) {
            rval = null;
        } else if (Node.access$100(node, index) != null) {
            rval = TreeBidiMap.greatestNode(Node.access$100(node, index), index);
        } else {
            Node node2 = Node.access$600(node, index);
            Node node3 = node;
            while (node2 != null && node3 == Node.access$100(node2, index)) {
                node3 = node2;
                node2 = Node.access$600(node2, index);
            }
            rval = node2;
        }
        return rval;
    }

    private static int oppositeIndex(int index) {
        return 1 - index;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    private static Node leastNode(Node node, int index) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$100(node2, index) != null) {
                node2 = Node.access$100(node2, index);
            }
        }
        return node2;
    }

    private static Node greatestNode(Node node, int index) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.access$400(node2, index) != null) {
                node2 = Node.access$400(node2, index);
            }
        }
        return node2;
    }

    private static void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                Node.access$700(to, index);
                return;
            }
            Node.access$800(to, from, index);
        }
    }

    private static boolean isRed(Node node, int index) {
        if (node == null) {
            return false;
        }
        return Node.access$900(node, index);
    }

    private static boolean isBlack(Node node, int index) {
        if (node == null) {
            return true;
        }
        return Node.access$1000(node, index);
    }

    private static void makeRed(Node node, int index) {
        if (node != null) {
            Node.access$1100(node, index);
        }
    }

    private static void makeBlack(Node node, int index) {
        if (node != null) {
            Node.access$700(node, index);
        }
    }

    private static Node getGrandParent(Node node, int index) {
        return TreeBidiMap.getParent(TreeBidiMap.getParent(node, index), index);
    }

    private static Node getParent(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$600(node, index);
    }

    private static Node getRightChild(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$400(node, index);
    }

    private static Node getLeftChild(Node node, int index) {
        if (node == null) {
            return null;
        }
        return Node.access$100(node, index);
    }

    private static boolean isLeftChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (Node.access$600(node, index) != null) {
            Node node2 = node;
            if (node2 == Node.access$100(Node.access$600(node2, index), index)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRightChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (Node.access$600(node, index) != null) {
            Node node2 = node;
            if (node2 == Node.access$400(Node.access$600(node2, index), index)) {
                return true;
            }
        }
        return false;
    }

    private void rotateLeft(Node node, int index) {
        Node node2 = Node.access$400(node, index);
        Node.access$500(node, Node.access$100(node2, index), index);
        if (Node.access$100(node2, index) != null) {
            Node.access$300(Node.access$100(node2, index), node, index);
        }
        Node.access$300(node2, Node.access$600(node, index), index);
        if (Node.access$600(node, index) == null) {
            this.rootNode[index] = node2;
        } else if (Node.access$100(Node.access$600(node, index), index) == node) {
            Node.access$200(Node.access$600(node, index), node2, index);
        } else {
            Node.access$500(Node.access$600(node, index), node2, index);
        }
        Node.access$200(node2, node, index);
        Node.access$300(node, node2, index);
    }

    private void rotateRight(Node node, int index) {
        Node node2 = Node.access$100(node, index);
        Node.access$200(node, Node.access$400(node2, index), index);
        if (Node.access$400(node2, index) != null) {
            Node.access$300(Node.access$400(node2, index), node, index);
        }
        Node.access$300(node2, Node.access$600(node, index), index);
        if (Node.access$600(node, index) == null) {
            this.rootNode[index] = node2;
        } else if (Node.access$400(Node.access$600(node, index), index) == node) {
            Node.access$500(Node.access$600(node, index), node2, index);
        } else {
            Node.access$200(Node.access$600(node, index), node2, index);
        }
        Node.access$500(node2, node, index);
        Node.access$300(node, node2, index);
    }

    private void doRedBlackInsert(Node insertedNode, int index) {
        Node node = insertedNode;
        TreeBidiMap.makeRed(node, index);
        while (node != null && node != this.rootNode[index] && TreeBidiMap.isRed(Node.access$600(node, index), index)) {
            Node node2;
            if (TreeBidiMap.isLeftChild(TreeBidiMap.getParent(node, index), index)) {
                node2 = TreeBidiMap.getRightChild(TreeBidiMap.getGrandParent(node, index), index);
                if (TreeBidiMap.isRed(node2, index)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
                    TreeBidiMap.makeBlack(node2, index);
                    TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node, index), index);
                    node = TreeBidiMap.getGrandParent(node, index);
                    continue;
                }
                if (TreeBidiMap.isRightChild(node, index)) {
                    node = TreeBidiMap.getParent(node, index);
                    this.rotateLeft(node, index);
                }
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node, index), index);
                if (TreeBidiMap.getGrandParent(node, index) == null) continue;
                this.rotateRight(TreeBidiMap.getGrandParent(node, index), index);
                continue;
            }
            node2 = TreeBidiMap.getLeftChild(TreeBidiMap.getGrandParent(node, index), index);
            if (TreeBidiMap.isRed(node2, index)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
                TreeBidiMap.makeBlack(node2, index);
                TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node, index), index);
                node = TreeBidiMap.getGrandParent(node, index);
                continue;
            }
            if (TreeBidiMap.isLeftChild(node, index)) {
                node = TreeBidiMap.getParent(node, index);
                this.rotateRight(node, index);
            }
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
            TreeBidiMap.makeRed(TreeBidiMap.getGrandParent(node, index), index);
            if (TreeBidiMap.getGrandParent(node, index) == null) continue;
            this.rotateLeft(TreeBidiMap.getGrandParent(node, index), index);
        }
        TreeBidiMap.makeBlack(this.rootNode[index], index);
    }

    private void doRedBlackDelete(Node deletedNode) {
        for (int i2 = 0; i2 < 2; ++i2) {
            Node node;
            if (Node.access$100(deletedNode, i2) != null && Node.access$400(deletedNode, i2) != null) {
                TreeBidiMap treeBidiMap = this;
                treeBidiMap.swapPosition(treeBidiMap.nextGreater(deletedNode, i2), deletedNode, i2);
            }
            if ((node = Node.access$100(deletedNode, i2) != null ? Node.access$100(deletedNode, i2) : Node.access$400(deletedNode, i2)) != null) {
                Node.access$300(node, Node.access$600(deletedNode, i2), i2);
                if (Node.access$600(deletedNode, i2) == null) {
                    this.rootNode[i2] = node;
                } else {
                    Node node2 = deletedNode;
                    if (node2 == Node.access$100(Node.access$600(node2, i2), i2)) {
                        Node.access$200(Node.access$600(deletedNode, i2), node, i2);
                    } else {
                        Node.access$500(Node.access$600(deletedNode, i2), node, i2);
                    }
                }
                Node.access$200(deletedNode, null, i2);
                Node.access$500(deletedNode, null, i2);
                Node.access$300(deletedNode, null, i2);
                if (!TreeBidiMap.isBlack(deletedNode, i2)) continue;
                this.doRedBlackDeleteFixup(node, i2);
                continue;
            }
            if (Node.access$600(deletedNode, i2) == null) {
                this.rootNode[i2] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(deletedNode, i2)) {
                this.doRedBlackDeleteFixup(deletedNode, i2);
            }
            if (Node.access$600(deletedNode, i2) == null) continue;
            Node node3 = deletedNode;
            if (node3 == Node.access$100(Node.access$600(node3, i2), i2)) {
                Node.access$200(Node.access$600(deletedNode, i2), null, i2);
            } else {
                Node.access$500(Node.access$600(deletedNode, i2), null, i2);
            }
            Node.access$300(deletedNode, null, i2);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacementNode, int index) {
        Node node = replacementNode;
        while (node != this.rootNode[index] && TreeBidiMap.isBlack(node, index)) {
            Node node2;
            if (TreeBidiMap.isLeftChild(node, index)) {
                node2 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node, index), index);
                if (TreeBidiMap.isRed(node2, index)) {
                    TreeBidiMap.makeBlack(node2, index);
                    TreeBidiMap.makeRed(TreeBidiMap.getParent(node, index), index);
                    this.rotateLeft(TreeBidiMap.getParent(node, index), index);
                    node2 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node, index), index);
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node2, index), index) && TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node2, index), index)) {
                    TreeBidiMap.makeRed(node2, index);
                    node = TreeBidiMap.getParent(node, index);
                    continue;
                }
                if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node2, index), index)) {
                    TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(node2, index), index);
                    TreeBidiMap.makeRed(node2, index);
                    this.rotateRight(node2, index);
                    node2 = TreeBidiMap.getRightChild(TreeBidiMap.getParent(node, index), index);
                }
                TreeBidiMap.copyColor(TreeBidiMap.getParent(node, index), node2, index);
                TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(node2, index), index);
                this.rotateLeft(TreeBidiMap.getParent(node, index), index);
                node = this.rootNode[index];
                continue;
            }
            node2 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node, index), index);
            if (TreeBidiMap.isRed(node2, index)) {
                TreeBidiMap.makeBlack(node2, index);
                TreeBidiMap.makeRed(TreeBidiMap.getParent(node, index), index);
                this.rotateRight(TreeBidiMap.getParent(node, index), index);
                node2 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node, index), index);
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getRightChild(node2, index), index) && TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node2, index), index)) {
                TreeBidiMap.makeRed(node2, index);
                node = TreeBidiMap.getParent(node, index);
                continue;
            }
            if (TreeBidiMap.isBlack(TreeBidiMap.getLeftChild(node2, index), index)) {
                TreeBidiMap.makeBlack(TreeBidiMap.getRightChild(node2, index), index);
                TreeBidiMap.makeRed(node2, index);
                this.rotateLeft(node2, index);
                node2 = TreeBidiMap.getLeftChild(TreeBidiMap.getParent(node, index), index);
            }
            TreeBidiMap.copyColor(TreeBidiMap.getParent(node, index), node2, index);
            TreeBidiMap.makeBlack(TreeBidiMap.getParent(node, index), index);
            TreeBidiMap.makeBlack(TreeBidiMap.getLeftChild(node2, index), index);
            this.rotateRight(TreeBidiMap.getParent(node, index), index);
            node = this.rootNode[index];
        }
        TreeBidiMap.makeBlack(node, index);
    }

    /*
     * Unable to fully structure code
     */
    private void swapPosition(Node x, Node y, int index) {
        var4_4 = Node.access$600(x, index);
        var5_5 = Node.access$100(x, index);
        var6_6 = Node.access$400(x, index);
        var7_7 = Node.access$600(y, index);
        var8_8 = Node.access$100(y, index);
        var9_9 = Node.access$400(y, index);
        if (Node.access$600(x, index) == null) ** GOTO lbl-1000
        v0 = x;
        if (v0 == Node.access$100(Node.access$600(v0, index), index)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var10_10 = false;
        }
        if (Node.access$600(y, index) == null) ** GOTO lbl-1000
        v2 = y;
        if (v2 == Node.access$100(Node.access$600(v2, index), index)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = var11_11 = false;
        }
        if (x == var7_7) {
            Node.access$300(x, y, index);
            if (var11_11) {
                Node.access$200(y, x, index);
                Node.access$500(y, var6_6, index);
            } else {
                Node.access$500(y, x, index);
                Node.access$200(y, var5_5, index);
            }
        } else {
            Node.access$300(x, var7_7, index);
            if (var7_7 != null) {
                if (var11_11) {
                    Node.access$200(var7_7, x, index);
                } else {
                    Node.access$500(var7_7, x, index);
                }
            }
            Node.access$200(y, var5_5, index);
            Node.access$500(y, var6_6, index);
        }
        if (y == var4_4) {
            Node.access$300(y, x, index);
            if (var10_10) {
                Node.access$200(x, y, index);
                Node.access$500(x, var9_9, index);
            } else {
                Node.access$500(x, y, index);
                Node.access$200(x, var8_8, index);
            }
        } else {
            Node.access$300(y, var4_4, index);
            if (var4_4 != null) {
                if (var10_10) {
                    Node.access$200(var4_4, y, index);
                } else {
                    Node.access$500(var4_4, y, index);
                }
            }
            Node.access$200(x, var8_8, index);
            Node.access$500(x, var9_9, index);
        }
        if (Node.access$100(x, index) != null) {
            Node.access$300(Node.access$100(x, index), x, index);
        }
        if (Node.access$400(x, index) != null) {
            Node.access$300(Node.access$400(x, index), x, index);
        }
        if (Node.access$100(y, index) != null) {
            Node.access$300(Node.access$100(y, index), y, index);
        }
        if (Node.access$400(y, index) != null) {
            Node.access$300(Node.access$400(y, index), y, index);
        }
        Node.access$1200(x, y, index);
        if (this.rootNode[index] == x) {
            this.rootNode[index] = y;
            return;
        }
        if (this.rootNode[index] == y) {
            this.rootNode[index] = x;
        }
    }

    private static void checkNonNullComparable(Object o2, int index) {
        if (o2 == null) {
            throw new NullPointerException(dataName[index] + " cannot be null");
        }
        if (!(o2 instanceof Comparable)) {
            throw new ClassCastException(dataName[index] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        TreeBidiMap.checkNonNullComparable(key, 0);
    }

    private static void checkValue(Object value) {
        TreeBidiMap.checkNonNullComparable(value, 1);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        TreeBidiMap.checkKey(key);
        TreeBidiMap.checkValue(value);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        Node node = this.rootNode[1];
        while (true) {
            int n2;
            if ((n2 = TreeBidiMap.compare(Node.access$000(newNode, 1), Node.access$000(node, 1))) == 0) {
                throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.access$000(newNode, 1) + "\") in this Map");
            }
            if (n2 < 0) {
                if (Node.access$100(node, 1) != null) {
                    node = Node.access$100(node, 1);
                    continue;
                }
                Node.access$200(node, newNode, 1);
                Node.access$300(newNode, node, 1);
                this.doRedBlackInsert(newNode, 1);
                return;
            }
            if (Node.access$400(node, 1) == null) break;
            node = Node.access$400(node, 1);
        }
        Node.access$500(node, newNode, 1);
        Node.access$300(newNode, node, 1);
        this.doRedBlackInsert(newNode, 1);
    }

    private boolean doEquals(Object obj, int type) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (map.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                ViewMapIterator viewMapIterator = new ViewMapIterator(this, type);
                while (viewMapIterator.hasNext()) {
                    Object object = viewMapIterator.next();
                    Object object2 = viewMapIterator.getValue();
                    if (object2.equals(map.get(object))) continue;
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(int type) {
        int n2 = 0;
        if (this.nodeCount > 0) {
            ViewMapIterator viewMapIterator = new ViewMapIterator(this, type);
            while (viewMapIterator.hasNext()) {
                Object object = viewMapIterator.next();
                Object object2 = viewMapIterator.getValue();
                n2 += object.hashCode() ^ object2.hashCode();
            }
        }
        return n2;
    }

    private String doToString(int type) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(this.nodeCount << 5);
        stringBuffer.append('{');
        ViewMapIterator viewMapIterator = new ViewMapIterator(this, type);
        boolean bl = viewMapIterator.hasNext();
        while (bl) {
            Object object = viewMapIterator.next();
            Object object2 = viewMapIterator.getValue();
            stringBuffer.append(object == this ? "(this Map)" : object).append('=').append(object2 == this ? "(this Map)" : object2);
            bl = viewMapIterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static void access$1300(Object x0, int x1) {
        TreeBidiMap.checkNonNullComparable(x0, x1);
    }

    static Node access$1400(TreeBidiMap x0, Comparable x1, int x2) {
        return x0.lookup(x1, x2);
    }

    static Object access$1500(TreeBidiMap x0, Comparable x1, int x2) {
        return x0.doRemove(x1, x2);
    }

    static int access$1600(TreeBidiMap x0) {
        return x0.modifications;
    }

    static Node[] access$1700(TreeBidiMap x0) {
        return x0.rootNode;
    }

    static Node access$1800(Node x0, int x1) {
        return TreeBidiMap.leastNode(x0, x1);
    }

    static Node access$1900(TreeBidiMap x0, Node x1, int x2) {
        return x0.nextGreater(x1, x2);
    }

    static Node access$2000(TreeBidiMap x0, Node x1, int x2) {
        return x0.nextSmaller(x1, x2);
    }

    static void access$2100(TreeBidiMap x0, Node x1) {
        x0.doRedBlackDelete(x1);
    }

    static Node access$2200(Node x0, int x1) {
        return TreeBidiMap.greatestNode(x0, x1);
    }

    static int access$2300(int x0) {
        return TreeBidiMap.oppositeIndex(x0);
    }

    static int access$2400(TreeBidiMap x0) {
        return x0.nodeCount;
    }

    static void access$2500(Object x0) {
        TreeBidiMap.checkKey(x0);
    }

    static Object access$2600(TreeBidiMap x0, Comparable x1, Comparable x2, int x3) {
        return x0.doPut(x1, x2, x3);
    }

    static boolean access$2700(TreeBidiMap x0, Object x1, int x2) {
        return x0.doEquals(x1, x2);
    }

    static int access$2800(TreeBidiMap x0, int x1) {
        return x0.doHashCode(x1);
    }

    static String access$2900(TreeBidiMap x0, int x1) {
        return x0.doToString(x1);
    }

    static class Inverse
    implements OrderedBidiMap {
        private final TreeBidiMap main;
        private Set keySet;
        private Set valuesSet;
        private Set entrySet;

        Inverse(TreeBidiMap main) {
            this.main = main;
        }

        public int size() {
            return this.main.size();
        }

        public boolean isEmpty() {
            return this.main.isEmpty();
        }

        public Object get(Object key) {
            return this.main.getKey(key);
        }

        public Object getKey(Object value) {
            return this.main.get(value);
        }

        public boolean containsKey(Object key) {
            return this.main.containsValue(key);
        }

        public boolean containsValue(Object value) {
            return this.main.containsKey(value);
        }

        public Object firstKey() {
            if (TreeBidiMap.access$2400(this.main) == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.access$1800(TreeBidiMap.access$1700(this.main)[1], 1).getValue();
        }

        public Object lastKey() {
            if (TreeBidiMap.access$2400(this.main) == 0) {
                throw new NoSuchElementException("Map is empty");
            }
            return TreeBidiMap.access$2200(TreeBidiMap.access$1700(this.main)[1], 1).getValue();
        }

        public Object nextKey(Object key) {
            TreeBidiMap.access$2500(key);
            Node node = TreeBidiMap.access$1900(this.main, TreeBidiMap.access$1400(this.main, (Comparable)key, 1), 1);
            if (node == null) {
                return null;
            }
            return node.getValue();
        }

        public Object previousKey(Object key) {
            TreeBidiMap.access$2500(key);
            Node node = TreeBidiMap.access$2000(this.main, TreeBidiMap.access$1400(this.main, (Comparable)key, 1), 1);
            if (node == null) {
                return null;
            }
            return node.getValue();
        }

        public Object put(Object key, Object value) {
            return TreeBidiMap.access$2600(this.main, (Comparable)value, (Comparable)key, 1);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            return this.main.removeValue(key);
        }

        public Object removeValue(Object value) {
            return this.main.remove(value);
        }

        public void clear() {
            this.main.clear();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = new View(this.main, 1, 1);
            }
            return this.keySet;
        }

        public Collection values() {
            if (this.valuesSet == null) {
                this.valuesSet = new View(this.main, 1, 0);
            }
            return this.valuesSet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                return new EntryView(this.main, 1, 3);
            }
            return this.entrySet;
        }

        public MapIterator mapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public OrderedMapIterator orderedMapIterator() {
            if (this.isEmpty()) {
                return EmptyOrderedMapIterator.INSTANCE;
            }
            return new ViewMapIterator(this.main, 1);
        }

        public BidiMap inverseBidiMap() {
            return this.main;
        }

        public OrderedBidiMap inverseOrderedBidiMap() {
            return this.main;
        }

        public boolean equals(Object obj) {
            return TreeBidiMap.access$2700(this.main, obj, 1);
        }

        public int hashCode() {
            return TreeBidiMap.access$2800(this.main, 1);
        }

        public String toString() {
            return TreeBidiMap.access$2900(this.main, 1);
        }
    }

    static class Node
    implements Map.Entry,
    KeyValue {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        Node(Comparable key, Comparable value) {
            this.data = new Comparable[]{key, value};
            this.leftNode = new Node[2];
            this.rightNode = new Node[2];
            this.parentNode = new Node[2];
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        private Comparable getData(int index) {
            return this.data[index];
        }

        private void setLeft(Node node, int index) {
            this.leftNode[index] = node;
        }

        private Node getLeft(int index) {
            return this.leftNode[index];
        }

        private void setRight(Node node, int index) {
            this.rightNode[index] = node;
        }

        private Node getRight(int index) {
            return this.rightNode[index];
        }

        private void setParent(Node node, int index) {
            this.parentNode[index] = node;
        }

        private Node getParent(int index) {
            return this.parentNode[index];
        }

        private void swapColors(Node node, int index) {
            int n2 = index;
            this.blackColor[n2] = this.blackColor[n2] ^ node.blackColor[index];
            int n3 = index;
            node.blackColor[n3] = node.blackColor[n3] ^ this.blackColor[index];
            int n4 = index;
            this.blackColor[n4] = this.blackColor[n4] ^ node.blackColor[index];
        }

        private boolean isBlack(int index) {
            return this.blackColor[index];
        }

        private boolean isRed(int index) {
            return !this.blackColor[index];
        }

        private void setBlack(int index) {
            this.blackColor[index] = true;
        }

        private void setRed(int index) {
            this.blackColor[index] = false;
        }

        private void copyColor(Node node, int index) {
            this.blackColor[index] = node.blackColor[index];
        }

        public Object getKey() {
            return this.data[0];
        }

        public Object getValue() {
            return this.data[1];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        static Comparable access$000(Node x0, int x1) {
            return x0.getData(x1);
        }

        static Node access$100(Node x0, int x1) {
            return x0.getLeft(x1);
        }

        static void access$200(Node x0, Node x1, int x2) {
            x0.setLeft(x1, x2);
        }

        static void access$300(Node x0, Node x1, int x2) {
            x0.setParent(x1, x2);
        }

        static Node access$400(Node x0, int x1) {
            return x0.getRight(x1);
        }

        static void access$500(Node x0, Node x1, int x2) {
            x0.setRight(x1, x2);
        }

        static Node access$600(Node x0, int x1) {
            return x0.getParent(x1);
        }

        static void access$700(Node x0, int x1) {
            x0.setBlack(x1);
        }

        static void access$800(Node x0, Node x1, int x2) {
            x0.copyColor(x1, x2);
        }

        static boolean access$900(Node x0, int x1) {
            return x0.isRed(x1);
        }

        static boolean access$1000(Node x0, int x1) {
            return x0.isBlack(x1);
        }

        static void access$1100(Node x0, int x1) {
            x0.setRed(x1);
        }

        static void access$1200(Node x0, Node x1, int x2) {
            x0.swapColors(x1, x2);
        }
    }

    static class EntryView
    extends View {
        private final int oppositeType;

        EntryView(TreeBidiMap main, int orderType, int dataType) {
            super(main, orderType, dataType);
            this.oppositeType = TreeBidiMap.access$2300(orderType);
        }

        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object v2 = entry.getValue();
            Node node = TreeBidiMap.access$1400(this.main, (Comparable)entry.getKey(), this.orderType);
            return node != null && Node.access$000(node, this.oppositeType).equals(v2);
        }

        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object v2 = entry.getValue();
            Node node = TreeBidiMap.access$1400(this.main, (Comparable)entry.getKey(), this.orderType);
            if (node != null && Node.access$000(node, this.oppositeType).equals(v2)) {
                TreeBidiMap.access$2100(this.main, node);
                return true;
            }
            return false;
        }
    }

    static class ViewMapIterator
    extends ViewIterator
    implements OrderedMapIterator {
        private final int oppositeType;

        ViewMapIterator(TreeBidiMap main, int orderType) {
            int n2 = orderType;
            super(main, n2, n2);
            this.oppositeType = TreeBidiMap.access$2300(this.dataType);
        }

        public Object getKey() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
            }
            return Node.access$000(this.lastReturnedNode, this.dataType);
        }

        public Object getValue() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
            }
            return Node.access$000(this.lastReturnedNode, this.oppositeType);
        }

        public Object setValue(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    static class ViewIterator
    implements OrderedIterator {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;
        protected Node lastReturnedNode;
        protected Node nextNode;
        protected Node previousNode;
        private int expectedModifications;

        ViewIterator(TreeBidiMap main, int orderType, int dataType) {
            this.main = main;
            this.orderType = orderType;
            this.dataType = dataType;
            this.expectedModifications = TreeBidiMap.access$1600(main);
            this.nextNode = TreeBidiMap.access$1800(TreeBidiMap.access$1700(main)[orderType], orderType);
            this.lastReturnedNode = null;
            this.previousNode = null;
        }

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = TreeBidiMap.access$1900(this.main, this.nextNode, this.orderType);
            return this.doGetData();
        }

        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        public Object previous() {
            if (this.previousNode == null) {
                throw new NoSuchElementException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.lastReturnedNode;
            if (this.nextNode == null) {
                this.nextNode = TreeBidiMap.access$1900(this.main, this.previousNode, this.orderType);
            }
            this.lastReturnedNode = this.previousNode;
            this.previousNode = TreeBidiMap.access$2000(this.main, this.previousNode, this.orderType);
            return this.doGetData();
        }

        protected Object doGetData() {
            switch (this.dataType) {
                case 0: {
                    return this.lastReturnedNode.getKey();
                }
                case 1: {
                    return this.lastReturnedNode.getValue();
                }
                case 2: {
                    return this.lastReturnedNode;
                }
                case 3: {
                    return new UnmodifiableMapEntry(this.lastReturnedNode.getValue(), this.lastReturnedNode.getKey());
                }
            }
            return null;
        }

        public final void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (TreeBidiMap.access$1600(this.main) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            TreeBidiMap.access$2100(this.main, this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
            if (this.nextNode == null) {
                this.previousNode = TreeBidiMap.access$2200(TreeBidiMap.access$1700(this.main)[this.orderType], this.orderType);
                return;
            }
            this.previousNode = TreeBidiMap.access$2000(this.main, this.nextNode, this.orderType);
        }
    }

    static class View
    extends AbstractSet {
        protected final TreeBidiMap main;
        protected final int orderType;
        protected final int dataType;

        View(TreeBidiMap main, int orderType, int dataType) {
            this.main = main;
            this.orderType = orderType;
            this.dataType = dataType;
        }

        public Iterator iterator() {
            return new ViewIterator(this.main, this.orderType, this.dataType);
        }

        public int size() {
            return this.main.size();
        }

        public boolean contains(Object obj) {
            TreeBidiMap.access$1300(obj, this.dataType);
            return TreeBidiMap.access$1400(this.main, (Comparable)obj, this.dataType) != null;
        }

        public boolean remove(Object obj) {
            return TreeBidiMap.access$1500(this.main, (Comparable)obj, this.dataType) != null;
        }

        public void clear() {
            this.main.clear();
        }
    }
}

