/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.buffer.SynchronizedBuffer;

public class BlockingBuffer
extends SynchronizedBuffer {
    private static final long serialVersionUID = 1719328905017860541L;
    private final long timeout;

    public static Buffer decorate(Buffer buffer) {
        return new BlockingBuffer(buffer);
    }

    public static Buffer decorate(Buffer buffer, long timeoutMillis) {
        return new BlockingBuffer(buffer, timeoutMillis);
    }

    protected BlockingBuffer(Buffer buffer) {
        super(buffer);
        this.timeout = 0L;
    }

    protected BlockingBuffer(Buffer buffer, long timeoutMillis) {
        super(buffer);
        this.timeout = timeoutMillis < 0L ? 0L : timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.collection.add(o2);
            this.lock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.collection.addAll(c2);
            this.lock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    BlockingBuffer blockingBuffer = this;
                    return blockingBuffer.get(blockingBuffer.timeout);
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + timeout;
            long l3 = l2 - System.currentTimeMillis();
            while (l3 > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(l3);
                    l3 = l2 - System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            return this.getBuffer().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove() {
        Object object = this.lock;
        synchronized (object) {
            while (this.collection.isEmpty()) {
                try {
                    if (this.timeout <= 0L) {
                        this.lock.wait();
                        continue;
                    }
                    BlockingBuffer blockingBuffer = this;
                    return blockingBuffer.remove(blockingBuffer.timeout);
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            return this.getBuffer().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis() + timeout;
            long l3 = l2 - System.currentTimeMillis();
            while (l3 > 0L && this.collection.isEmpty()) {
                try {
                    this.lock.wait(l3);
                    l3 = l2 - System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    PrintWriter printWriter = new PrintWriter(new StringWriter());
                    interruptedException.printStackTrace(printWriter);
                    throw new BufferUnderflowException("Caused by InterruptedException: " + printWriter.toString());
                }
            }
            if (this.collection.isEmpty()) {
                throw new BufferUnderflowException("Timeout expired");
            }
            return this.getBuffer().remove();
        }
    }
}

