/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.io.Serializable;
import java.util.Comparator;

public final class BooleanComparator
implements Serializable,
Comparator {
    private static final long serialVersionUID = 1830042991606340609L;
    private static final BooleanComparator TRUE_FIRST = new BooleanComparator(true);
    private static final BooleanComparator FALSE_FIRST = new BooleanComparator(false);
    private boolean trueFirst = false;

    public static BooleanComparator getTrueFirstComparator() {
        return TRUE_FIRST;
    }

    public static BooleanComparator getFalseFirstComparator() {
        return FALSE_FIRST;
    }

    public static BooleanComparator getBooleanComparator(boolean trueFirst) {
        if (trueFirst) {
            return TRUE_FIRST;
        }
        return FALSE_FIRST;
    }

    public BooleanComparator() {
        this(false);
    }

    public BooleanComparator(boolean trueFirst) {
        this.trueFirst = trueFirst;
    }

    public final int compare(Object obj1, Object obj2) {
        return this.compare((Boolean)obj1, (Boolean)obj2);
    }

    public final int compare(Boolean b1, Boolean b2) {
        boolean bl;
        boolean bl2 = b1;
        if (bl2 ^ (bl = b2.booleanValue())) {
            if (bl2 ^ this.trueFirst) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public final int hashCode() {
        int n2 = "BooleanComparator".hashCode();
        if (this.trueFirst) {
            return -1 * n2;
        }
        return n2;
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof BooleanComparator && this.trueFirst == ((BooleanComparator)object).trueFirst;
    }

    public final boolean sortsTrueFirst() {
        return this.trueFirst;
    }
}

