/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.UUID;

public class Conversion {
    private static final boolean[] TTTT = new boolean[]{true, true, true, true};
    private static final boolean[] FTTT = new boolean[]{false, true, true, true};
    private static final boolean[] TFTT = new boolean[]{true, false, true, true};
    private static final boolean[] FFTT = new boolean[]{false, false, true, true};
    private static final boolean[] TTFT = new boolean[]{true, true, false, true};
    private static final boolean[] FTFT = new boolean[]{false, true, false, true};
    private static final boolean[] TFFT = new boolean[]{true, false, false, true};
    private static final boolean[] FFFT = new boolean[]{false, false, false, true};
    private static final boolean[] TTTF = new boolean[]{true, true, true, false};
    private static final boolean[] FTTF = new boolean[]{false, true, true, false};
    private static final boolean[] TFTF = new boolean[]{true, false, true, false};
    private static final boolean[] FFTF = new boolean[]{false, false, true, false};
    private static final boolean[] TTFF = new boolean[]{true, true, false, false};
    private static final boolean[] FTFF = new boolean[]{false, true, false, false};
    private static final boolean[] TFFF = new boolean[]{true, false, false, false};
    private static final boolean[] FFFF = new boolean[]{false, false, false, false};

    public static int hexDigitToInt(char hexDigit) {
        int n2 = Character.digit(hexDigit, 16);
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot interpret '" + hexDigit + "' as a hexadecimal digit");
        }
        return n2;
    }

    public static int hexDigitMsb0ToInt(char hexDigit) {
        switch (hexDigit) {
            case '0': {
                return 0;
            }
            case '1': {
                return 8;
            }
            case '2': {
                return 4;
            }
            case '3': {
                return 12;
            }
            case '4': {
                return 2;
            }
            case '5': {
                return 10;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 14;
            }
            case '8': {
                return 1;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 5;
            }
            case 'B': 
            case 'b': {
                return 13;
            }
            case 'C': 
            case 'c': {
                return 3;
            }
            case 'D': 
            case 'd': {
                return 11;
            }
            case 'E': 
            case 'e': {
                return 7;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + hexDigit + "' as a hexadecimal digit");
    }

    public static boolean[] hexDigitToBinary(char hexDigit) {
        switch (hexDigit) {
            case '0': {
                return (boolean[])FFFF.clone();
            }
            case '1': {
                return (boolean[])TFFF.clone();
            }
            case '2': {
                return (boolean[])FTFF.clone();
            }
            case '3': {
                return (boolean[])TTFF.clone();
            }
            case '4': {
                return (boolean[])FFTF.clone();
            }
            case '5': {
                return (boolean[])TFTF.clone();
            }
            case '6': {
                return (boolean[])FTTF.clone();
            }
            case '7': {
                return (boolean[])TTTF.clone();
            }
            case '8': {
                return (boolean[])FFFT.clone();
            }
            case '9': {
                return (boolean[])TFFT.clone();
            }
            case 'A': 
            case 'a': {
                return (boolean[])FTFT.clone();
            }
            case 'B': 
            case 'b': {
                return (boolean[])TTFT.clone();
            }
            case 'C': 
            case 'c': {
                return (boolean[])FFTT.clone();
            }
            case 'D': 
            case 'd': {
                return (boolean[])TFTT.clone();
            }
            case 'E': 
            case 'e': {
                return (boolean[])FTTT.clone();
            }
            case 'F': 
            case 'f': {
                return (boolean[])TTTT.clone();
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + hexDigit + "' as a hexadecimal digit");
    }

    public static boolean[] hexDigitMsb0ToBinary(char hexDigit) {
        switch (hexDigit) {
            case '0': {
                return (boolean[])FFFF.clone();
            }
            case '1': {
                return (boolean[])FFFT.clone();
            }
            case '2': {
                return (boolean[])FFTF.clone();
            }
            case '3': {
                return (boolean[])FFTT.clone();
            }
            case '4': {
                return (boolean[])FTFF.clone();
            }
            case '5': {
                return (boolean[])FTFT.clone();
            }
            case '6': {
                return (boolean[])FTTF.clone();
            }
            case '7': {
                return (boolean[])FTTT.clone();
            }
            case '8': {
                return (boolean[])TFFF.clone();
            }
            case '9': {
                return (boolean[])TFFT.clone();
            }
            case 'A': 
            case 'a': {
                return (boolean[])TFTF.clone();
            }
            case 'B': 
            case 'b': {
                return (boolean[])TFTT.clone();
            }
            case 'C': 
            case 'c': {
                return (boolean[])TTFF.clone();
            }
            case 'D': 
            case 'd': {
                return (boolean[])TTFT.clone();
            }
            case 'E': 
            case 'e': {
                return (boolean[])TTTF.clone();
            }
            case 'F': 
            case 'f': {
                return (boolean[])TTTT.clone();
            }
        }
        throw new IllegalArgumentException("Cannot interpret '" + hexDigit + "' as a hexadecimal digit");
    }

    public static char binaryToHexDigit(boolean[] src) {
        return Conversion.binaryToHexDigit(src, 0);
    }

    public static char binaryToHexDigit(boolean[] src, int srcPos) {
        if (src.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array.");
        }
        if (src.length > srcPos + 3 && src[srcPos + 3]) {
            if (src.length > srcPos + 2 && src[srcPos + 2]) {
                if (src.length > srcPos + 1 && src[srcPos + 1]) {
                    if (src[srcPos]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (src[srcPos]) {
                    return 'd';
                }
                return 'c';
            }
            if (src.length > srcPos + 1 && src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'b';
                }
                return 'a';
            }
            if (src[srcPos]) {
                return '9';
            }
            return '8';
        }
        if (src.length > srcPos + 2 && src[srcPos + 2]) {
            if (src.length > srcPos + 1 && src[srcPos + 1]) {
                if (src[srcPos]) {
                    return '7';
                }
                return '6';
            }
            if (src[srcPos]) {
                return '5';
            }
            return '4';
        }
        if (src.length > srcPos + 1 && src[srcPos + 1]) {
            if (src[srcPos]) {
                return '3';
            }
            return '2';
        }
        if (src[srcPos]) {
            return '1';
        }
        return '0';
    }

    public static char binaryToHexDigitMsb0_4bits(boolean[] src) {
        return Conversion.binaryToHexDigitMsb0_4bits(src, 0);
    }

    public static char binaryToHexDigitMsb0_4bits(boolean[] src, int srcPos) {
        if (src.length > 8) {
            throw new IllegalArgumentException("src.length>8: src.length=" + src.length);
        }
        if (src.length - srcPos < 4) {
            throw new IllegalArgumentException("src.length-srcPos<4: src.length=" + src.length + ", srcPos=" + srcPos);
        }
        if (src[srcPos + 3]) {
            if (src[srcPos + 2]) {
                if (src[srcPos + 1]) {
                    if (src[srcPos]) {
                        return 'f';
                    }
                    return '7';
                }
                if (src[srcPos]) {
                    return 'b';
                }
                return '3';
            }
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'd';
                }
                return '5';
            }
            if (src[srcPos]) {
                return '9';
            }
            return '1';
        }
        if (src[srcPos + 2]) {
            if (src[srcPos + 1]) {
                if (src[srcPos]) {
                    return 'e';
                }
                return '6';
            }
            if (src[srcPos]) {
                return 'a';
            }
            return '2';
        }
        if (src[srcPos + 1]) {
            if (src[srcPos]) {
                return 'c';
            }
            return '4';
        }
        if (src[srcPos]) {
            return '8';
        }
        return '0';
    }

    public static char binaryBeMsb0ToHexDigit(boolean[] src) {
        return Conversion.binaryBeMsb0ToHexDigit(src, 0);
    }

    public static char binaryBeMsb0ToHexDigit(boolean[] src, int srcPos) {
        if (src.length == 0) {
            throw new IllegalArgumentException("Cannot convert an empty array.");
        }
        int n2 = src.length - 1 - srcPos;
        int n3 = Math.min(4, n2 + 1);
        boolean[] blArray = new boolean[4];
        System.arraycopy(src, n2 + 1 - n3, blArray, 4 - n3, n3);
        src = blArray;
        if (blArray[0]) {
            if (src[1]) {
                if (src[2]) {
                    if (src[3]) {
                        return 'f';
                    }
                    return 'e';
                }
                if (src[3]) {
                    return 'd';
                }
                return 'c';
            }
            if (src[2]) {
                if (src[3]) {
                    return 'b';
                }
                return 'a';
            }
            if (src[3]) {
                return '9';
            }
            return '8';
        }
        if (src[1]) {
            if (src[2]) {
                if (src[3]) {
                    return '7';
                }
                return '6';
            }
            if (src[3]) {
                return '5';
            }
            return '4';
        }
        if (src[2]) {
            if (src[3]) {
                return '3';
            }
            return '2';
        }
        if (src[3]) {
            return '1';
        }
        return '0';
    }

    public static char intToHexDigit(int nibble) {
        char c2 = Character.forDigit(nibble, 16);
        if (c2 == '\u0000') {
            throw new IllegalArgumentException("nibble value not between 0 and 15: " + nibble);
        }
        return c2;
    }

    public static char intToHexDigitMsb0(int nibble) {
        switch (nibble) {
            case 0: {
                return '0';
            }
            case 1: {
                return '8';
            }
            case 2: {
                return '4';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return '2';
            }
            case 5: {
                return 'a';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return 'e';
            }
            case 8: {
                return '1';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '5';
            }
            case 11: {
                return 'd';
            }
            case 12: {
                return '3';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return '7';
            }
            case 15: {
                return 'f';
            }
        }
        throw new IllegalArgumentException("nibble value not between 0 and 15: " + nibble);
    }

    public static long intArrayToLong(int[] src, int srcPos, long dstInit, int dstPos, int nInts) {
        if (src.length == 0 && srcPos == 0 || nInts == 0) {
            return dstInit;
        }
        if ((nInts - 1 << 5) + dstPos >= 64) {
            throw new IllegalArgumentException("(nInts-1)*32+dstPos is greater or equal to than 64");
        }
        long l2 = dstInit;
        for (int i2 = 0; i2 < nInts; ++i2) {
            int n2 = (i2 << 5) + dstPos;
            long l3 = (0xFFFFFFFFL & (long)src[i2 + srcPos]) << n2;
            long l4 = 0xFFFFFFFFL << n2;
            l2 = l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL) | l3;
        }
        return l2;
    }

    public static long shortArrayToLong(short[] src, int srcPos, long dstInit, int dstPos, int nShorts) {
        if (src.length == 0 && srcPos == 0 || nShorts == 0) {
            return dstInit;
        }
        if ((nShorts - 1 << 4) + dstPos >= 64) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greater or equal to than 64");
        }
        long l2 = dstInit;
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int n2 = (i2 << 4) + dstPos;
            long l3 = (0xFFFFL & (long)src[i2 + srcPos]) << n2;
            long l4 = 65535L << n2;
            l2 = l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL) | l3;
        }
        return l2;
    }

    public static int shortArrayToInt(short[] src, int srcPos, int dstInit, int dstPos, int nShorts) {
        if (src.length == 0 && srcPos == 0 || nShorts == 0) {
            return dstInit;
        }
        if ((nShorts - 1 << 4) + dstPos >= 32) {
            throw new IllegalArgumentException("(nShorts-1)*16+dstPos is greater or equal to than 32");
        }
        int n2 = dstInit;
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int n3 = (i2 << 4) + dstPos;
            int n4 = (0xFFFF & src[i2 + srcPos]) << n3;
            int n5 = 65535 << n3;
            n2 = n2 & ~n5 | n4;
        }
        return n2;
    }

    public static long byteArrayToLong(byte[] src, int srcPos, long dstInit, int dstPos, int nBytes) {
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 64");
        }
        long l2 = dstInit;
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n2 = (i2 << 3) + dstPos;
            long l3 = (0xFFL & (long)src[i2 + srcPos]) << n2;
            long l4 = 255L << n2;
            l2 = l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL) | l3;
        }
        return l2;
    }

    public static int byteArrayToInt(byte[] src, int srcPos, int dstInit, int dstPos, int nBytes) {
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 32) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 32");
        }
        int n2 = dstInit;
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n3 = (i2 << 3) + dstPos;
            int n4 = (0xFF & src[i2 + srcPos]) << n3;
            int n5 = 255 << n3;
            n2 = n2 & ~n5 | n4;
        }
        return n2;
    }

    public static short byteArrayToShort(byte[] src, int srcPos, short dstInit, int dstPos, int nBytes) {
        if (src.length == 0 && srcPos == 0 || nBytes == 0) {
            return dstInit;
        }
        if ((nBytes - 1 << 3) + dstPos >= 16) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 16");
        }
        short s2 = dstInit;
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n2 = (i2 << 3) + dstPos;
            int n3 = (0xFF & src[i2 + srcPos]) << n2;
            int n4 = 255 << n2;
            s2 = (short)(s2 & ~n4 | n3);
        }
        return s2;
    }

    public static long hexToLong(String src, int srcPos, long dstInit, int dstPos, int nHex) {
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 64");
        }
        long l2 = dstInit;
        for (int i2 = 0; i2 < nHex; ++i2) {
            int n2 = (i2 << 2) + dstPos;
            long l3 = (0xFL & (long)Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << n2;
            long l4 = 15L << n2;
            l2 = l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL) | l3;
        }
        return l2;
    }

    public static int hexToInt(String src, int srcPos, int dstInit, int dstPos, int nHex) {
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 32");
        }
        int n2 = dstInit;
        for (int i2 = 0; i2 < nHex; ++i2) {
            int n3 = (i2 << 2) + dstPos;
            int n4 = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << n3;
            int n5 = 15 << n3;
            n2 = n2 & ~n5 | n4;
        }
        return n2;
    }

    public static short hexToShort(String src, int srcPos, short dstInit, int dstPos, int nHex) {
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 16");
        }
        short s2 = dstInit;
        for (int i2 = 0; i2 < nHex; ++i2) {
            int n2 = (i2 << 2) + dstPos;
            int n3 = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << n2;
            int n4 = 15 << n2;
            s2 = (short)(s2 & ~n4 | n3);
        }
        return s2;
    }

    public static byte hexToByte(String src, int srcPos, byte dstInit, int dstPos, int nHex) {
        if (nHex == 0) {
            return dstInit;
        }
        if ((nHex - 1 << 2) + dstPos >= 8) {
            throw new IllegalArgumentException("(nHexs-1)*4+dstPos is greater or equal to than 8");
        }
        byte by = dstInit;
        for (int i2 = 0; i2 < nHex; ++i2) {
            int n2 = (i2 << 2) + dstPos;
            int n3 = (0xF & Conversion.hexDigitToInt(src.charAt(i2 + srcPos))) << n2;
            int n4 = 15 << n2;
            by = (byte)(by & ~n4 | n3);
        }
        return by;
    }

    public static long binaryToLong(boolean[] src, int srcPos, long dstInit, int dstPos, int nBools) {
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 64) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 64");
        }
        long l2 = dstInit;
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + dstPos;
            long l3 = (src[i2 + srcPos] ? 1L : 0L) << n2;
            long l4 = 1L << n2;
            l2 = l2 & (l4 ^ 0xFFFFFFFFFFFFFFFFL) | l3;
        }
        return l2;
    }

    public static int binaryToInt(boolean[] src, int srcPos, int dstInit, int dstPos, int nBools) {
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 32) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 32");
        }
        int n2 = dstInit;
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n3 = i2 + dstPos;
            int n4 = (src[i2 + srcPos] ? 1 : 0) << n3;
            int n5 = 1 << n3;
            n2 = n2 & ~n5 | n4;
        }
        return n2;
    }

    public static short binaryToShort(boolean[] src, int srcPos, short dstInit, int dstPos, int nBools) {
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 16) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 16");
        }
        short s2 = dstInit;
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + dstPos;
            int n3 = (src[i2 + srcPos] ? 1 : 0) << n2;
            int n4 = 1 << n2;
            s2 = (short)(s2 & ~n4 | n3);
        }
        return s2;
    }

    public static byte binaryToByte(boolean[] src, int srcPos, byte dstInit, int dstPos, int nBools) {
        if (src.length == 0 && srcPos == 0 || nBools == 0) {
            return dstInit;
        }
        if (nBools - 1 + dstPos >= 8) {
            throw new IllegalArgumentException("nBools-1+dstPos is greater or equal to than 8");
        }
        byte by = dstInit;
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + dstPos;
            int n3 = (src[i2 + srcPos] ? 1 : 0) << n2;
            int n4 = 1 << n2;
            by = (byte)(by & ~n4 | n3);
        }
        return by;
    }

    public static int[] longToIntArray(long src, int srcPos, int[] dst, int dstPos, int nInts) {
        if (nInts == 0) {
            return dst;
        }
        if ((nInts - 1 << 5) + srcPos >= 64) {
            throw new IllegalArgumentException("(nInts-1)*32+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nInts; ++i2) {
            int n2 = (i2 << 5) + srcPos;
            dst[dstPos + i2] = (int)(0xFFFFFFFFFFFFFFFFL & src >> n2);
        }
        return dst;
    }

    public static short[] longToShortArray(long src, int srcPos, short[] dst, int dstPos, int nShorts) {
        if (nShorts == 0) {
            return dst;
        }
        if ((nShorts - 1 << 4) + srcPos >= 64) {
            throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int n2 = (i2 << 4) + srcPos;
            dst[dstPos + i2] = (short)(0xFFFFL & src >> n2);
        }
        return dst;
    }

    public static short[] intToShortArray(int src, int srcPos, short[] dst, int dstPos, int nShorts) {
        if (nShorts == 0) {
            return dst;
        }
        if ((nShorts - 1 << 4) + srcPos >= 32) {
            throw new IllegalArgumentException("(nShorts-1)*16+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nShorts; ++i2) {
            int n2 = (i2 << 4) + srcPos;
            dst[dstPos + i2] = (short)(0xFFFF & src >> n2);
        }
        return dst;
    }

    public static byte[] longToByteArray(long src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n2 = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFFL & src >> n2);
        }
        return dst;
    }

    public static byte[] intToByteArray(int src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 32) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n2 = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFF & src >> n2);
        }
        return dst;
    }

    public static byte[] shortToByteArray(short src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        if (nBytes == 0) {
            return dst;
        }
        if ((nBytes - 1 << 3) + srcPos >= 16) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 16");
        }
        for (int i2 = 0; i2 < nBytes; ++i2) {
            int n2 = (i2 << 3) + srcPos;
            dst[dstPos + i2] = (byte)(0xFF & src >> n2);
        }
        return dst;
    }

    public static String longToHex(long src, int srcPos, String dstInit, int dstPos, int nHexs) {
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 64) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 64");
        }
        StringBuilder stringBuilder = new StringBuilder(dstInit);
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int n3 = (i2 << 2) + srcPos;
            int n4 = (int)(0xFL & src >> n3);
            if (dstPos + i2 == n2) {
                ++n2;
                stringBuilder.append(Conversion.intToHexDigit(n4));
                continue;
            }
            stringBuilder.setCharAt(dstPos + i2, Conversion.intToHexDigit(n4));
        }
        return stringBuilder.toString();
    }

    public static String intToHex(int src, int srcPos, String dstInit, int dstPos, int nHexs) {
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 32) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 32");
        }
        StringBuilder stringBuilder = new StringBuilder(dstInit);
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int n3 = (i2 << 2) + srcPos;
            int n4 = 0xF & src >> n3;
            if (dstPos + i2 == n2) {
                ++n2;
                stringBuilder.append(Conversion.intToHexDigit(n4));
                continue;
            }
            stringBuilder.setCharAt(dstPos + i2, Conversion.intToHexDigit(n4));
        }
        return stringBuilder.toString();
    }

    public static String shortToHex(short src, int srcPos, String dstInit, int dstPos, int nHexs) {
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 16) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 16");
        }
        StringBuilder stringBuilder = new StringBuilder(dstInit);
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int n3 = (i2 << 2) + srcPos;
            int n4 = 0xF & src >> n3;
            if (dstPos + i2 == n2) {
                ++n2;
                stringBuilder.append(Conversion.intToHexDigit(n4));
                continue;
            }
            stringBuilder.setCharAt(dstPos + i2, Conversion.intToHexDigit(n4));
        }
        return stringBuilder.toString();
    }

    public static String byteToHex(byte src, int srcPos, String dstInit, int dstPos, int nHexs) {
        if (nHexs == 0) {
            return dstInit;
        }
        if ((nHexs - 1 << 2) + srcPos >= 8) {
            throw new IllegalArgumentException("(nHexs-1)*4+srcPos is greater or equal to than 8");
        }
        StringBuilder stringBuilder = new StringBuilder(dstInit);
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < nHexs; ++i2) {
            int n3 = (i2 << 2) + srcPos;
            int n4 = 0xF & src >> n3;
            if (dstPos + i2 == n2) {
                ++n2;
                stringBuilder.append(Conversion.intToHexDigit(n4));
                continue;
            }
            stringBuilder.setCharAt(dstPos + i2, Conversion.intToHexDigit(n4));
        }
        return stringBuilder.toString();
    }

    public static boolean[] longToBinary(long src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 64) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 64");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + srcPos;
            dst[dstPos + i2] = (1L & src >> n2) != 0L;
        }
        return dst;
    }

    public static boolean[] intToBinary(int src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 32) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 32");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> n2) != 0;
        }
        return dst;
    }

    public static boolean[] shortToBinary(short src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 16) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 16");
        }
        assert (nBools - 1 < 16 - srcPos);
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> n2) != 0;
        }
        return dst;
    }

    public static boolean[] byteToBinary(byte src, int srcPos, boolean[] dst, int dstPos, int nBools) {
        if (nBools == 0) {
            return dst;
        }
        if (nBools - 1 + srcPos >= 8) {
            throw new IllegalArgumentException("nBools-1+srcPos is greater or equal to than 8");
        }
        for (int i2 = 0; i2 < nBools; ++i2) {
            int n2 = i2 + srcPos;
            dst[dstPos + i2] = (1 & src >> n2) != 0;
        }
        return dst;
    }

    public static byte[] uuidToByteArray(UUID src, byte[] dst, int dstPos, int nBytes) {
        if (nBytes == 0) {
            return dst;
        }
        if (nBytes > 16) {
            throw new IllegalArgumentException("nBytes is greater than 16");
        }
        Conversion.longToByteArray(src.getMostSignificantBits(), 0, dst, dstPos, nBytes > 8 ? 8 : nBytes);
        if (nBytes >= 8) {
            Conversion.longToByteArray(src.getLeastSignificantBits(), 0, dst, dstPos + 8, nBytes - 8);
        }
        return dst;
    }

    public static UUID byteArrayToUuid(byte[] src, int srcPos) {
        if (src.length - srcPos < 16) {
            throw new IllegalArgumentException("Need at least 16 bytes for UUID");
        }
        return new UUID(Conversion.byteArrayToLong(src, srcPos, 0L, 0, 8), Conversion.byteArrayToLong(src, srcPos + 8, 0L, 0, 8));
    }
}

