/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements Serializable,
ExceptionContext {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label, Object value) {
        this.contextValues.add(new ImmutablePair<String, Object>(label, value));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String label, Object value) {
        Iterator<Pair<String, Object>> iterator = this.contextValues.iterator();
        while (iterator.hasNext()) {
            Pair<String, Object> pair = iterator.next();
            if (!StringUtils.equals(label, pair.getKey())) continue;
            iterator.remove();
        }
        this.addContextValue(label, value);
        return this;
    }

    @Override
    public List<Object> getContextValues(String label) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label, pair.getKey())) continue;
            arrayList.add(pair.getValue());
        }
        return arrayList;
    }

    @Override
    public Object getFirstContextValue(String label) {
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label, pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Pair<String, Object> pair : this.contextValues) {
            hashSet.add(pair.getKey());
        }
        return hashSet;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (baseMessage != null) {
            stringBuilder.append(baseMessage);
        }
        if (this.contextValues.size() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append(pair.getKey());
                stringBuilder.append("=");
                Object object = pair.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    String string;
                    try {
                        string = object.toString();
                    }
                    catch (Exception exception) {
                        string = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(exception);
                    }
                    stringBuilder.append(string);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }
}

