/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerDistance
implements SimilarityScore<Double> {
    public static final int INDEX_NOT_FOUND = -1;

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        double d2;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] nArray = JaroWinklerDistance.matches(left, right);
        double d3 = nArray[0];
        if (d3 == 0.0) {
            return 0.0;
        }
        double d4 = (d3 / (double)left.length() + d3 / (double)right.length() + (d3 - (double)nArray[1]) / d3) / 3.0;
        double d5 = d2 < 0.7 ? d4 : d4 + Math.min(0.1, 1.0 / (double)nArray[3]) * (double)nArray[2] * (1.0 - d4);
        return d5;
    }

    protected static int[] matches(CharSequence first, CharSequence second) {
        int n2;
        int n3;
        CharSequence charSequence;
        CharSequence charSequence2;
        if (first.length() > second.length()) {
            charSequence2 = first;
            charSequence = second;
        } else {
            charSequence2 = second;
            charSequence = first;
        }
        int n4 = Math.max(charSequence2.length() / 2 - 1, 0);
        int[] nArray = new int[charSequence.length()];
        Arrays.fill(nArray, -1);
        boolean[] blArray = new boolean[charSequence2.length()];
        int n5 = 0;
        block0: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            n3 = Math.min(i2 + n4 + 1, charSequence2.length());
            for (n2 = Math.max(i2 - n4, 0); n2 < n3; ++n2) {
                if (blArray[n2] || c2 != charSequence2.charAt(n2)) continue;
                nArray[i2] = n2;
                blArray[n2] = true;
                ++n5;
                continue block0;
            }
        }
        char[] cArray = new char[n5];
        char[] cArray2 = new char[n5];
        n3 = 0;
        for (n2 = 0; n2 < charSequence.length(); ++n2) {
            if (nArray[n2] == -1) continue;
            cArray[n3] = charSequence.charAt(n2);
            ++n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < charSequence2.length(); ++n2) {
            if (!blArray[n2]) continue;
            cArray2[n3] = charSequence2.charAt(n2);
            ++n3;
        }
        n2 = 0;
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (cArray[n3] == cArray2[n3]) continue;
            ++n2;
        }
        n3 = 0;
        for (int i3 = 0; i3 < charSequence.length() && first.charAt(i3) == second.charAt(i3); ++i3) {
            ++n3;
        }
        return new int[]{n5, n2 / 2, n3, charSequence2.length()};
    }
}

