/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractPartial;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class BasePartial
extends AbstractPartial
implements Serializable,
ReadablePartial {
    private static final long serialVersionUID = 2353678632973660L;
    private final Chronology iChronology;
    private final int[] iValues;

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected BasePartial(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    protected BasePartial(long l2) {
        this(l2, (Chronology)null);
    }

    protected BasePartial(long l2, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = chronology.get(this, l2);
    }

    protected BasePartial(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology);
    }

    protected BasePartial(Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        chronology = partialConverter.getChronology(object, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology, dateTimeFormatter);
    }

    protected BasePartial(int[] nArray, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        chronology.validate(this, nArray);
        this.iValues = nArray;
    }

    protected BasePartial(BasePartial basePartial, int[] nArray) {
        this.iChronology = basePartial.iChronology;
        this.iValues = nArray;
    }

    protected BasePartial(BasePartial basePartial, Chronology chronology) {
        this.iChronology = chronology.withUTC();
        this.iValues = basePartial.iValues;
    }

    public int getValue(int n2) {
        return this.iValues[n2];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setValue(int n2, int n3) {
        DateTimeField dateTimeField = this.getField(n2);
        int[] nArray = dateTimeField.set(this, n2, this.iValues, n3);
        System.arraycopy(nArray, 0, this.iValues, 0, this.iValues.length);
    }

    protected void setValues(int[] nArray) {
        this.getChronology().validate(this, nArray);
        System.arraycopy(nArray, 0, this.iValues, 0, this.iValues.length);
    }

    public String toString(String string) {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).print(this);
    }

    public String toString(String string, Locale locale) throws IllegalArgumentException {
        if (string == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string).withLocale(locale).print(this);
    }
}

