/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodFormatterBuilder {
    private static final int PRINT_ZERO_RARELY_FIRST = 1;
    private static final int PRINT_ZERO_RARELY_LAST = 2;
    private static final int PRINT_ZERO_IF_SUPPORTED = 3;
    private static final int PRINT_ZERO_ALWAYS = 4;
    private static final int PRINT_ZERO_NEVER = 5;
    private static final int YEARS = 0;
    private static final int MONTHS = 1;
    private static final int WEEKS = 2;
    private static final int DAYS = 3;
    private static final int HOURS = 4;
    private static final int MINUTES = 5;
    private static final int SECONDS = 6;
    private static final int MILLIS = 7;
    private static final int SECONDS_MILLIS = 8;
    private static final int SECONDS_OPTIONAL_MILLIS = 9;
    private static final int MAX_FIELD = 9;
    private static final ConcurrentMap<String, Pattern> PATTERNS = new ConcurrentHashMap<String, Pattern>();
    private int iMinPrintedDigits;
    private int iPrintZeroSetting;
    private int iMaxParsedDigits;
    private boolean iRejectSignedValues;
    private PeriodFieldAffix iPrefix;
    private List<Object> iElementPairs;
    private boolean iNotPrinter;
    private boolean iNotParser;
    private FieldFormatter[] iFieldFormatters;

    public PeriodFormatterBuilder() {
        this.clear();
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        FieldFormatter[] fieldFormatterArray = this.iFieldFormatters;
        int n2 = this.iFieldFormatters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            FieldFormatter fieldFormatter = fieldFormatterArray[i2];
            if (fieldFormatter == null) continue;
            fieldFormatter.finish(this.iFieldFormatters);
        }
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return periodFormatter;
    }

    public PeriodPrinter toPrinter() {
        if (this.iNotPrinter) {
            return null;
        }
        return this.toFormatter().getPrinter();
    }

    public PeriodParser toParser() {
        if (this.iNotParser) {
            return null;
        }
        return this.toFormatter().getParser();
    }

    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iElementPairs == null) {
            this.iElementPairs = new ArrayList<Object>();
        } else {
            this.iElementPairs.clear();
        }
        this.iNotPrinter = false;
        this.iNotParser = false;
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder append(PeriodFormatter periodFormatter) {
        if (periodFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        this.clearPrefix();
        this.append0(periodFormatter.getPrinter(), periodFormatter.getParser());
        return this;
    }

    public PeriodFormatterBuilder append(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        if (periodPrinter == null && periodParser == null) {
            throw new IllegalArgumentException("No printer or parser supplied");
        }
        this.clearPrefix();
        this.append0(periodPrinter, periodParser);
        return this;
    }

    public PeriodFormatterBuilder appendLiteral(String string) {
        Literal literal;
        if (string == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal2 = literal = new Literal(string);
        this.append0(literal2, literal2);
        return this;
    }

    public PeriodFormatterBuilder minimumPrintedDigits(int n2) {
        this.iMinPrintedDigits = n2;
        return this;
    }

    public PeriodFormatterBuilder maximumParsedDigits(int n2) {
        this.iMaxParsedDigits = n2;
        return this;
    }

    public PeriodFormatterBuilder rejectSignedValues(boolean bl) {
        this.iRejectSignedValues = bl;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyLast() {
        this.iPrintZeroSetting = 2;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyFirst() {
        this.iPrintZeroSetting = 1;
        return this;
    }

    public PeriodFormatterBuilder printZeroIfSupported() {
        this.iPrintZeroSetting = 3;
        return this;
    }

    public PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    public PeriodFormatterBuilder printZeroNever() {
        this.iPrintZeroSetting = 5;
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new SimpleAffix(string));
    }

    public PeriodFormatterBuilder appendPrefix(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new PluralAffix(string, string2));
    }

    public PeriodFormatterBuilder appendPrefix(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length <= 0 || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new RegExAffix(stringArray, stringArray2));
    }

    private PeriodFormatterBuilder appendPrefix(PeriodFieldAffix periodFieldAffix) {
        if (periodFieldAffix == null) {
            throw new IllegalArgumentException();
        }
        if (this.iPrefix != null) {
            periodFieldAffix = new CompositeAffix(this.iPrefix, periodFieldAffix);
        }
        this.iPrefix = periodFieldAffix;
        return this;
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithMillis() {
        this.appendField(8);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    public PeriodFormatterBuilder appendMillis() {
        this.appendField(7);
        return this;
    }

    public PeriodFormatterBuilder appendMillis3Digit() {
        this.appendField(7, 3);
        return this;
    }

    private void appendField(int n2) {
        this.appendField(n2, this.iMinPrintedDigits);
    }

    private void appendField(int n2, int n3) {
        FieldFormatter fieldFormatter;
        FieldFormatter fieldFormatter2 = fieldFormatter = new FieldFormatter(n3, this.iPrintZeroSetting, this.iMaxParsedDigits, this.iRejectSignedValues, n2, this.iFieldFormatters, this.iPrefix, null);
        this.append0(fieldFormatter2, fieldFormatter2);
        this.iFieldFormatters[n2] = fieldFormatter;
        this.iPrefix = null;
    }

    public PeriodFormatterBuilder appendSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(string));
    }

    public PeriodFormatterBuilder appendSuffix(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(string, string2));
    }

    public PeriodFormatterBuilder appendSuffix(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length <= 0 || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new RegExAffix(stringArray, stringArray2));
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix periodFieldAffix) {
        Object object;
        Object object2;
        if (this.iElementPairs.size() > 0) {
            object2 = this.iElementPairs.get(this.iElementPairs.size() - 2);
            object = this.iElementPairs.get(this.iElementPairs.size() - 1);
        } else {
            object2 = null;
            object = null;
        }
        if (object2 == null || object == null || object2 != object || !(object2 instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        this.clearPrefix();
        FieldFormatter fieldFormatter = new FieldFormatter((FieldFormatter)object2, periodFieldAffix);
        this.iElementPairs.set(this.iElementPairs.size() - 2, fieldFormatter);
        this.iElementPairs.set(this.iElementPairs.size() - 1, fieldFormatter);
        this.iFieldFormatters[fieldFormatter.getFieldType()] = fieldFormatter;
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String string) {
        String string2 = string;
        return this.appendSeparator(string2, string2, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String string) {
        String string2 = string;
        return this.appendSeparator(string2, string2, null, false, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsBefore(String string) {
        String string2 = string;
        return this.appendSeparator(string2, string2, null, true, false);
    }

    public PeriodFormatterBuilder appendSeparator(String string, String string2) {
        return this.appendSeparator(string, string2, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparator(String string, String string2, String[] stringArray) {
        return this.appendSeparator(string, string2, stringArray, true, true);
    }

    private PeriodFormatterBuilder appendSeparator(String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        this.clearPrefix();
        List<Object> list = this.iElementPairs;
        if (list.size() == 0) {
            if (bl2 && !bl) {
                Separator separator;
                Literal literal = Literal.EMPTY;
                Separator separator2 = separator = new Separator(string, string2, stringArray, literal, literal, bl, bl2);
                this.append0(separator2, separator2);
            }
            return this;
        }
        Separator separator = null;
        int n2 = list.size();
        while (--n2 >= 0) {
            if (list.get(n2) instanceof Separator) {
                separator = (Separator)list.get(n2);
                list = list.subList(n2 + 1, list.size());
                break;
            }
            --n2;
        }
        if (separator != null && list.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] objectArray = PeriodFormatterBuilder.createComposite(list);
        list.clear();
        Separator separator3 = new Separator(string, string2, stringArray, (PeriodPrinter)objectArray[0], (PeriodParser)objectArray[1], bl, bl2);
        list.add(separator3);
        list.add(separator3);
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private PeriodFormatterBuilder append0(PeriodPrinter periodPrinter, PeriodParser periodParser) {
        this.iElementPairs.add(periodPrinter);
        this.iElementPairs.add(periodParser);
        this.iNotPrinter |= periodPrinter == null;
        this.iNotParser |= periodParser == null;
        return this;
    }

    private static PeriodFormatter toFormatter(List<Object> list, boolean bl, boolean bl2) {
        Object object;
        if (bl && bl2) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int n2 = list.size();
        if (n2 >= 2 && list.get(0) instanceof Separator && ((Separator)(object = (Separator)list.get(0))).iAfterParser == null && ((Separator)object).iAfterPrinter == null) {
            PeriodFormatter periodFormatter = PeriodFormatterBuilder.toFormatter(list.subList(2, n2), bl, bl2);
            Object object2 = object = ((Separator)object).finish(periodFormatter.getPrinter(), periodFormatter.getParser());
            return new PeriodFormatter((PeriodPrinter)object2, (PeriodParser)object2);
        }
        object = PeriodFormatterBuilder.createComposite(list);
        if (bl) {
            return new PeriodFormatter(null, (PeriodParser)object[1]);
        }
        if (bl2) {
            return new PeriodFormatter((PeriodPrinter)object[0], null);
        }
        return new PeriodFormatter((PeriodPrinter)object[0], (PeriodParser)object[1]);
    }

    private static Object[] createComposite(List<Object> list) {
        switch (list.size()) {
            case 0: {
                return new Object[]{Literal.EMPTY, Literal.EMPTY};
            }
            case 1: {
                return new Object[]{list.get(0), list.get(1)};
            }
        }
        Composite composite = new Composite(list);
        return new Object[]{composite, composite};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Composite
    implements PeriodParser,
    PeriodPrinter {
        private final PeriodPrinter[] iPrinters;
        private final PeriodParser[] iParsers;

        Composite(List<Object> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.size() <= 0) {
                this.iPrinters = null;
            } else {
                ArrayList<Object> arrayList3 = arrayList;
                this.iPrinters = arrayList3.toArray(new PeriodPrinter[arrayList3.size()]);
            }
            if (arrayList2.size() <= 0) {
                this.iParsers = null;
                return;
            }
            ArrayList<Object> arrayList4 = arrayList2;
            this.iParsers = arrayList4.toArray(new PeriodParser[arrayList4.size()]);
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            int n3;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n4 = this.iPrinters.length;
            for (n3 = 0; n3 < n2 && --n4 >= 0; n3 += periodPrinterArray[n4].countFieldsToPrint(readablePeriod, Integer.MAX_VALUE, locale)) {
            }
            return n3;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            int n2 = 0;
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n3 = this.iPrinters.length;
            while (--n3 >= 0) {
                n2 += periodPrinterArray[n3].calculatePrintedLength(readablePeriod, locale);
            }
            return n2;
        }

        @Override
        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = this.iPrinters.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                periodPrinterArray[i2].printTo(stringBuffer, readablePeriod, locale);
            }
        }

        @Override
        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            PeriodPrinter[] periodPrinterArray = this.iPrinters;
            int n2 = this.iPrinters.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                periodPrinterArray[i2].printTo(writer, readablePeriod, locale);
            }
        }

        @Override
        public int parseInto(ReadWritablePeriod readWritablePeriod, String string, int n2, Locale locale) {
            PeriodParser[] periodParserArray = this.iParsers;
            if (this.iParsers == null) {
                throw new UnsupportedOperationException();
            }
            int n3 = periodParserArray.length;
            for (int i2 = 0; i2 < n3 && n2 >= 0; ++i2) {
                n2 = periodParserArray[i2].parseInto(readWritablePeriod, string, n2, locale);
            }
            return n2;
        }

        private void decompose(List<Object> list, List<Object> list2, List<Object> list3) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                Object object = list.get(i2);
                if (object instanceof PeriodPrinter) {
                    if (object instanceof Composite) {
                        this.addArrayToList(list2, ((Composite)object).iPrinters);
                    } else {
                        list2.add(object);
                    }
                }
                if (!((object = list.get(i2 + 1)) instanceof PeriodParser)) continue;
                if (object instanceof Composite) {
                    this.addArrayToList(list3, ((Composite)object).iParsers);
                    continue;
                }
                list3.add(object);
            }
        }

        private void addArrayToList(List<Object> list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    list.add(objectArray[i2]);
                }
            }
        }
    }

    static class Separator
    implements PeriodParser,
    PeriodPrinter {
        private final String iText;
        private final String iFinalText;
        private final String[] iParsedForms;
        private final boolean iUseBefore;
        private final boolean iUseAfter;
        private final PeriodPrinter iBeforePrinter;
        private volatile PeriodPrinter iAfterPrinter;
        private final PeriodParser iBeforeParser;
        private volatile PeriodParser iAfterParser;

        Separator(String string, String string2, String[] stringArray, PeriodPrinter periodPrinter, PeriodParser periodParser, boolean bl, boolean bl2) {
            this.iText = string;
            this.iFinalText = string2;
            if (!(string2 != null && !string.equals(string2) || stringArray != null && stringArray.length != 0)) {
                this.iParsedForms = new String[]{string};
            } else {
                TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                treeSet.add(string);
                treeSet.add(string2);
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    while (--n2 >= 0) {
                        treeSet.add(stringArray[n2]);
                    }
                }
                ArrayList arrayList = new ArrayList(treeSet);
                Collections.reverse(arrayList);
                ArrayList arrayList2 = arrayList;
                this.iParsedForms = arrayList2.toArray(new String[arrayList2.size()]);
            }
            this.iBeforePrinter = periodPrinter;
            this.iBeforeParser = periodParser;
            this.iUseBefore = bl;
            this.iUseAfter = bl2;
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            int n3 = this.iBeforePrinter.countFieldsToPrint(readablePeriod, n2, locale);
            if (n3 < n2) {
                n3 += this.iAfterPrinter.countFieldsToPrint(readablePeriod, n2, locale);
            }
            return n3;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            int n2 = periodPrinter.calculatePrintedLength(readablePeriod, locale) + periodPrinter2.calculatePrintedLength(readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n3 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n3 > 0) {
                            n2 += (n3 > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        n2 += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                n2 += this.iText.length();
            }
            return n2;
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(stringBuffer, readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n2 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n2 > 0) {
                            stringBuffer.append(n2 > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        stringBuffer.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                stringBuffer.append(this.iText);
            }
            periodPrinter2.printTo(stringBuffer, readablePeriod, locale);
        }

        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            PeriodPrinter periodPrinter = this.iBeforePrinter;
            PeriodPrinter periodPrinter2 = this.iAfterPrinter;
            periodPrinter.printTo(writer, readablePeriod, locale);
            if (this.iUseBefore) {
                if (periodPrinter.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int n2 = periodPrinter2.countFieldsToPrint(readablePeriod, 2, locale);
                        if (n2 > 0) {
                            writer.write(n2 > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        writer.write(this.iText);
                    }
                }
            } else if (this.iUseAfter && periodPrinter2.countFieldsToPrint(readablePeriod, 1, locale) > 0) {
                writer.write(this.iText);
            }
            periodPrinter2.printTo(writer, readablePeriod, locale);
        }

        public int parseInto(ReadWritablePeriod readWritablePeriod, String string, int n2, Locale locale) {
            int n3 = n2;
            if ((n2 = this.iBeforeParser.parseInto(readWritablePeriod, string, n2, locale)) < 0) {
                return n2;
            }
            boolean bl = false;
            int n4 = -1;
            if (n2 > n3) {
                String[] stringArray = this.iParsedForms;
                int n5 = this.iParsedForms.length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    String string2 = stringArray[i2];
                    if (string2 != null && string2.length() != 0 && !string.regionMatches(true, n2, string2, 0, string2.length())) continue;
                    n4 = string2 == null ? 0 : string2.length();
                    n2 += n4;
                    bl = true;
                    break;
                }
            }
            n3 = n2;
            if ((n2 = this.iAfterParser.parseInto(readWritablePeriod, string, n2, locale)) < 0) {
                return n2;
            }
            if (bl && n2 == n3 && n4 > 0) {
                return ~n3;
            }
            if (n2 > n3 && !bl && !this.iUseBefore) {
                return ~n3;
            }
            return n2;
        }

        Separator finish(PeriodPrinter periodPrinter, PeriodParser periodParser) {
            this.iAfterPrinter = periodPrinter;
            this.iAfterParser = periodParser;
            return this;
        }
    }

    static class Literal
    implements PeriodParser,
    PeriodPrinter {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String string) {
            this.iText = string;
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            return 0;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            return this.iText.length();
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            stringBuffer.append(this.iText);
        }

        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            writer.write(this.iText);
        }

        public int parseInto(ReadWritablePeriod readWritablePeriod, String string, int n2, Locale locale) {
            if (string.regionMatches(true, n2, this.iText, 0, this.iText.length())) {
                return n2 + this.iText.length();
            }
            return ~n2;
        }
    }

    static class FieldFormatter
    implements PeriodParser,
    PeriodPrinter {
        private final int iMinPrintedDigits;
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final boolean iRejectSignedValues;
        private final int iFieldType;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int n2, int n3, int n4, boolean bl, int n5, FieldFormatter[] fieldFormatterArray, PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iMinPrintedDigits = n2;
            this.iPrintZeroSetting = n3;
            this.iMaxParsedDigits = n4;
            this.iRejectSignedValues = bl;
            this.iFieldType = n5;
            this.iFieldFormatters = fieldFormatterArray;
            this.iPrefix = periodFieldAffix;
            this.iSuffix = periodFieldAffix2;
        }

        FieldFormatter(FieldFormatter fieldFormatter, PeriodFieldAffix periodFieldAffix) {
            this.iMinPrintedDigits = fieldFormatter.iMinPrintedDigits;
            this.iPrintZeroSetting = fieldFormatter.iPrintZeroSetting;
            this.iMaxParsedDigits = fieldFormatter.iMaxParsedDigits;
            this.iRejectSignedValues = fieldFormatter.iRejectSignedValues;
            this.iFieldType = fieldFormatter.iFieldType;
            this.iFieldFormatters = fieldFormatter.iFieldFormatters;
            this.iPrefix = fieldFormatter.iPrefix;
            if (fieldFormatter.iSuffix != null) {
                periodFieldAffix = new CompositeAffix(fieldFormatter.iSuffix, periodFieldAffix);
            }
            this.iSuffix = periodFieldAffix;
        }

        public void finish(FieldFormatter[] fieldFormatterArray) {
            HashSet<PeriodFieldAffix> hashSet = new HashSet<PeriodFieldAffix>();
            HashSet<PeriodFieldAffix> hashSet2 = new HashSet<PeriodFieldAffix>();
            FieldFormatter[] fieldFormatterArray2 = fieldFormatterArray;
            int n2 = fieldFormatterArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FieldFormatter fieldFormatter = fieldFormatterArray2[i2];
                if (fieldFormatter == null || this.equals(fieldFormatter)) continue;
                hashSet.add(fieldFormatter.iPrefix);
                hashSet2.add(fieldFormatter.iSuffix);
            }
            if (this.iPrefix != null) {
                this.iPrefix.finish(hashSet);
            }
            if (this.iSuffix != null) {
                this.iSuffix.finish(hashSet2);
            }
        }

        public int countFieldsToPrint(ReadablePeriod readablePeriod, int n2, Locale locale) {
            if (n2 <= 0) {
                return 0;
            }
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(readablePeriod) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        public int calculatePrintedLength(ReadablePeriod readablePeriod, Locale locale) {
            long l2 = this.getFieldValue(readablePeriod);
            if (l2 == Long.MAX_VALUE) {
                return 0;
            }
            int n2 = Math.max(FormatUtils.calculateDigitCount(l2), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                n2 = l2 < 0L ? Math.max(n2, 5) : Math.max(n2, 4);
                ++n2;
                if (this.iFieldType == 9 && Math.abs(l2) % 1000L == 0L) {
                    n2 -= 4;
                }
                l2 /= 1000L;
            }
            int n3 = (int)l2;
            if (this.iPrefix != null) {
                n2 += this.iPrefix.calculatePrintedLength(n3);
            }
            if (this.iSuffix != null) {
                n2 += this.iSuffix.calculatePrintedLength(n3);
            }
            return n2;
        }

        public void printTo(StringBuffer stringBuffer, ReadablePeriod readablePeriod, Locale locale) {
            long l2 = this.getFieldValue(readablePeriod);
            if (l2 == Long.MAX_VALUE) {
                return;
            }
            int n2 = (int)l2;
            if (this.iFieldType >= 8) {
                n2 = (int)(l2 / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(stringBuffer, n2);
            }
            int n3 = stringBuffer.length();
            int n4 = this.iMinPrintedDigits;
            if (n4 <= 1) {
                FormatUtils.appendUnpaddedInteger(stringBuffer, n2);
            } else {
                FormatUtils.appendPaddedInteger(stringBuffer, n2, n4);
            }
            if (this.iFieldType >= 8) {
                int n5 = (int)(Math.abs(l2) % 1000L);
                if (this.iFieldType == 8 || n5 > 0) {
                    if (l2 < 0L && l2 > -1000L) {
                        stringBuffer.insert(n3, '-');
                    }
                    stringBuffer.append('.');
                    FormatUtils.appendPaddedInteger(stringBuffer, n5, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(stringBuffer, n2);
            }
        }

        public void printTo(Writer writer, ReadablePeriod readablePeriod, Locale locale) throws IOException {
            int n2;
            long l2 = this.getFieldValue(readablePeriod);
            if (l2 == Long.MAX_VALUE) {
                return;
            }
            int n3 = (int)l2;
            if (this.iFieldType >= 8) {
                n3 = (int)(l2 / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(writer, n3);
            }
            if ((n2 = this.iMinPrintedDigits) <= 1) {
                FormatUtils.writeUnpaddedInteger(writer, n3);
            } else {
                FormatUtils.writePaddedInteger(writer, n3, n2);
            }
            if (this.iFieldType >= 8) {
                int n4 = (int)(Math.abs(l2) % 1000L);
                if (this.iFieldType == 8 || n4 > 0) {
                    writer.write(46);
                    FormatUtils.writePaddedInteger(writer, n4, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(writer, n3);
            }
        }

        public int parseInto(ReadWritablePeriod readWritablePeriod, String string, int n2, Locale locale) {
            int n3;
            boolean bl;
            boolean bl2 = bl = this.iPrintZeroSetting == 4;
            if (n2 >= string.length()) {
                if (bl) {
                    return ~n2;
                }
                return n2;
            }
            if (this.iPrefix != null) {
                if ((n2 = this.iPrefix.parse(string, n2)) >= 0) {
                    bl = true;
                } else {
                    if (!bl) {
                        return ~n2;
                    }
                    return n2;
                }
            }
            int n4 = -1;
            if (this.iSuffix != null && !bl) {
                n4 = this.iSuffix.scan(string, n2);
                if (n4 >= 0) {
                    bl = true;
                } else {
                    return ~n4;
                }
            }
            if (!bl && !this.isSupported(readWritablePeriod.getPeriodType(), this.iFieldType)) {
                return n2;
            }
            int n5 = n4 > 0 ? Math.min(this.iMaxParsedDigits, n4 - n2) : Math.min(this.iMaxParsedDigits, string.length() - n2);
            int n6 = 0;
            int n7 = -1;
            boolean bl3 = false;
            boolean bl4 = false;
            while (n6 < n5) {
                n3 = string.charAt(n2 + n6);
                if (!(n6 != 0 || n3 != 45 && n3 != 43 || this.iRejectSignedValues)) {
                    boolean bl5 = bl4 = n3 == 45;
                    if (n6 + 1 >= n5) break;
                    char c2 = string.charAt(n2 + n6 + 1);
                    n3 = c2;
                    if (c2 < '0' || n3 > 57) break;
                    if (bl4) {
                        ++n6;
                    } else {
                        ++n2;
                    }
                    n5 = Math.min(n5 + 1, string.length() - n2);
                    continue;
                }
                if (n3 >= 48 && n3 <= 57) {
                    bl3 = true;
                } else {
                    if (n3 != 46 && n3 != 44 || this.iFieldType != 8 && this.iFieldType != 9 || n7 >= 0) break;
                    n7 = n2 + n6 + 1;
                    n5 = Math.min(n5 + 1, string.length() - n2);
                }
                ++n6;
            }
            if (!bl3) {
                return ~n2;
            }
            if (n4 >= 0 && n2 + n6 != n4) {
                return n2;
            }
            if (this.iFieldType != 8 && this.iFieldType != 9) {
                this.setFieldValue(readWritablePeriod, this.iFieldType, this.parseInt(string, n2, n6));
            } else if (n7 < 0) {
                this.setFieldValue(readWritablePeriod, 6, this.parseInt(string, n2, n6));
                this.setFieldValue(readWritablePeriod, 7, 0);
            } else {
                int n8;
                n3 = this.parseInt(string, n2, n7 - n2 - 1);
                this.setFieldValue(readWritablePeriod, 6, n3);
                int n9 = n2 + n6 - n7;
                if (n9 <= 0) {
                    n8 = 0;
                } else {
                    if (n9 >= 3) {
                        n8 = this.parseInt(string, n7, 3);
                    } else {
                        n8 = this.parseInt(string, n7, n9);
                        n8 = n9 == 1 ? (n8 *= 100) : (n8 *= 10);
                    }
                    if (bl4 || n3 < 0) {
                        n8 = -n8;
                    }
                }
                this.setFieldValue(readWritablePeriod, 7, n8);
            }
            if ((n2 += n6) >= 0 && this.iSuffix != null) {
                n2 = this.iSuffix.parse(string, n2);
            }
            return n2;
        }

        private int parseInt(String string, int n2, int n3) {
            boolean bl;
            if (n3 >= 10) {
                int n4 = n2;
                return Integer.parseInt(string.substring(n4, n4 + n3));
            }
            if (n3 <= 0) {
                return 0;
            }
            int n5 = string.charAt(n2++);
            --n3;
            if (n5 == 45) {
                if (--n3 < 0) {
                    return 0;
                }
                bl = true;
                n5 = string.charAt(n2++);
            } else {
                bl = false;
            }
            n5 -= 48;
            while (n3-- > 0) {
                n5 = (n5 << 3) + (n5 << 1) + string.charAt(n2++) - 48;
            }
            if (bl) {
                return -n5;
            }
            return n5;
        }

        long getFieldValue(ReadablePeriod readablePeriod) {
            int n2;
            long l2;
            PeriodType periodType = this.iPrintZeroSetting == 4 ? null : readablePeriod.getPeriodType();
            if (periodType != null && !this.isSupported(periodType, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    l2 = readablePeriod.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    l2 = readablePeriod.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    l2 = readablePeriod.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    l2 = readablePeriod.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    l2 = readablePeriod.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    l2 = readablePeriod.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    l2 = readablePeriod.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    l2 = readablePeriod.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    n2 = readablePeriod.get(DurationFieldType.seconds());
                    int n3 = readablePeriod.get(DurationFieldType.millis());
                    l2 = (long)n2 * 1000L + (long)n3;
                }
            }
            if (l2 == 0L) {
                switch (this.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        if (this.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            for (n2 = this.iFieldType + 1; n2 <= 9; ++n2) {
                                if (!this.isSupported(periodType, n2) || this.iFieldFormatters[n2] == null) continue;
                                return Long.MAX_VALUE;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        if (this.isZero(readablePeriod) && this.iFieldFormatters[this.iFieldType] == this) {
                            n2 = Math.min(this.iFieldType, 8);
                            --n2;
                            while (n2 >= 0 && n2 <= 9) {
                                if (this.isSupported(periodType, n2) && this.iFieldFormatters[n2] != null) {
                                    return Long.MAX_VALUE;
                                }
                                --n2;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return l2;
        }

        boolean isZero(ReadablePeriod readablePeriod) {
            int n2 = readablePeriod.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (readablePeriod.getValue(i2) == 0) continue;
                return false;
            }
            return true;
        }

        boolean isSupported(PeriodType periodType, int n2) {
            switch (n2) {
                default: {
                    return false;
                }
                case 0: {
                    return periodType.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return periodType.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return periodType.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return periodType.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return periodType.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return periodType.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return periodType.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return periodType.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return periodType.isSupported(DurationFieldType.seconds()) || periodType.isSupported(DurationFieldType.millis());
        }

        void setFieldValue(ReadWritablePeriod readWritablePeriod, int n2, int n3) {
            switch (n2) {
                default: {
                    return;
                }
                case 0: {
                    readWritablePeriod.setYears(n3);
                    return;
                }
                case 1: {
                    readWritablePeriod.setMonths(n3);
                    return;
                }
                case 2: {
                    readWritablePeriod.setWeeks(n3);
                    return;
                }
                case 3: {
                    readWritablePeriod.setDays(n3);
                    return;
                }
                case 4: {
                    readWritablePeriod.setHours(n3);
                    return;
                }
                case 5: {
                    readWritablePeriod.setMinutes(n3);
                    return;
                }
                case 6: {
                    readWritablePeriod.setSeconds(n3);
                    return;
                }
                case 7: 
            }
            readWritablePeriod.setMillis(n3);
        }

        int getFieldType() {
            return this.iFieldType;
        }
    }

    static class CompositeAffix
    extends IgnorableAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;
        private final String[] iLeftRightCombinations;

        CompositeAffix(PeriodFieldAffix periodFieldAffix, PeriodFieldAffix periodFieldAffix2) {
            this.iLeft = periodFieldAffix;
            this.iRight = periodFieldAffix2;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : this.iLeft.getAffixes()) {
                for (String string2 : this.iRight.getAffixes()) {
                    hashSet.add(string + string2);
                }
            }
            HashSet<String> hashSet2 = hashSet;
            this.iLeftRightCombinations = hashSet2.toArray(new String[hashSet2.size()]);
        }

        public int calculatePrintedLength(int n2) {
            return this.iLeft.calculatePrintedLength(n2) + this.iRight.calculatePrintedLength(n2);
        }

        public void printTo(StringBuffer stringBuffer, int n2) {
            this.iLeft.printTo(stringBuffer, n2);
            this.iRight.printTo(stringBuffer, n2);
        }

        public void printTo(Writer writer, int n2) throws IOException {
            this.iLeft.printTo(writer, n2);
            this.iRight.printTo(writer, n2);
        }

        public int parse(String string, int n2) {
            int n3 = this.iLeft.parse(string, n2);
            if (n3 >= 0 && (n3 = this.iRight.parse(string, n3)) >= 0) {
                CompositeAffix compositeAffix = this;
                if (compositeAffix.matchesOtherAffix(compositeAffix.parse(string, n3) - n3, string, n2)) {
                    return ~n2;
                }
            }
            return n3;
        }

        public int scan(String string, int n2) {
            block4: {
                int n3;
                int n4;
                block5: {
                    n4 = this.iLeft.scan(string, n2);
                    if (n4 < 0) break block4;
                    n3 = this.iRight.scan(string, this.iLeft.parse(string, n4));
                    if (n3 < 0) break block5;
                    CompositeAffix compositeAffix = this;
                    if (compositeAffix.matchesOtherAffix(compositeAffix.iRight.parse(string, n3) - n4, string, n2)) break block4;
                }
                if (n4 > 0) {
                    return n4;
                }
                return n3;
            }
            return ~n2;
        }

        public String[] getAffixes() {
            return (String[])this.iLeftRightCombinations.clone();
        }
    }

    static class RegExAffix
    extends IgnorableAffix {
        private static final Comparator<String> LENGTH_DESC_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string2.length() - string.length();
            }
        };
        private final String[] iSuffixes;
        private final Pattern[] iPatterns;
        private final String[] iSuffixesSortedDescByLength;

        RegExAffix(String[] stringArray, String[] stringArray2) {
            this.iSuffixes = (String[])stringArray2.clone();
            this.iPatterns = new Pattern[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                Pattern pattern = (Pattern)PATTERNS.get(stringArray[i2]);
                if (pattern == null) {
                    pattern = Pattern.compile(stringArray[i2]);
                    PATTERNS.putIfAbsent(stringArray[i2], pattern);
                }
                this.iPatterns[i2] = pattern;
            }
            this.iSuffixesSortedDescByLength = (String[])this.iSuffixes.clone();
            Arrays.sort(this.iSuffixesSortedDescByLength, LENGTH_DESC_COMPARATOR);
        }

        private int selectSuffixIndex(int n2) {
            String string = String.valueOf(n2);
            for (int i2 = 0; i2 < this.iPatterns.length; ++i2) {
                if (!this.iPatterns[i2].matcher(string).matches()) continue;
                return i2;
            }
            return this.iPatterns.length - 1;
        }

        public int calculatePrintedLength(int n2) {
            return this.iSuffixes[this.selectSuffixIndex(n2)].length();
        }

        public void printTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append(this.iSuffixes[this.selectSuffixIndex(n2)]);
        }

        public void printTo(Writer writer, int n2) throws IOException {
            writer.write(this.iSuffixes[this.selectSuffixIndex(n2)]);
        }

        public int parse(String string, int n2) {
            String[] stringArray = this.iSuffixesSortedDescByLength;
            int n3 = this.iSuffixesSortedDescByLength.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string2 = stringArray[i2];
                if (!string.regionMatches(true, n2, string2, 0, string2.length()) || this.matchesOtherAffix(string2.length(), string, n2)) continue;
                return n2 + string2.length();
            }
            return ~n2;
        }

        public int scan(String string, int n2) {
            int n3 = string.length();
            for (int i2 = n2; i2 < n3; ++i2) {
                String[] stringArray = this.iSuffixesSortedDescByLength;
                int n4 = this.iSuffixesSortedDescByLength.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    String string2 = stringArray[i3];
                    if (!string.regionMatches(true, i2, string2, 0, string2.length()) || this.matchesOtherAffix(string2.length(), string, i2)) continue;
                    return i2;
                }
            }
            return ~n2;
        }

        public String[] getAffixes() {
            return (String[])this.iSuffixes.clone();
        }
    }

    static class PluralAffix
    extends IgnorableAffix {
        private final String iSingularText;
        private final String iPluralText;

        PluralAffix(String string, String string2) {
            this.iSingularText = string;
            this.iPluralText = string2;
        }

        public int calculatePrintedLength(int n2) {
            return (n2 == 1 ? this.iSingularText : this.iPluralText).length();
        }

        public void printTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append(n2 == 1 ? this.iSingularText : this.iPluralText);
        }

        public void printTo(Writer writer, int n2) throws IOException {
            writer.write(n2 == 1 ? this.iSingularText : this.iPluralText);
        }

        public int parse(String string, int n2) {
            String string2 = this.iPluralText;
            String string3 = this.iSingularText;
            if (string2.length() < string3.length()) {
                String string4 = string2;
                string2 = string3;
                string3 = string4;
            }
            if (string.regionMatches(true, n2, string2, 0, string2.length()) && !this.matchesOtherAffix(string2.length(), string, n2)) {
                return n2 + string2.length();
            }
            if (string.regionMatches(true, n2, string3, 0, string3.length()) && !this.matchesOtherAffix(string3.length(), string, n2)) {
                return n2 + string3.length();
            }
            return ~n2;
        }

        public int scan(String string, int n2) {
            String string2 = this.iPluralText;
            String string3 = this.iSingularText;
            if (string2.length() < string3.length()) {
                String string4 = string2;
                string2 = string3;
                string3 = string4;
            }
            int n3 = string2.length();
            int n4 = string3.length();
            int n5 = string.length();
            for (int i2 = n2; i2 < n5; ++i2) {
                if (string.regionMatches(true, i2, string2, 0, n3) && !this.matchesOtherAffix(string2.length(), string, i2)) {
                    return i2;
                }
                if (!string.regionMatches(true, i2, string3, 0, n4) || this.matchesOtherAffix(string3.length(), string, i2)) continue;
                return i2;
            }
            return ~n2;
        }

        public String[] getAffixes() {
            return new String[]{this.iSingularText, this.iPluralText};
        }
    }

    static class SimpleAffix
    extends IgnorableAffix {
        private final String iText;

        SimpleAffix(String string) {
            this.iText = string;
        }

        public int calculatePrintedLength(int n2) {
            return this.iText.length();
        }

        public void printTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append(this.iText);
        }

        public void printTo(Writer writer, int n2) throws IOException {
            writer.write(this.iText);
        }

        public int parse(String string, int n2) {
            String string2 = this.iText;
            int n3 = string2.length();
            if (string.regionMatches(true, n2, string2, 0, n3) && !this.matchesOtherAffix(n3, string, n2)) {
                return n2 + n3;
            }
            return ~n2;
        }

        public int scan(String string, int n2) {
            String string2 = this.iText;
            int n3 = string2.length();
            int n4 = string.length();
            block3: for (int i2 = n2; i2 < n4; ++i2) {
                if (string.regionMatches(true, i2, string2, 0, n3) && !this.matchesOtherAffix(n3, string, i2)) {
                    return i2;
                }
                switch (string.charAt(i2)) {
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block3;
                    }
                }
            }
            return ~n2;
        }

        public String[] getAffixes() {
            return new String[]{this.iText};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class IgnorableAffix
    implements PeriodFieldAffix {
        private volatile String[] iOtherAffixes;

        IgnorableAffix() {
        }

        @Override
        public void finish(Set<PeriodFieldAffix> set) {
            if (this.iOtherAffixes == null) {
                int n2 = Integer.MAX_VALUE;
                String stringArray = null;
                for (String stringArray2 : this.getAffixes()) {
                    if (stringArray2.length() >= n2) continue;
                    n2 = stringArray2.length();
                    stringArray = stringArray2;
                }
                HashSet hashSet = new HashSet();
                for (PeriodFieldAffix periodFieldAffix : set) {
                    if (periodFieldAffix == null) continue;
                    for (String string : periodFieldAffix.getAffixes()) {
                        if (string.length() <= n2 && (!string.equalsIgnoreCase(stringArray) || string.equals(stringArray))) continue;
                        hashSet.add(string);
                    }
                }
                HashSet hashSet2 = hashSet;
                this.iOtherAffixes = hashSet2.toArray(new String[hashSet2.size()]);
            }
        }

        protected boolean matchesOtherAffix(int n2, String string, int n3) {
            if (this.iOtherAffixes != null) {
                String[] stringArray = this.iOtherAffixes;
                int n4 = this.iOtherAffixes.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    String string2 = stringArray[i2];
                    int n5 = string2.length();
                    if ((n2 >= n5 || !string.regionMatches(true, n3, string2, 0, n5)) && (n2 != n5 || !string.regionMatches(false, n3, string2, 0, n5))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public void printTo(StringBuffer var1, int var2);

        public void printTo(Writer var1, int var2) throws IOException;

        public int parse(String var1, int var2);

        public int scan(String var1, int var2);

        public String[] getAffixes();

        public void finish(Set<PeriodFieldAffix> var1);
    }
}

