/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    static final Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object object = argArray[argArray.length - 1];
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        int n2;
        Throwable throwable = MessageFormatter.getThrowableCandidate(argArray);
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwable);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(messagePattern.length() + 50);
        for (n2 = 0; n2 < argArray.length; ++n2) {
            int n4 = messagePattern.indexOf(DELIM_STR, n3);
            if (n4 == -1) {
                if (n3 == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwable);
                }
                stringBuilder.append(messagePattern.substring(n3, messagePattern.length()));
                return new FormattingTuple(stringBuilder.toString(), argArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, n4)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, n4)) {
                    --n2;
                    stringBuilder.append(messagePattern.substring(n3, n4 - 1));
                    stringBuilder.append('{');
                    n3 = n4 + 1;
                    continue;
                }
                stringBuilder.append(messagePattern.substring(n3, n4 - 1));
                MessageFormatter.deeplyAppendParameter(stringBuilder, argArray[n2], new HashMap<Object[], Object>());
                n3 = n4 + 2;
                continue;
            }
            stringBuilder.append(messagePattern.substring(n3, n4));
            MessageFormatter.deeplyAppendParameter(stringBuilder, argArray[n2], new HashMap<Object[], Object>());
            n3 = n4 + 2;
        }
        stringBuilder.append(messagePattern.substring(n3, messagePattern.length()));
        if (n2 < argArray.length - 1) {
            return new FormattingTuple(stringBuilder.toString(), argArray, throwable);
        }
        return new FormattingTuple(stringBuilder.toString(), argArray, null);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char c2 = messagePattern.charAt(delimeterStartIndex - 1);
        return c2 == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o2, Map<Object[], Object> seenMap) {
        if (o2 == null) {
            sbuf.append("null");
            return;
        }
        if (!o2.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o2);
            return;
        }
        if (o2 instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o2);
            return;
        }
        if (o2 instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o2);
            return;
        }
        if (o2 instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o2);
            return;
        }
        if (o2 instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o2);
            return;
        }
        if (o2 instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o2);
            return;
        }
        if (o2 instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o2);
            return;
        }
        if (o2 instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o2);
            return;
        }
        if (o2 instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o2);
            return;
        }
        MessageFormatter.objectArrayAppend(sbuf, (Object[])o2, seenMap);
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o2) {
        try {
            String string = o2.toString();
            sbuf.append(string);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + o2.getClass().getName() + "]");
            throwable.printStackTrace();
            sbuf.append("[FAILED toString()]");
            return;
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a2, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a2)) {
            seenMap.put(a2, null);
            int n2 = a2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageFormatter.deeplyAppendParameter(sbuf, a2[i2], seenMap);
                if (i2 == n2 - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a2);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a2) {
        sbuf.append('[');
        int n2 = a2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            sbuf.append(a2[i2]);
            if (i2 == n2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

