/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.tensorflow.DataType;
import org.tensorflow.TensorFlow;

public final class Tensor<T>
implements AutoCloseable {
    private long nativeHandle;
    private DataType dtype;
    private long[] shapeCopy = null;
    private static HashMap<Class<?>, DataType> classDataTypes = new HashMap<Class<Integer>, DataType>();

    public static <T> Tensor<T> create(Object obj, Class<T> type) {
        DataType dataType = DataType.fromClass(type);
        if (!Tensor.objectCompatWithType(obj, dataType)) {
            throw new IllegalArgumentException("DataType of object does not match T (expected " + (Object)((Object)dataType) + ", got " + (Object)((Object)Tensor.dataTypeOf(obj)) + ")");
        }
        return Tensor.create(obj, dataType);
    }

    public static Tensor<?> create(Object obj) {
        Object object = obj;
        return Tensor.create(object, Tensor.dataTypeOf(object));
    }

    private static Tensor<?> create(Object obj, DataType dtype) {
        Tensor tensor = new Tensor(dtype);
        new Tensor(dtype).shapeCopy = new long[Tensor.numDimensions(obj, dtype)];
        Tensor.fillShape(obj, 0, tensor.shapeCopy);
        if (tensor.dtype != DataType.STRING) {
            int n2 = Tensor.elemByteSize(tensor.dtype) * Tensor.numElements(tensor.shapeCopy);
            tensor.nativeHandle = Tensor.allocate(tensor.dtype.c(), tensor.shapeCopy, n2);
            Tensor.setValue(tensor.nativeHandle, obj);
        } else {
            tensor.nativeHandle = tensor.shapeCopy.length != 0 ? Tensor.allocateNonScalarBytes(tensor.shapeCopy, (Object[])obj) : Tensor.allocateScalarBytes((byte[])obj);
        }
        return tensor;
    }

    public static Tensor<Integer> create(long[] shape, IntBuffer data) {
        Tensor<Integer> tensor = Tensor.allocateForBuffer(DataType.INT32, shape, data.remaining());
        super.buffer().asIntBuffer().put(data);
        return tensor;
    }

    public static Tensor<Float> create(long[] shape, FloatBuffer data) {
        Tensor<Float> tensor = Tensor.allocateForBuffer(DataType.FLOAT, shape, data.remaining());
        super.buffer().asFloatBuffer().put(data);
        return tensor;
    }

    public static Tensor<Double> create(long[] shape, DoubleBuffer data) {
        Tensor<Double> tensor = Tensor.allocateForBuffer(DataType.DOUBLE, shape, data.remaining());
        super.buffer().asDoubleBuffer().put(data);
        return tensor;
    }

    public static Tensor<Long> create(long[] shape, LongBuffer data) {
        Tensor<Long> tensor = Tensor.allocateForBuffer(DataType.INT64, shape, data.remaining());
        super.buffer().asLongBuffer().put(data);
        return tensor;
    }

    public static <T> Tensor<T> create(Class<T> type, long[] shape, ByteBuffer data) {
        Tensor<?> tensor = Tensor.create(DataType.fromClass(type), shape, data);
        return tensor;
    }

    private static Tensor<?> create(DataType dtype, long[] shape, ByteBuffer data) {
        int nremaining;
        if (dtype != DataType.STRING) {
            int n2 = Tensor.elemByteSize(dtype);
            if (data.remaining() % n2 != 0) {
                throw new IllegalArgumentException(String.format("ByteBuffer with %d bytes is not compatible with a %s Tensor (%d bytes/element)", data.remaining(), dtype.toString(), n2));
            }
            nremaining = data.remaining() / n2;
        } else {
            nremaining = data.remaining();
        }
        Tensor tensor = Tensor.allocateForBuffer(dtype, shape, nremaining);
        super.buffer().put(data);
        return tensor;
    }

    public final <U> Tensor<U> expect(Class<U> type) {
        DataType dataType = DataType.fromClass(type);
        if (!dataType.equals((Object)this.dtype)) {
            throw new IllegalArgumentException("Cannot cast from tensor of " + (Object)((Object)this.dtype) + " to tensor of " + (Object)((Object)dataType));
        }
        return this;
    }

    private static <T> Tensor<T> allocateForBuffer(DataType dataType, long[] shape, int nBuffered) {
        int n2;
        int n3 = Tensor.numElements(shape);
        if (dataType != DataType.STRING) {
            if (nBuffered != n3) {
                throw Tensor.incompatibleBuffer(nBuffered, shape);
            }
            n2 = n3 * Tensor.elemByteSize(dataType);
        } else {
            n2 = nBuffered;
        }
        Tensor<T> tensor = new Tensor<T>(dataType);
        new Tensor<T>(dataType).shapeCopy = Arrays.copyOf(shape, shape.length);
        tensor.nativeHandle = Tensor.allocate(tensor.dtype.c(), tensor.shapeCopy, n2);
        return tensor;
    }

    @Override
    public final void close() {
        if (this.nativeHandle != 0L) {
            Tensor.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    public final DataType dataType() {
        return this.dtype;
    }

    public final int numDimensions() {
        return this.shapeCopy.length;
    }

    public final int numBytes() {
        return this.buffer().remaining();
    }

    public final int numElements() {
        return Tensor.numElements(this.shapeCopy);
    }

    public final long[] shape() {
        return this.shapeCopy;
    }

    public final float floatValue() {
        return Tensor.scalarFloat(this.nativeHandle);
    }

    public final double doubleValue() {
        return Tensor.scalarDouble(this.nativeHandle);
    }

    public final int intValue() {
        return Tensor.scalarInt(this.nativeHandle);
    }

    public final long longValue() {
        return Tensor.scalarLong(this.nativeHandle);
    }

    public final boolean booleanValue() {
        return Tensor.scalarBoolean(this.nativeHandle);
    }

    public final byte[] bytesValue() {
        return Tensor.scalarBytes(this.nativeHandle);
    }

    public final <U> U copyTo(U dst) {
        this.throwExceptionIfTypeIsIncompatible(dst);
        Tensor.readNDArray(this.nativeHandle, dst);
        return dst;
    }

    public final void writeTo(IntBuffer dst) {
        if (this.dtype != DataType.INT32) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        dst.put(byteBuffer.asIntBuffer());
    }

    public final void writeTo(FloatBuffer dst) {
        if (this.dtype != DataType.FLOAT) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        dst.put(byteBuffer.asFloatBuffer());
    }

    public final void writeTo(DoubleBuffer dst) {
        if (this.dtype != DataType.DOUBLE) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        dst.put(byteBuffer.asDoubleBuffer());
    }

    public final void writeTo(LongBuffer dst) {
        if (this.dtype != DataType.INT64) {
            throw Tensor.incompatibleBuffer(dst, this.dtype);
        }
        ByteBuffer byteBuffer = this.buffer();
        dst.put(byteBuffer.asLongBuffer());
    }

    public final void writeTo(ByteBuffer dst) {
        ByteBuffer byteBuffer = this.buffer();
        dst.put(byteBuffer);
    }

    public final String toString() {
        return String.format("%s tensor with shape %s", this.dtype.toString(), Arrays.toString(this.shape()));
    }

    static Tensor<?> fromHandle(long handle) {
        Tensor tensor = new Tensor(DataType.fromC(Tensor.dtype(handle)));
        new Tensor(DataType.fromC(Tensor.dtype(handle))).shapeCopy = Tensor.shape(handle);
        tensor.nativeHandle = handle;
        return tensor;
    }

    final long getNativeHandle() {
        return this.nativeHandle;
    }

    private Tensor(DataType t2) {
        this.dtype = t2;
    }

    private ByteBuffer buffer() {
        return Tensor.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static IllegalArgumentException incompatibleBuffer(Buffer buf, DataType dataType) {
        return new IllegalArgumentException(String.format("cannot use %s with Tensor of type %s", new Object[]{buf.getClass().getName(), dataType}));
    }

    private static IllegalArgumentException incompatibleBuffer(int numElements, long[] shape) {
        return new IllegalArgumentException(String.format("buffer with %d elements is not compatible with a Tensor with shape %s", numElements, Arrays.toString(shape)));
    }

    private static int numElements(long[] shape) {
        int n2 = 1;
        for (int i2 = 0; i2 < shape.length; ++i2) {
            n2 *= (int)shape[i2];
        }
        return n2;
    }

    private static int elemByteSize(DataType dataType) {
        int n2 = dataType.byteSize();
        if (n2 < 0) {
            throw new IllegalArgumentException("STRING tensors do not have a fixed element size");
        }
        return n2;
    }

    private static void throwExceptionIfNotByteOfByteArrays(Object array) {
        if (!array.getClass().getName().equals("[[B")) {
            throw new IllegalArgumentException("object cannot be converted to a Tensor as it includes an array with null elements");
        }
    }

    private static Class<?> baseObjType(Object o2) {
        Class<?> clazz = o2.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    private static DataType dataTypeOf(Object o2) {
        Class<?> clazz = Tensor.baseObjType(o2);
        return Tensor.dataTypeFromClass(clazz);
    }

    private static DataType dataTypeFromClass(Class<?> c2) {
        DataType dataType = classDataTypes.get(c2);
        if (dataType != null) {
            return dataType;
        }
        throw new IllegalArgumentException("cannot create Tensors of type " + c2.getName());
    }

    private static int numDimensions(Object o2, DataType dtype) {
        int n2 = Tensor.numArrayDimensions(o2);
        if (dtype == DataType.STRING && n2 > 0) {
            return n2 - 1;
        }
        return n2;
    }

    private static int numArrayDimensions(Object o2) {
        Class<?> clazz = o2.getClass();
        int n2 = 0;
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n2;
        }
        return n2;
    }

    private static void fillShape(Object o2, int dim, long[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int n2 = Array.getLength(o2);
        if (n2 == 0) {
            throw new IllegalArgumentException("cannot create Tensors with a 0 dimension");
        }
        if (shape[dim] == 0L) {
            shape[dim] = n2;
        } else if (shape[dim] != (long)n2) {
            throw new IllegalArgumentException(String.format("mismatched lengths (%d and %d) in dimension %d", shape[dim], n2, dim));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Tensor.fillShape(Array.get(o2, i2), dim + 1, shape);
        }
    }

    private static boolean objectCompatWithType(Object obj, DataType dtype) {
        Class<?> clazz = Tensor.baseObjType(obj);
        DataType dataType = Tensor.dataTypeFromClass(clazz);
        int n2 = Tensor.numDimensions(obj, dataType);
        if (!clazz.isPrimitive() && clazz != String.class && n2 != 0) {
            throw new IllegalArgumentException("cannot create non-scalar Tensors from arrays of boxed values");
        }
        if (dataType.equals((Object)dtype)) {
            return true;
        }
        return dataType == DataType.STRING && dtype == DataType.UINT8;
    }

    private void throwExceptionIfTypeIsIncompatible(Object o2) {
        int n2 = this.numDimensions();
        int n3 = Tensor.numDimensions(o2, this.dtype);
        if (n3 != n2) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with %d dimensions into an object with %d", n2, n3));
        }
        if (!Tensor.objectCompatWithType(o2, this.dtype)) {
            throw new IllegalArgumentException(String.format("cannot copy Tensor with DataType %s into an object of type %s", this.dtype.toString(), o2.getClass().getName()));
        }
        long[] lArray = new long[n2];
        Tensor.fillShape(o2, 0, lArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] == this.shape()[i2]) continue;
            throw new IllegalArgumentException(String.format("cannot copy Tensor with shape %s into object with shape %s", Arrays.toString(this.shape()), Arrays.toString(lArray)));
        }
    }

    private static native long allocate(int var0, long[] var1, long var2);

    private static native long allocateScalarBytes(byte[] var0);

    private static native long allocateNonScalarBytes(long[] var0, Object[] var1);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native int dtype(long var0);

    private static native long[] shape(long var0);

    private static native void setValue(long var0, Object var2);

    private static native float scalarFloat(long var0);

    private static native double scalarDouble(long var0);

    private static native int scalarInt(long var0);

    private static native long scalarLong(long var0);

    private static native boolean scalarBoolean(long var0);

    private static native byte[] scalarBytes(long var0);

    private static native void readNDArray(long var0, Object var2);

    static {
        classDataTypes.put(Integer.TYPE, DataType.INT32);
        classDataTypes.put(Integer.class, DataType.INT32);
        classDataTypes.put(Long.TYPE, DataType.INT64);
        classDataTypes.put(Long.class, DataType.INT64);
        classDataTypes.put(Float.TYPE, DataType.FLOAT);
        classDataTypes.put(Float.class, DataType.FLOAT);
        classDataTypes.put(Double.TYPE, DataType.DOUBLE);
        classDataTypes.put(Double.class, DataType.DOUBLE);
        classDataTypes.put(Byte.TYPE, DataType.STRING);
        classDataTypes.put(Byte.class, DataType.STRING);
        classDataTypes.put(Boolean.TYPE, DataType.BOOL);
        classDataTypes.put(Boolean.class, DataType.BOOL);
        TensorFlow.init();
    }
}

