/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CTCLoss
extends PrimitiveOp {
    private Output<Float> loss;
    private Output<Float> gradient;

    public static CTCLoss create(Scope scope, Operand<Float> inputs, Operand<Long> labelsIndices, Operand<Integer> labelsValues, Operand<Integer> sequenceLength, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CTCLoss", scope.makeOpName("CTCLoss"));
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(labelsIndices.asOutput());
        operationBuilder.addInput(labelsValues.asOutput());
        operationBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.preprocessCollapseRepeated != null) {
                    operationBuilder.setAttr("preprocess_collapse_repeated", options2.preprocessCollapseRepeated);
                }
                if (options2.ctcMergeRepeated != null) {
                    operationBuilder.setAttr("ctc_merge_repeated", options2.ctcMergeRepeated);
                }
                if (options2.ignoreLongerOutputsThanInputs == null) continue;
                operationBuilder.setAttr("ignore_longer_outputs_than_inputs", options2.ignoreLongerOutputsThanInputs);
            }
        }
        return new CTCLoss(operationBuilder.build());
    }

    public static Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
        return new Options().preprocessCollapseRepeated(preprocessCollapseRepeated);
    }

    public static Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
        return new Options().ctcMergeRepeated(ctcMergeRepeated);
    }

    public static Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
        return new Options().ignoreLongerOutputsThanInputs(ignoreLongerOutputsThanInputs);
    }

    public final Output<Float> loss() {
        return this.loss;
    }

    public final Output<Float> gradient() {
        return this.gradient;
    }

    private CTCLoss(Operation operation) {
        super(operation);
        this.loss = operation.output(0);
        this.gradient = operation.output(1);
    }

    public static class Options {
        private Boolean preprocessCollapseRepeated;
        private Boolean ctcMergeRepeated;
        private Boolean ignoreLongerOutputsThanInputs;

        public Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
            this.preprocessCollapseRepeated = preprocessCollapseRepeated;
            return this;
        }

        public Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
            this.ctcMergeRepeated = ctcMergeRepeated;
            return this;
        }

        public Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
            this.ignoreLongerOutputsThanInputs = ignoreLongerOutputsThanInputs;
            return this;
        }

        private Options() {
        }
    }
}

