/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeRaw<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> DecodeRaw<T> create(Scope scope, Operand<String> bytes, Class<T> outType, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DecodeRaw", scope.makeOpName("DecodeRaw"));
        operationBuilder.addInput(bytes.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.littleEndian == null) continue;
                operationBuilder.setAttr("little_endian", options2.littleEndian);
            }
        }
        return new DecodeRaw<T>(operationBuilder.build());
    }

    public static Options littleEndian(Boolean littleEndian) {
        return new Options().littleEndian(littleEndian);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private DecodeRaw(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean littleEndian;

        public Options littleEndian(Boolean littleEndian) {
            this.littleEndian = littleEndian;
            return this;
        }

        private Options() {
        }
    }
}

