/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Enter<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Enter<T> create(Scope scope, Operand<T> data, String frameName, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Enter", scope.makeOpName("Enter"));
        operationBuilder.addInput(data.asOutput());
        operationBuilder.setAttr("frame_name", frameName);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.isConstant != null) {
                    operationBuilder.setAttr("is_constant", options2.isConstant);
                }
                if (options2.parallelIterations == null) continue;
                operationBuilder.setAttr("parallel_iterations", options2.parallelIterations);
            }
        }
        return new Enter<T>(operationBuilder.build());
    }

    public static Options isConstant(Boolean isConstant) {
        return new Options().isConstant(isConstant);
    }

    public static Options parallelIterations(Long parallelIterations) {
        return new Options().parallelIterations(parallelIterations);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Enter(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean isConstant;
        private Long parallelIterations;

        public Options isConstant(Boolean isConstant) {
            this.isConstant = isConstant;
            return this;
        }

        public Options parallelIterations(Long parallelIterations) {
            this.parallelIterations = parallelIterations;
            return this;
        }

        private Options() {
        }
    }
}

