/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Op;
import org.tensorflow.op.Operands;
import org.tensorflow.op.Scope;

public class Gradients
implements Iterable<Operand<?>>,
Op {
    private List<Output<?>> dy;

    public static Gradients create(Scope scope, Iterable<? extends Operand<?>> y2, Iterable<? extends Operand<?>> x2, Options ... options) {
        Object[] objectArray;
        Output<?>[] outputArray = null;
        if (options != null) {
            objectArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = objectArray[i2];
                if (options2.dx == null) continue;
                outputArray = Operands.asOutputs(options2.dx);
            }
        }
        objectArray = scope.graph().addGradients(scope.makeOpName("Gradients"), Operands.asOutputs(y2), Operands.asOutputs(x2), outputArray);
        return new Gradients(Arrays.asList(objectArray));
    }

    public static Gradients create(Scope scope, Operand<?> y2, Iterable<? extends Operand<?>> x2, Options ... options) {
        return Gradients.create(scope, Arrays.asList(y2), x2, options);
    }

    public static Options dx(Iterable<? extends Operand<?>> dx) {
        return new Options().dx(dx);
    }

    @Override
    public Iterator<Operand<?>> iterator() {
        return this.dy.iterator();
    }

    public List<Output<?>> dy() {
        return this.dy;
    }

    public <T> Output<T> dy(int index) {
        return this.dy.get(index);
    }

    private Gradients(List<Output<?>> dy) {
        this.dy = dy;
    }

    public static class Options {
        private Iterable<? extends Operand<?>> dx;

        public Options dx(Iterable<? extends Operand<?>> dx) {
            this.dx = dx;
            return this;
        }

        private Options() {
        }
    }
}

