/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MatMul<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> product;

    public static <T> MatMul<T> create(Scope scope, Operand<T> a2, Operand<T> b2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MatMul", scope.makeOpName("MatMul"));
        operationBuilder.addInput(a2.asOutput());
        operationBuilder.addInput(b2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.transposeA != null) {
                    operationBuilder.setAttr("transpose_a", options2.transposeA);
                }
                if (options2.transposeB == null) continue;
                operationBuilder.setAttr("transpose_b", options2.transposeB);
            }
        }
        return new MatMul<T>(operationBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public final Output<T> product() {
        return this.product;
    }

    @Override
    public final Output<T> asOutput() {
        return this.product;
    }

    private MatMul(Operation operation) {
        super(operation);
        this.product = operation.output(0);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        private Options() {
        }
    }
}

