/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MaxPool3DGrad<U extends Number>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> output;

    public static <U extends Number, T extends Number> MaxPool3DGrad<U> create(Scope scope, Operand<T> origInput, Operand<T> origOutput, Operand<U> grad, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MaxPool3DGrad", scope.makeOpName("MaxPool3DGrad"));
        operationBuilder.addInput(origInput.asOutput());
        operationBuilder.addInput(origOutput.asOutput());
        operationBuilder.addInput(grad.asOutput());
        long[] lArray = new long[ksize.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = ksize.get(i2);
        }
        operationBuilder.setAttr("ksize", lArray);
        long[] lArray2 = new long[strides.size()];
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            lArray2[i3] = strides.get(i3);
        }
        operationBuilder.setAttr("strides", lArray2);
        operationBuilder.setAttr("padding", padding);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i4 = 0; i4 < n2; ++i4) {
                Options options2 = optionsArray[i4];
                if (options2.dataFormat == null) continue;
                operationBuilder.setAttr("data_format", options2.dataFormat);
            }
        }
        return new MaxPool3DGrad<U>(operationBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public final Output<U> output() {
        return this.output;
    }

    @Override
    public final Output<U> asOutput() {
        return this.output;
    }

    private MaxPool3DGrad(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String dataFormat;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        private Options() {
        }
    }
}

