/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Print<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Print<T> create(Scope scope, Operand<T> input, Iterable<Operand<?>> data, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Print", scope.makeOpName("Print"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(data));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.message != null) {
                    operationBuilder.setAttr("message", options2.message);
                }
                if (options2.firstN != null) {
                    operationBuilder.setAttr("first_n", options2.firstN);
                }
                if (options2.summarize == null) continue;
                operationBuilder.setAttr("summarize", options2.summarize);
            }
        }
        return new Print<T>(operationBuilder.build());
    }

    public static Options message(String message) {
        return new Options().message(message);
    }

    public static Options firstN(Long firstN) {
        return new Options().firstN(firstN);
    }

    public static Options summarize(Long summarize) {
        return new Options().summarize(summarize);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Print(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String message;
        private Long firstN;
        private Long summarize;

        public Options message(String message) {
            this.message = message;
            return this;
        }

        public Options firstN(Long firstN) {
            this.firstN = firstN;
            return this;
        }

        public Options summarize(Long summarize) {
            this.summarize = summarize;
            return this;
        }

        private Options() {
        }
    }
}

