/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantizeV2<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantizeV2<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizeAndDequantizeV2", scope.makeOpName("QuantizeAndDequantizeV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(inputMin.asOutput());
        operationBuilder.addInput(inputMax.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.signedInput != null) {
                    operationBuilder.setAttr("signed_input", options2.signedInput);
                }
                if (options2.numBits != null) {
                    operationBuilder.setAttr("num_bits", options2.numBits);
                }
                if (options2.rangeGiven != null) {
                    operationBuilder.setAttr("range_given", options2.rangeGiven);
                }
                if (options2.roundMode == null) continue;
                operationBuilder.setAttr("round_mode", options2.roundMode);
            }
        }
        return new QuantizeAndDequantizeV2<T>(operationBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantizeV2(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private String roundMode;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        private Options() {
        }
    }
}

