/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedConv2D<V>
extends PrimitiveOp {
    private Output<V> output;
    private Output<Float> minOutput;
    private Output<Float> maxOutput;

    public static <V, T, U> QuantizedConv2D<V> create(Scope scope, Operand<T> input, Operand<U> filter, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minFilter, Operand<Float> maxFilter, Class<V> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedConv2D", scope.makeOpName("QuantizedConv2D"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(filter.asOutput());
        operationBuilder.addInput(minInput.asOutput());
        operationBuilder.addInput(maxInput.asOutput());
        operationBuilder.addInput(minFilter.asOutput());
        operationBuilder.addInput(maxFilter.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        long[] lArray = new long[strides.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = strides.get(i2);
        }
        operationBuilder.setAttr("strides", lArray);
        operationBuilder.setAttr("padding", padding);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.dilations == null) continue;
                long[] lArray2 = new long[options2.dilations.size()];
                for (int i4 = 0; i4 < lArray2.length; ++i4) {
                    lArray2[i4] = (Long)options2.dilations.get(i4);
                }
                operationBuilder.setAttr("dilations", lArray2);
            }
        }
        return new QuantizedConv2D<V>(operationBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public final Output<V> output() {
        return this.output;
    }

    public final Output<Float> minOutput() {
        return this.minOutput;
    }

    public final Output<Float> maxOutput() {
        return this.maxOutput;
    }

    private QuantizedConv2D(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.minOutput = operation.output(1);
        this.maxOutput = operation.output(2);
    }

    public static class Options {
        private List<Long> dilations;

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

