/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QueueDequeue
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> components;

    public static QueueDequeue create(Scope scope, Operand<?> handle, List<Class<?>> componentTypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QueueDequeueV2", scope.makeOpName("QueueDequeue"));
        operationBuilder.addInput(handle.asOutput());
        DataType[] dataTypeArray = new DataType[componentTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(componentTypes.get(i2));
        }
        operationBuilder.setAttr("component_types", dataTypeArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.timeoutMs == null) continue;
                operationBuilder.setAttr("timeout_ms", options2.timeoutMs);
            }
        }
        return new QueueDequeue(operationBuilder.build());
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public final List<Output<?>> components() {
        return this.components;
    }

    @Override
    public final Iterator<Operand<Object>> iterator() {
        return this.components.iterator();
    }

    private QueueDequeue(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(0, n2));
    }

    public static class Options {
        private Long timeoutMs;

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        private Options() {
        }
    }
}

