/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResizeBilinear
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> resizedImages;

    public static <T extends Number> ResizeBilinear create(Scope scope, Operand<T> images, Operand<Integer> size, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResizeBilinear", scope.makeOpName("ResizeBilinear"));
        operationBuilder.addInput(images.asOutput());
        operationBuilder.addInput(size.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.alignCorners == null) continue;
                operationBuilder.setAttr("align_corners", options2.alignCorners);
            }
        }
        return new ResizeBilinear(operationBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public final Output<Float> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.resizedImages;
    }

    private ResizeBilinear(Operation operation) {
        super(operation);
        this.resizedImages = operation.output(0);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

