/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Skipgram
extends PrimitiveOp {
    private Output<String> vocabWord;
    private Output<Integer> vocabFreq;
    private Output<Long> wordsPerEpoch;
    private Output<Integer> currentEpoch;
    private Output<Long> totalWordsProcessed;
    private Output<Integer> examples;
    private Output<Integer> labels;

    public static Skipgram create(Scope scope, String filename, Long batchSize, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Skipgram", scope.makeOpName("Skipgram"));
        operationBuilder.setAttr("filename", filename);
        operationBuilder.setAttr("batch_size", batchSize);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.windowSize != null) {
                    operationBuilder.setAttr("window_size", options2.windowSize);
                }
                if (options2.minCount != null) {
                    operationBuilder.setAttr("min_count", options2.minCount);
                }
                if (options2.subsample == null) continue;
                operationBuilder.setAttr("subsample", options2.subsample.floatValue());
            }
        }
        return new Skipgram(operationBuilder.build());
    }

    public static Options windowSize(Long windowSize) {
        return new Options().windowSize(windowSize);
    }

    public static Options minCount(Long minCount) {
        return new Options().minCount(minCount);
    }

    public static Options subsample(Float subsample) {
        return new Options().subsample(subsample);
    }

    public final Output<String> vocabWord() {
        return this.vocabWord;
    }

    public final Output<Integer> vocabFreq() {
        return this.vocabFreq;
    }

    public final Output<Long> wordsPerEpoch() {
        return this.wordsPerEpoch;
    }

    public final Output<Integer> currentEpoch() {
        return this.currentEpoch;
    }

    public final Output<Long> totalWordsProcessed() {
        return this.totalWordsProcessed;
    }

    public final Output<Integer> examples() {
        return this.examples;
    }

    public final Output<Integer> labels() {
        return this.labels;
    }

    private Skipgram(Operation operation) {
        super(operation);
        this.vocabWord = operation.output(0);
        this.vocabFreq = operation.output(1);
        this.wordsPerEpoch = operation.output(2);
        this.currentEpoch = operation.output(3);
        this.totalWordsProcessed = operation.output(4);
        this.examples = operation.output(5);
        this.labels = operation.output(6);
    }

    public static class Options {
        private Long windowSize;
        private Long minCount;
        private Float subsample;

        public Options windowSize(Long windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Options minCount(Long minCount) {
            this.minCount = minCount;
            return this;
        }

        public Options subsample(Float subsample) {
            this.subsample = subsample;
            return this;
        }

        private Options() {
        }
    }
}

