/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseReduceMaxSparse<T extends Number>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T extends Number> SparseReduceMaxSparse<T> create(Scope scope, Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseReduceMaxSparse", scope.makeOpName("SparseReduceMaxSparse"));
        operationBuilder.addInput(inputIndices.asOutput());
        operationBuilder.addInput(inputValues.asOutput());
        operationBuilder.addInput(inputShape.asOutput());
        operationBuilder.addInput(reductionAxes.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.keepDims == null) continue;
                operationBuilder.setAttr("keep_dims", options2.keepDims);
            }
        }
        return new SparseReduceMaxSparse<T>(operationBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public final Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public final Output<T> outputValues() {
        return this.outputValues;
    }

    public final Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseReduceMaxSparse(Operation operation) {
        super(operation);
        this.outputIndices = operation.output(0);
        this.outputValues = operation.output(1);
        this.outputShape = operation.output(2);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

