/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TemporaryVariable<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> ref;

    public static <T> TemporaryVariable<T> create(Scope scope, Shape shape, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TemporaryVariable", scope.makeOpName("TemporaryVariable"));
        operationBuilder.setAttr("shape", shape);
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.varName == null) continue;
                operationBuilder.setAttr("var_name", options2.varName);
            }
        }
        return new TemporaryVariable<T>(operationBuilder.build());
    }

    public static Options varName(String varName) {
        return new Options().varName(varName);
    }

    public final Output<T> ref() {
        return this.ref;
    }

    @Override
    public final Output<T> asOutput() {
        return this.ref;
    }

    private TemporaryVariable(Operation operation) {
        super(operation);
        this.ref = operation.output(0);
    }

    public static class Options {
        private String varName;

        public Options varName(String varName) {
            this.varName = varName;
            return this;
        }

        private Options() {
        }
    }
}

